/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Image;
import java.awt.image.AbstractMultiResolutionImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class BaseMultiResolutionImage
extends AbstractMultiResolutionImage {
    private final int baseImageIndex;
    private final Image[] resolutionVariants;

    public BaseMultiResolutionImage(Image ... imageArray) {
        this(0, imageArray);
    }

    public BaseMultiResolutionImage(int n, Image ... imageArray) {
        if (imageArray == null || imageArray.length == 0) {
            throw new IllegalArgumentException("Null or zero-length array is passed");
        }
        if (n < 0 || n >= imageArray.length) {
            throw new IndexOutOfBoundsException("Invalid base image index: " + n);
        }
        this.baseImageIndex = n;
        for (Image image : this.resolutionVariants = Arrays.copyOf(imageArray, imageArray.length)) {
            Objects.requireNonNull(image, "Resolution variant can't be null");
        }
    }

    @Override
    public Image getResolutionVariant(double d, double d2) {
        BaseMultiResolutionImage.checkSize(d, d2);
        for (Image image : this.resolutionVariants) {
            if (!(d <= (double)image.getWidth(null)) || !(d2 <= (double)image.getHeight(null))) continue;
            return image;
        }
        return this.resolutionVariants[this.resolutionVariants.length - 1];
    }

    private static void checkSize(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException(String.format("Width (%s) or height (%s) cannot be <= 0", d, d2));
        }
        if (!Double.isFinite(d) || !Double.isFinite(d2)) {
            throw new IllegalArgumentException(String.format("Width (%s) or height (%s) is not finite", d, d2));
        }
    }

    @Override
    public List<Image> getResolutionVariants() {
        return Collections.unmodifiableList(Arrays.asList(this.resolutionVariants));
    }

    @Override
    protected Image getBaseImage() {
        return this.resolutionVariants[this.baseImageIndex];
    }
}

