/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.javaws.JnlpxArgs;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.ExtendedServiceNSBImpl;
import com.sun.jnlp.FileContentsImpl;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.jnlp.ExtendedService;
import javax.jnlp.FileContents;

public final class ExtendedServiceImpl
implements ExtendedService {
    private static ExtendedService _sharedInstance = null;
    static int DEFAULT_FILESIZE = Integer.MAX_VALUE;
    private static final AccessControlContext ACC_FILE_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write");
            ((PermissionCollection)perms).add(perm);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });

    private ExtendedServiceImpl() {
    }

    public static synchronized ExtendedService getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = Platform.get().isNativeSandbox() ? new ExtendedServiceNSBImpl(new ExtendedServiceImpl()) : new ExtendedServiceImpl();
        }
        return _sharedInstance;
    }

    public FileContents openFile(File f) throws IOException {
        if (f == null) {
            return null;
        }
        final File file = new File(f.getPath());
        if (!(CheckServicePermission.hasFileAccessPermissions(file.toString()) || JnlpxArgs.getFileReadWriteList().contains(file.toString()) || this.askUser(file.getPath(), false))) {
            return null;
        }
        Object ret = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return new FileContentsImpl(file, DEFAULT_FILESIZE);
                }
                catch (IOException ioe) {
                    return ioe;
                }
            }
        }, ACC_FILE_INSTANCE);
        if (ret instanceof IOException) {
            throw (IOException)ret;
        }
        return (FileContents)ret;
    }

    boolean openFile(String file) {
        if (file == null) {
            return false;
        }
        return JnlpxArgs.getFileReadWriteList().contains(file) || this.askUser(file, true);
    }

    synchronized boolean askUser(String fileList, boolean forceAskUser) {
        String lable;
        String msg;
        if (!forceAskUser && CheckServicePermission.hasFileAccessPermissions()) {
            return true;
        }
        ApiDialog apiDialog = new ApiDialog();
        String title = ResourceManager.getString((String)"api.extended.open.title");
        ApiDialog.DialogResult result = apiDialog.askUser(title, msg = ResourceManager.getString((String)"api.extended.open.message"), null, lable = ResourceManager.getString((String)"api.extended.open.label"), fileList, false);
        return result == ApiDialog.DialogResult.OK || result == ApiDialog.DialogResult.ALWAYS;
    }

    public FileContents[] openFiles(File[] f) throws IOException {
        if (f == null || f.length <= 0) {
            return null;
        }
        final File[] files = new File[f.length];
        for (int i = 0; i < f.length; ++i) {
            files[i] = new File(f[i].getPath());
        }
        boolean allPermissions = true;
        for (int i = 0; i < files.length; ++i) {
            if (CheckServicePermission.hasFileAccessPermissions(files[i].toString())) continue;
            allPermissions = false;
            break;
        }
        Object fileList = "";
        for (int i = 0; i < files.length; ++i) {
            fileList = (String)fileList + files[i].getPath() + "\n";
        }
        if (!allPermissions && !this.askUser((String)fileList, false)) {
            return null;
        }
        Object[] fcs = AccessController.doPrivileged(new PrivilegedAction<Object[]>(){

            @Override
            public Object[] run() {
                Object[] fcontents = new FileContents[files.length];
                try {
                    for (int i = 0; i < files.length; ++i) {
                        fcontents[i] = new FileContentsImpl(files[i], DEFAULT_FILESIZE);
                    }
                }
                catch (IOException ioe) {
                    fcontents[0] = ioe;
                }
                return fcontents;
            }
        }, ACC_FILE_INSTANCE);
        if (fcs[0] instanceof IOException) {
            throw (IOException)fcs[0];
        }
        return (FileContents[])fcs;
    }

    boolean openFiles(String[] files) {
        if (files == null || files.length <= 0) {
            return false;
        }
        Object fileList = "";
        for (String file : files) {
            fileList = (String)fileList + file + "\n";
        }
        return this.askUser((String)fileList, true);
    }
}

