/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SafeThreadFactory;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.jnlp.AppletAudioClip;
import com.sun.jnlp.AppletContainerCallback;
import com.sun.jnlp.ImageCache;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;

public final class AppletContainer
extends JPanel {
    private static final long serialVersionUID = 2380744538984907309L;
    final AppletContainerCallback callback;
    final Applet applet;
    final String appletName;
    final URL documentBase;
    final URL codeBase;
    final Properties parameters;
    final boolean[] isActive = new boolean[]{false};
    int appletWidth;
    int appletHeight;
    final JLabel statusLabel = new JLabel("");
    static PrivilegedAction<?> loadImageActionDummy = new LoadImageAction(null);

    public AppletContainer(AppletContainerCallback callback, Applet applet, String name, URL documentBase, URL codeBase, int width, int height, Properties parameters) {
        this.callback = callback;
        this.applet = applet;
        this.appletName = name;
        this.documentBase = documentBase;
        this.codeBase = codeBase;
        this.parameters = parameters;
        this.isActive[0] = false;
        this.appletWidth = width;
        this.appletHeight = height;
        AppletContainerContext ac = new AppletContainerContext();
        AppletContainerStub as = new AppletContainerStub(ac);
        applet.setStub(as);
        this.statusLabel.setBorder(new EtchedBorder());
        this.statusLabel.setText("Loading...");
        this.setLayout(new BorderLayout());
        this.add("Center", applet);
        this.add("South", this.statusLabel);
        Dimension d = new Dimension(this.appletWidth, this.appletHeight + (int)this.statusLabel.getPreferredSize().getHeight());
        this.setPreferredSize(d);
    }

    public Applet getApplet() {
        return this.applet;
    }

    public void setStatus(String msg) {
        this.statusLabel.setText(msg);
    }

    public void resizeApplet(int width, int height) {
        if (width < 0 || height < 0) {
            return;
        }
        int deltaWidth = width - this.appletWidth;
        int deltaHeight = height - this.appletHeight;
        Dimension curDim = this.getSize();
        Dimension newDim = new Dimension((int)curDim.getWidth() + deltaWidth, (int)curDim.getHeight() + deltaHeight);
        this.setSize(newDim);
        this.callback.relativeResize(new Dimension(deltaWidth, deltaHeight));
        this.appletWidth = width;
        this.appletHeight = height;
    }

    public Dimension getPreferredFrameSize(Frame f) {
        Insets insets = f.getInsets();
        int w = this.appletWidth + (insets.left + insets.right);
        int h = this.appletHeight + this.statusLabel.getHeight() + (insets.top + insets.bottom);
        return new Dimension(w, h);
    }

    public void startApplet() {
        ImageCache.initialize();
        new AppletAudioClip();
        new Thread(){

            @Override
            public void run() {
                try {
                    AppletContainer.this.setStatus("Initializing Applet");
                    AppletContainer.this.applet.init();
                    try {
                        AppletContainer.this.isActive[0] = true;
                        AppletContainer.this.applet.start();
                        AppletContainer.this.setStatus("Applet running...");
                    }
                    catch (Throwable e) {
                        AppletContainer.this.setStatus("Failed to start Applet: " + e.toString());
                        e.printStackTrace(System.out);
                        AppletContainer.this.isActive[0] = false;
                    }
                }
                catch (Throwable e) {
                    AppletContainer.this.setStatus("Failed to initialize: " + e.toString());
                    e.printStackTrace(System.out);
                }
            }
        }.start();
    }

    public void stopApplet() {
        this.applet.stop();
        this.applet.destroy();
        try {
            Main.systemExit(0);
        }
        catch (ExitException ee) {
            Trace.println((String)("systemExit: " + ee), (TraceLevel)TraceLevel.BASIC);
            Trace.ignoredException((Exception)ee);
        }
    }

    static void showApplet(AppletContainerCallback callback, final Applet applet, String name, URL documentBase, URL codeBase, int width, int height, Properties parameters) {
        JFrame frame = new JFrame("Applet Window");
        final AppletContainer container = new AppletContainer(callback, applet, name, documentBase, codeBase, width, height, parameters);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add("Center", container);
        frame.pack();
        frame.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    container.setStatus("Initializing Applet");
                    applet.init();
                    applet.start();
                    container.setStatus("Applet Running");
                }
                catch (Throwable e) {
                    container.setStatus("Failed to start Applet");
                }
            }
        });
    }

    final class AppletContainerStub
    implements AppletStub {
        AppletContext context;

        AppletContainerStub(AppletContext context) {
            this.context = context;
        }

        @Override
        public void appletResize(int width, int height) {
            AppletContainer.this.resizeApplet(width, height);
        }

        @Override
        public AppletContext getAppletContext() {
            return this.context;
        }

        @Override
        public URL getCodeBase() {
            return AppletContainer.this.codeBase;
        }

        @Override
        public URL getDocumentBase() {
            return AppletContainer.this.documentBase;
        }

        @Override
        public String getParameter(String name) {
            return AppletContainer.this.parameters.getProperty(name);
        }

        @Override
        public boolean isActive() {
            return AppletContainer.this.isActive[0];
        }
    }

    class AppletContainerContext
    implements AppletContext {
        AppletContainerContext() {
        }

        @Override
        public Applet getApplet(String name) {
            return name.equals(AppletContainer.this.appletName) ? AppletContainer.this.applet : null;
        }

        @Override
        public Enumeration<Applet> getApplets() {
            Vector<Applet> v = new Vector<Applet>();
            v.add(AppletContainer.this.applet);
            return v.elements();
        }

        @Override
        public AudioClip getAudioClip(URL url) {
            return AppletAudioClip.get(url);
        }

        @Override
        public Image getImage(URL url) {
            LoadImageAction lia = new LoadImageAction(url);
            return (Image)AccessController.doPrivileged(lia);
        }

        @Override
        public void showDocument(final URL url) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread t = SafeThreadFactory.createThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AppletContainer.this.callback.showDocument(url);
                        }
                    });
                    t.start();
                    return null;
                }
            });
        }

        @Override
        public void showDocument(URL url, String target) {
            this.showDocument(url);
        }

        @Override
        public void showStatus(String status) {
            AppletContainer.this.statusLabel.setText(status);
        }

        @Override
        public void setStream(String key, InputStream stream) {
        }

        @Override
        public InputStream getStream(String key) {
            return null;
        }

        @Override
        public Iterator<String> getStreamKeys() {
            return null;
        }
    }

    static class LoadImageAction
    implements PrivilegedAction<Object> {
        URL _url;

        public LoadImageAction(URL url) {
            this._url = url;
        }

        @Override
        public Object run() {
            return ImageCache.getImage(this._url);
        }
    }
}

