/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.util.Property;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.util.VersionString;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLNodeBuilder;
import com.sun.deploy.xml.XMLable;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.Filter;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class ResourcesDesc
implements ResourceType {
    private final List<ResourceType> _list = new CopyOnWriteArrayList<ResourceType>();
    private volatile LaunchDesc _parent = null;
    private volatile boolean _pack200Enabled = false;
    private volatile boolean _versionEnabled = false;
    private volatile int _concurrentDownloads = 0;
    private Filter filter = null;

    public void setPack200Enabled() {
        this._pack200Enabled = true;
    }

    public void setVersionEnabled() {
        this._versionEnabled = true;
    }

    public boolean isPack200Enabled() {
        return this._pack200Enabled;
    }

    public boolean isVersionEnabled() {
        return this._versionEnabled;
    }

    public void setConcurrentDownloads(int n) {
        this._concurrentDownloads = n;
    }

    public int getConcurrentDownloads() {
        if (this._concurrentDownloads <= 0) {
            return Property.CONCURRENT_DOWNLOADS_DEF;
        }
        if (this._concurrentDownloads > 10) {
            return 10;
        }
        return this._concurrentDownloads;
    }

    public LaunchDesc getParent() {
        return this._parent;
    }

    void setParent(LaunchDesc parent) {
        this._parent = parent;
        for (int i = 0; i < this._list.size(); ++i) {
            JREDesc jredesc;
            ResourceType o = this._list.get(i);
            if (!(o instanceof JREDesc) || (jredesc = (JREDesc)o).getNestedResources() == null) continue;
            jredesc.getNestedResources().setParent(parent);
        }
    }

    public void addResource(ResourceType rd) {
        if (rd != null) {
            this._list.add(rd);
        }
    }

    boolean isEmpty() {
        return this._list.isEmpty();
    }

    public JARDesc[] getLocalJarDescs() {
        ArrayList<JARDesc> jds = new ArrayList<JARDesc>(this._list.size());
        for (ResourceType rt : this._list) {
            if (!(rt instanceof JARDesc)) continue;
            jds.add((JARDesc)rt);
        }
        return jds.toArray(new JARDesc[jds.size()]);
    }

    public ExtensionDesc[] getExtensionDescs() {
        final ArrayList extList = new ArrayList();
        this.visit(new ResourceVisitor(){

            @Override
            public void visitExtensionDesc(ExtensionDesc ed) {
                ResourcesDesc.this.addExtToList(extList);
            }
        });
        return extList.toArray(new ExtensionDesc[extList.size()]);
    }

    public JARDesc[] getEagerOrAllJarDescs(boolean allResources) {
        final HashSet<String> eagerParts = new HashSet<String>();
        if (!allResources) {
            this.visit(new ResourceVisitor(){

                @Override
                public void visitJARDesc(JARDesc jd) {
                    if (!jd.isLazyDownload() && jd.getPartName() != null) {
                        eagerParts.add(jd.getPartName());
                    }
                }
            });
        }
        ArrayList<JARDesc> jarList = new ArrayList<JARDesc>();
        this.addJarsToList(jarList, eagerParts, allResources, true);
        return jarList.toArray(new JARDesc[jarList.size()]);
    }

    private void addExtToList(final List<ExtensionDesc> list) {
        this.visit(new ResourceVisitor(){

            @Override
            public void visitExtensionDesc(ExtensionDesc ed) {
                if (ed.getExtensionDesc() != null) {
                    ed.getExtensionDesc().getMainJar();
                    ResourcesDesc rd = ed.getExtensionDesc().getResources();
                    if (rd != null) {
                        rd.addExtToList(list);
                    }
                }
                list.add(ed);
            }
        });
    }

    private void addJarsToList(final List<JARDesc> list, final Set<String> includeParts, final boolean includeAll, final boolean includeEager) {
        this.visit(new ResourceVisitor(){

            @Override
            public void visitJARDesc(JARDesc jd) {
                if (includeAll || includeEager && !jd.isLazyDownload() || includeParts.contains(jd.getPartName())) {
                    list.add(jd);
                }
            }

            @Override
            public void visitExtensionDesc(ExtensionDesc ed) {
                ResourcesDesc rd;
                Set<String> extensionParts = ed.getExtensionPackages(includeParts, includeEager);
                if (ed.getExtensionDesc() != null && (rd = ed.getExtensionDesc().getResources()) != null) {
                    rd.addJarsToList(list, extensionParts, includeAll, includeEager);
                }
            }
        });
    }

    public JARDesc[] getPartJars(String[] parts) {
        HashSet<String> partsSet = new HashSet<String>();
        for (String s : parts) {
            partsSet.add(s);
        }
        ArrayList<JARDesc> jarList = new ArrayList<JARDesc>();
        this.addJarsToList(jarList, partsSet, false, false);
        return jarList.toArray(new JARDesc[jarList.size()]);
    }

    public JARDesc[] getPartJars(String part) {
        return this.getPartJars(new String[]{part});
    }

    public JARDesc[] getResource(final URL location, final String version) {
        final JARDesc[] resources = new JARDesc[1];
        this.visit(new ResourceVisitor(){

            @Override
            public void visitJARDesc(JARDesc jd) {
                if (URLUtil.sameURLs((URL)jd.getLocation(), (URL)location)) {
                    VersionString vs;
                    VersionString versionString = vs = jd.getVersion() != null ? new VersionString(jd.getVersion()) : null;
                    if (version == null && vs == null) {
                        resources[0] = jd;
                    } else if (vs.contains(version)) {
                        resources[0] = jd;
                    }
                }
            }
        });
        if (resources[0] == null) {
            return null;
        }
        if (resources[0].getPartName() != null) {
            return this.getPartJars(resources[0].getPartName());
        }
        return resources;
    }

    public JARDesc[] getExtensionPart(URL location, String version, String[] parts) {
        ExtensionDesc ed = this.findExtension(location, version);
        if (ed == null) {
            return null;
        }
        ResourcesDesc rd = ed.getExtensionResources();
        if (rd == null) {
            return null;
        }
        return rd.getPartJars(parts);
    }

    private ExtensionDesc findExtension(final URL location, final String version) {
        final ExtensionDesc[] ea = new ExtensionDesc[1];
        this.visit(new ResourceVisitor(){

            @Override
            public void visitExtensionDesc(ExtensionDesc ed) {
                if (ea[0] == null) {
                    if (URLUtil.sameURLs((URL)ed.getLocation(), (URL)location) && (version == null || new VersionString(version).contains(ed.getVersion()))) {
                        ea[0] = ed;
                    } else {
                        LaunchDesc ld = ed.getExtensionDesc();
                        if (ld != null && ld.getResources() != null) {
                            ea[0] = ld.getResources().findExtension(location, version);
                        }
                    }
                }
            }
        });
        return ea[0];
    }

    public JARDesc getProgressJar() {
        final JARDesc[] results = new JARDesc[2];
        results[0] = null;
        this.visit(new ResourceVisitor(){

            @Override
            public void visitJARDesc(JARDesc jd) {
                if (jd.isProgressJar()) {
                    results[0] = jd;
                }
            }
        });
        return results[0];
    }

    protected JARDesc getMainJar() {
        final JARDesc[] results = new JARDesc[2];
        this.visit(new ResourceVisitor(){

            @Override
            public void visitJARDesc(JARDesc jd) {
                if (jd.isJavaFile()) {
                    if (results[0] == null || results[0].isNativeLib()) {
                        results[0] = jd;
                    }
                    if (jd.isMainJarFile()) {
                        results[1] = jd;
                    }
                } else if (jd.isNativeLib() && results[0] == null) {
                    results[0] = jd;
                }
            }

            @Override
            public void visitExtensionDesc(ExtensionDesc ed) {
                ResourcesDesc rd;
                LaunchDesc extLd;
                if (results[1] == null && !ed.isInstaller() && (extLd = ed.getExtensionDesc()) != null && extLd.isLibrary() && (rd = extLd.getResources()) != null) {
                    rd.visit(this);
                }
            }
        });
        JARDesc first = results[0];
        JARDesc main = results[1];
        return this._parent.isLibrary() || main == null ? first : main;
    }

    public JARDesc[] getPart(final String name) {
        final ArrayList jarList = new ArrayList();
        this.visit(new ResourceVisitor(){

            @Override
            public void visitJARDesc(JARDesc jd) {
                if (name.equals(jd.getPartName())) {
                    jarList.add(jd);
                }
            }
        });
        return jarList.toArray(new JARDesc[jarList.size()]);
    }

    public JARDesc[] getExtensionPart(final URL url, final String version, final String part) {
        final JARDesc[][] jdss = new JARDesc[1][];
        this.visit(new ResourceVisitor(){

            @Override
            public void visitExtensionDesc(ExtensionDesc ed) {
                if (URLUtil.sameURLs((URL)ed.getLocation(), (URL)url)) {
                    if (version == null) {
                        if (ed.getVersion() == null && ed.getExtensionResources() != null) {
                            jdss[0] = ed.getExtensionResources().getPart(part);
                        }
                    } else if (version.equals(ed.getVersion()) && ed.getExtensionResources() != null) {
                        jdss[0] = ed.getExtensionResources().getPart(part);
                    }
                }
            }
        });
        return jdss[0];
    }

    public Properties getResourceProperties() {
        final Properties props = new Properties();
        this.visit(new ResourceVisitor(){

            @Override
            public void visitPropertyDesc(PropertyDesc pd) {
                props.setProperty(pd.getKey(), pd.getValue());
            }
        });
        return props;
    }

    public List<Property> getResourcePropertyList() {
        final LinkedList<Property> propList = new LinkedList<Property>();
        this.visit(new ResourceVisitor(){

            @Override
            public void visitPropertyDesc(PropertyDesc pd) {
                propList.add(new Property(pd.getKey(), pd.getValue()));
            }
        });
        return propList;
    }

    public PackageInformation getPackageInformation(String name) {
        if ((name = name.replace('/', '.')).endsWith(".class")) {
            name = name.substring(0, name.length() - 6);
        }
        return ResourcesDesc.visitPackageElements(this.getParent(), name);
    }

    public boolean isPackagePart(final String part) {
        final boolean[] result = new boolean[]{false};
        this.visit(new ResourceVisitor(){

            @Override
            public void visitExtensionDesc(ExtensionDesc ed) {
                if (!ed.isInstaller()) {
                    LaunchDesc extLd = ed.getExtensionDesc();
                    if (!result[0] && extLd != null && extLd.isLibrary() && extLd.getResources() != null) {
                        result[0] = extLd.getResources().isPackagePart(part);
                    }
                }
            }

            @Override
            public void visitPackageDesc(PackageDesc pd) {
                if (pd.getPart().equals(part)) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    private static PackageInformation visitPackageElements(final LaunchDesc ld, final String name) {
        final PackageInformation[] result = new PackageInformation[1];
        ld.getResources().visit(new ResourceVisitor(){

            @Override
            public void visitExtensionDesc(ExtensionDesc ed) {
                if (!ed.isInstaller()) {
                    LaunchDesc extLd = ed.getExtensionDesc();
                    if (result[0] == null && extLd != null && extLd.isLibrary() && extLd.getResources() != null) {
                        result[0] = ResourcesDesc.visitPackageElements(extLd, name);
                    }
                }
            }

            @Override
            public void visitPackageDesc(PackageDesc jd) {
                if (result[0] == null && jd.match(name)) {
                    result[0] = new PackageInformation(ld, jd.getPart());
                }
            }
        });
        return result[0];
    }

    @Override
    public void visit(ResourceVisitor rv) {
        for (int i = 0; i < this._list.size(); ++i) {
            ResourceType rt = this._list.get(i);
            rt.visit(rv);
        }
    }

    void setFilter(Filter filter) {
        this.filter = filter;
    }

    public XMLNode asXML() {
        XMLNodeBuilder nb = new XMLNodeBuilder("resources", null);
        for (int i = 0; i < this._list.size(); ++i) {
            ResourceType rt = this._list.get(i);
            if (this.filter != null && rt instanceof PropertyDesc && "jnlp.sis.session".equals(((PropertyDesc)rt).getKey())) continue;
            nb.add((XMLable)rt);
        }
        return nb.getNode();
    }

    public void addNested(ResourcesDesc nested) {
        if (nested != null) {
            nested.visit(new ResourceVisitor(){

                @Override
                public void visitJARDesc(JARDesc jd) {
                    ResourcesDesc.this._list.add(jd);
                }

                @Override
                public void visitPropertyDesc(PropertyDesc pd) {
                    ResourcesDesc.this._list.add(pd);
                }

                @Override
                public void visitExtensionDesc(ExtensionDesc ed) {
                    ResourcesDesc.this._list.add(ed);
                }
            });
        }
    }

    public ResourcesDesc clone() {
        ResourcesDesc clone = new ResourcesDesc();
        clone._concurrentDownloads = this._concurrentDownloads;
        clone._pack200Enabled = this._pack200Enabled;
        clone._versionEnabled = this._versionEnabled;
        clone._parent = this._parent;
        clone._list.addAll(this._list);
        return clone;
    }

    public static class PackageInformation {
        private final LaunchDesc _launchDesc;
        private final String _part;

        PackageInformation(LaunchDesc ld, String part) {
            this._launchDesc = ld;
            this._part = part;
        }

        public LaunchDesc getLaunchDesc() {
            return this._launchDesc;
        }

        public String getPart() {
            return this._part;
        }
    }
}

