/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.GeneralUtil;
import com.sun.deploy.util.VersionString;
import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.net.URL;

public class JREDesc
implements ResourceType {
    private String _version;
    private int _versionType;
    public static final int PRODUCT_VERSION = 0;
    public static final int PLATFORM_VERSION = 1;
    private boolean _isSecure;
    private boolean _isForced;
    private long _maxHeap;
    private long _minHeap;
    private String _vmargs;
    private URL _href;
    private ResourcesDesc _resourceDesc;
    private LaunchDesc _extensioDesc;
    private boolean _invalidPlatform;
    private String _archList;

    public JREDesc(String version, long minHeap, long maxHeap, String vmargs, URL href, ResourcesDesc resourcesDesc, String archList) {
        this._version = version;
        this._versionType = href != null ? 0 : 1;
        this._maxHeap = maxHeap;
        this._minHeap = minHeap;
        this._vmargs = vmargs;
        this._href = href;
        this._resourceDesc = resourcesDesc;
        this._extensioDesc = null;
        this._invalidPlatform = false;
        this._isSecure = false;
        this._isForced = false;
        this._archList = archList;
        if (href == null) {
            VersionString vs = new VersionString(version);
            String[] all = new String[]{"9", "1.8", "1.7", "1.6", "1.5", "1.4", "1.3"};
            for (int i = 0; i < all.length; ++i) {
                if (!vs.contains(all[i])) continue;
                return;
            }
            Trace.println((String)("WARNING - specified JRE version, " + version + " is invalid platform version"), (TraceLevel)TraceLevel.BASIC);
            this._invalidPlatform = true;
        }
    }

    public JREDesc(String version, boolean force) {
        this._versionType = 0;
        if (version.equals("SECURE")) {
            this._isSecure = true;
            this._version = null;
        } else if (version.startsWith("SECURE-")) {
            this._isSecure = true;
            this._version = version.substring(7);
        } else {
            this._isSecure = false;
            this._version = version;
        }
        this._isForced = force;
    }

    public String toString() {
        return "JREDesc[version " + this._version + ", versionType=" + this._versionType + ", secure=" + this._isSecure + ", heap=" + this._minHeap + "-" + this._maxHeap + ", args=" + this._vmargs + ", href=" + this._href + ", " + this._resourceDesc + ", " + this._extensioDesc + "]";
    }

    public String[] getArchList() {
        return GeneralUtil.getStringList((String)this._archList);
    }

    public int getVersionType() {
        return this._versionType;
    }

    public boolean isSecure() {
        return this._isSecure;
    }

    public boolean isVersionForced() {
        return this._isForced;
    }

    public String getVersion() {
        return this._version;
    }

    public URL getHref() {
        return this._href;
    }

    public long getMinHeap() {
        return this._minHeap;
    }

    public long getMaxHeap() {
        return this._maxHeap;
    }

    public String getVmArgs() {
        return this._vmargs;
    }

    public ResourcesDesc getNestedResources() {
        return this._resourceDesc;
    }

    public LaunchDesc getExtensionDesc() {
        return this._extensioDesc;
    }

    public void setExtensionDesc(LaunchDesc ld) {
        this._extensioDesc = ld;
    }

    @Override
    public void visit(ResourceVisitor rv) {
        rv.visitJREDesc(this);
    }

    public String getSource() {
        if (this._href != null) {
            return this._href.getHost();
        }
        try {
            URL url = new URL(Config.getStringProperty((String)"deployment.javaws.installURL"));
            return url.getHost();
        }
        catch (Throwable t) {
            Trace.ignored((Throwable)t);
            return "";
        }
    }

    public boolean isInvalidPlatform() {
        return this._invalidPlatform;
    }

    public XMLNode asXML() {
        XMLNode extcNode;
        XMLAttributeBuilder ab = new XMLAttributeBuilder();
        if (this._archList != null) {
            ab.add("arch", this._archList);
        }
        if (this._minHeap > 0L) {
            ab.add("initial-heap-size", this._minHeap);
        }
        if (this._maxHeap > 0L) {
            ab.add("max-heap-size", this._maxHeap);
        }
        if (this._vmargs != null) {
            ab.add("java-vm-args", this._vmargs);
        }
        ab.add("href", this._href);
        if (this._version != null) {
            ab.add("version", this._version);
        }
        XMLNode xMLNode = extcNode = this._extensioDesc != null ? this._extensioDesc.asXML() : null;
        if (this._resourceDesc != null) {
            extcNode = this._resourceDesc.asXML();
        }
        return new XMLNode("java", ab.getAttributeList(), extcNode, null);
    }
}

