/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.net.URLPermission;
import java.security.Permission;
import java.util.HashSet;
import sun.plugin2.applet.SecurityManagerHelper;

public class FXAppletSecurityManager
extends SecurityManager {
    private final AppContext mainAppContext;
    private final SecurityManager fxSM = new SecurityManager();
    private final HashSet<String> restrictedPackages = new HashSet();

    public FXAppletSecurityManager() {
        SecurityManagerHelper.resetHelper(this.restrictedPackages);
        this.mainAppContext = ToolkitStore.get().getAppContext();
    }

    @Override
    public void checkConnect(String host, int port) {
        SecurityManagerHelper.checkConnectHelper(this.fxSM, host, port, null, false, this.getClassContext());
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        SecurityManagerHelper.checkConnectHelper(this.fxSM, host, port, context, true, this.getClassContext());
    }

    @Override
    public void checkPermission(Permission perm) {
        if (Config.isJavaVersionAtLeast18() && perm instanceof URLPermission) {
            SecurityManagerHelper.checkURLPermissionHelper(this.fxSM, perm, null, false, this.getClassContext());
            return;
        }
        super.checkPermission(perm);
        SecurityManagerHelper.checkPermissionHelper(perm);
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (Config.isJavaVersionAtLeast18() && perm instanceof URLPermission) {
            SecurityManagerHelper.checkURLPermissionHelper(this.fxSM, perm, context, true, this.getClassContext());
            return;
        }
        super.checkPermission(perm, context);
    }

    @Override
    public void checkAccess(Thread t) {
        SecurityManagerHelper.checkAccessHelper(t, this.fxSM, this.currentClassLoaderSafe(), this.getClassContext());
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        SecurityManagerHelper.checkAccessHelper(g, this.fxSM, this.currentClassLoaderSafe(), this.getClassContext());
    }

    @Override
    public void checkPackageAccess(String pkgname) {
        SecurityManagerHelper.checkPackageAccessHelper(this.fxSM, pkgname, this.restrictedPackages);
    }

    @Override
    public void checkPrintJobAccess() {
        SecurityManagerHelper.checkPrintJobAccessHelper(this.fxSM);
    }

    @Override
    public void checkSecurityAccess(String action) {
        SecurityManagerHelper.checkSecurityAccessHelper(this.fxSM, action);
    }

    public AppContext getAppContext() {
        return SecurityManagerHelper.getAppContextHelper(this.currentClassLoaderSafe(), this.getClassContext());
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return SecurityManagerHelper.getThreadGroupHelper(this.fxSM, this.currentClassLoaderSafe(), this.getClassContext());
    }

    public boolean checkTopLevelWindow(Object window) {
        if (window == null) {
            throw new NullPointerException("window can't be null");
        }
        return super.checkTopLevelWindow(window);
    }

    private ClassLoader currentClassLoaderSafe() {
        return Thread.currentThread().getContextClassLoader();
    }
}

