/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.net.proxy.DynamicProxyManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertificateHostnameVerifier;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.X509DeployTrustManager;
import com.sun.deploy.trace.LoggerTraceListener;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.util.SystemPropertyUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.Policy;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.plugin.ClassLoaderInfo;
import sun.plugin.util.PluginSysUtil;
import sun.plugin.util.UserProfile;

public class PluginConsoleController
implements ConsoleController {
    private boolean onWindows = false;
    private Logger logger = null;

    public PluginConsoleController() {
        try {
            String osName = SystemPropertyUtil.getProperty((String)"os.name");
            if (osName.indexOf("Windows") != -1) {
                this.onWindows = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isIconifiedOnClose() {
        return false;
    }

    public boolean isDumpStackSupported() {
        return true;
    }

    public ThreadGroup getMainThreadGroup() {
        return PluginSysUtil.getPluginThreadGroup().getParent();
    }

    public boolean isSecurityPolicyReloadSupported() {
        return true;
    }

    public void reloadSecurityPolicy() {
        Policy policy = Policy.getPolicy();
        policy.refresh();
    }

    public boolean isProxyConfigReloadSupported() {
        return true;
    }

    public void reloadProxyConfig() {
        DynamicProxyManager.reset();
    }

    public boolean isDumpClassLoaderSupported() {
        return true;
    }

    public String dumpClassLoaders() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ClassLoaderInfo.dumpClassLoaderCache(pw);
        return sw.toString();
    }

    public boolean isClearClassLoaderSupported() {
        return true;
    }

    public void clearClassLoaders() {
        MemoryCache.clearLoadedResources();
        ClassLoaderInfo.clearClassLoaderCache();
        TrustDecider.reset();
        X509DeployTrustManager.reset();
        CertificateHostnameVerifier.reset();
    }

    public boolean isLoggingSupported() {
        return true;
    }

    public void setLogger(Logger l) {
        this.logger = l;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean toggleLogging() {
        Level level;
        if (this.logger == null) {
            File logDir = new File(UserProfile.getLogDirectory());
            File logFile = Trace.createTempFile((String)"plugin", (String)".log", (File)logDir);
            LoggerTraceListener ltl = new LoggerTraceListener("sun.plugin", logFile.getPath());
            this.logger = ltl.getLogger();
        }
        level = (level = this.logger.getLevel()) == Level.OFF ? Level.ALL : Level.OFF;
        this.logger.setLevel(level);
        return level == Level.ALL;
    }

    public String getProductName() {
        return ResourceManager.getString((String)"product.javapi.name", (Object[])new Object[]{System.getProperty("java.version")});
    }

    public void notifyConsoleClosed() {
    }
}

