/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.com;

import com.sun.deploy.resources.ResourceManager;
import java.lang.reflect.InvocationTargetException;
import netscape.javascript.JSObject;
import sun.plugin.com.DispatchImpl;

public class ParameterListCorrelator {
    private static final int BOOL_CODE = 0;
    private static final int BYTE_CODE = 1;
    private static final int SHORT_CODE = 2;
    private static final int INT_CODE = 3;
    private static final int LONG_CODE = 4;
    private static final int FLOAT_CODE = 5;
    private static final int DOUBLE_CODE = 6;
    private static final int CHAR_CODE = 7;
    private static final int NOT_PRIMITIVE_CODE = 8;
    private Class<?>[] expectedClasses;
    private Object[] givenParameters;
    private boolean analysisIsDone;
    private boolean parametersCorrelateToClasses;
    private int numberOfConversionsNeeded;

    ParameterListCorrelator(Class<?>[] expectedClasses, Object[] givenParameters) {
        this.expectedClasses = expectedClasses;
        if (this.expectedClasses == null) {
            this.expectedClasses = new Class[0];
        }
        this.givenParameters = givenParameters;
        if (this.givenParameters == null) {
            this.givenParameters = new Object[0];
        }
        this.analysisIsDone = false;
        this.numberOfConversionsNeeded = 0;
        this.parametersCorrelateToClasses = false;
    }

    boolean parametersCorrelateToClasses() {
        this.analyze();
        return this.parametersCorrelateToClasses;
    }

    int numberOfConversionsNeeded() throws InvocationTargetException {
        this.analyze();
        if (!this.parametersCorrelateToClasses) {
            IllegalArgumentException iae = new IllegalArgumentException(ResourceManager.getString((String)"com.method.argsTypeInvalid"));
            throw new InvocationTargetException(iae);
        }
        return this.numberOfConversionsNeeded;
    }

    private void analyze() {
        if (!this.analysisIsDone) {
            this.parametersCorrelateToClasses = true;
            if (this.expectedClasses.length != this.givenParameters.length) {
                this.reportParametersDoNotCorrelate();
            }
            for (int i = 0; !this.analysisIsDone && i < this.givenParameters.length; ++i) {
                this.analyzeParameter(this.expectedClasses[i], this.givenParameters[i]);
            }
            this.analysisIsDone = true;
        }
    }

    private void analyzeParameter(Class<?> expectedClass, Object param) {
        if (param != null) {
            this.analyzeParameter(expectedClass, param.getClass());
        }
    }

    private void analyzeParameter(Class<?> expectedClass, Class<?> classOfParameter) {
        if (classOfParameter == null) {
            return;
        }
        if (expectedClass.equals(classOfParameter)) {
            return;
        }
        if (expectedClass.isAssignableFrom(classOfParameter)) {
            ++this.numberOfConversionsNeeded;
        } else if (expectedClass == String.class) {
            ++this.numberOfConversionsNeeded;
        } else if ((expectedClass.isPrimitive() || Number.class.isAssignableFrom(expectedClass) || expectedClass == Character.class || expectedClass == Boolean.class) && classOfParameter == String.class) {
            ++this.numberOfConversionsNeeded;
        } else if (expectedClass.isArray()) {
            if (!classOfParameter.isArray()) {
                this.reportParametersDoNotCorrelate();
            } else {
                Class<?> compType = expectedClass.getComponentType();
                Class<?> paramCompType = classOfParameter.getComponentType();
                if (!paramCompType.equals(Object.class)) {
                    this.analyzeParameter(compType, paramCompType);
                }
            }
        } else if (expectedClass.equals(JSObject.class)) {
            ++this.numberOfConversionsNeeded;
        } else if (expectedClass.equals(DispatchImpl.class)) {
            ++this.numberOfConversionsNeeded;
        } else if (!this.typesAreEquivalentPrimitives(expectedClass, classOfParameter)) {
            this.reportParametersDoNotCorrelate();
        }
    }

    private boolean typesAreEquivalentPrimitives(Class<?> leftType, Class<?> rightType) {
        int leftCode = ParameterListCorrelator.typeCodeFromTypeName(leftType.getName());
        if (leftCode != 8) {
            int rightCode = ParameterListCorrelator.typeCodeFromTypeName(rightType.getName());
            if (rightCode == 8) {
                return false;
            }
            if (leftCode != rightCode) {
                ++this.numberOfConversionsNeeded;
            }
            return true;
        }
        return false;
    }

    private static int typeCodeFromTypeName(String typeName) {
        if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
            return 0;
        }
        if (typeName.equals("byte") || typeName.equals("java.lang.Byte")) {
            return 1;
        }
        if (typeName.equals("short") || typeName.equals("java.lang.Short")) {
            return 2;
        }
        if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
            return 3;
        }
        if (typeName.equals("long") || typeName.equals("java.lang.Long")) {
            return 4;
        }
        if (typeName.equals("float") || typeName.equals("java.lang.Float")) {
            return 5;
        }
        if (typeName.equals("double") || typeName.equals("java.lang.Double")) {
            return 6;
        }
        if (typeName.equals("char") || typeName.equals("java.lang.Character")) {
            return 7;
        }
        return 8;
    }

    private void reportParametersDoNotCorrelate() {
        this.parametersCorrelateToClasses = false;
        this.analysisIsDone = true;
    }
}

