/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.server.main;

import com.sun.deploy.config.Config;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import netscape.javascript.JSException;
import sun.plugin2.liveconnect.BrowserSideObject;
import sun.plugin2.liveconnect.RemoteJavaObject;
import sun.plugin2.message.Conversation;
import sun.plugin2.server.main.AppletID;
import sun.plugin2.server.main.JVMManager;
import sun.plugin2.server.main.Plugin;
import sun.plugin2.server.main.ResultID;

public class LiveConnectSupport {
    private static final boolean DEBUG = Config.getDebug();
    private static final boolean VERBOSE = Config.getVerbose();
    private static Map pluginInfoMap = new HashMap();
    private static Map currentConversationMap = new HashMap();
    private static int curResultID;
    private static Map resultIDInterestMap;
    private static Map results;

    public static synchronized void initialize(int n, Plugin plugin) {
        AppletID appletID = new AppletID(n);
        pluginInfoMap.put(appletID, new PerPluginInfo(plugin, n));
    }

    public static synchronized void shutdown(int n) {
        if (DEBUG) {
            System.out.println("  LiveConnectSupport.shutdown(" + n + ")");
        }
        PerPluginInfo perPluginInfo = LiveConnectSupport.getInfo(n);
        perPluginInfo.releaseAllObjects();
        AppletID appletID = new AppletID(n);
        pluginInfoMap.remove(appletID);
        currentConversationMap.remove(perPluginInfo.getPlugin());
        perPluginInfo.getPlugin().notifyMainThread();
    }

    public static void registerObject(int n, BrowserSideObject browserSideObject) throws JSException {
        LiveConnectSupport.getInfo(n).registerObject(browserSideObject);
    }

    public static void releaseObject(int n, BrowserSideObject browserSideObject) {
        try {
            LiveConnectSupport.getInfo(n).releaseObject(browserSideObject);
        }
        catch (JSException jSException) {
            // empty catch block
        }
    }

    public static BrowserSideObject javaScriptGetWindow(Conversation conversation, int n) throws JSException {
        return LiveConnectSupport.getInfo(n).javaScriptGetWindow(conversation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object javaScriptCall(Conversation conversation, int n, BrowserSideObject browserSideObject, String string, Object[] objectArray) throws JSException {
        Object object = null;
        PerPluginInfo perPluginInfo = LiveConnectSupport.getInfo(n);
        Plugin plugin = perPluginInfo.getPlugin();
        plugin.incrementActiveJSCounter();
        try {
            object = perPluginInfo.javaScriptCall(conversation, browserSideObject, string, objectArray);
        }
        finally {
            plugin.decrementActiveJSCounter();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object javaScriptEval(Conversation conversation, int n, BrowserSideObject browserSideObject, String string) throws JSException {
        Object object = null;
        PerPluginInfo perPluginInfo = LiveConnectSupport.getInfo(n);
        Plugin plugin = perPluginInfo.getPlugin();
        plugin.incrementActiveJSCounter();
        try {
            object = perPluginInfo.javaScriptEval(conversation, browserSideObject, string);
        }
        finally {
            plugin.decrementActiveJSCounter();
        }
        return object;
    }

    public static Object javaScriptGetMember(Conversation conversation, int n, BrowserSideObject browserSideObject, String string) throws JSException {
        return LiveConnectSupport.getInfo(n).javaScriptGetMember(conversation, browserSideObject, string);
    }

    public static void javaScriptSetMember(Conversation conversation, int n, BrowserSideObject browserSideObject, String string, Object object) throws JSException {
        LiveConnectSupport.getInfo(n).javaScriptSetMember(conversation, browserSideObject, string, object);
    }

    public static void javaScriptRemoveMember(Conversation conversation, int n, BrowserSideObject browserSideObject, String string) throws JSException {
        LiveConnectSupport.getInfo(n).javaScriptRemoveMember(conversation, browserSideObject, string);
    }

    public static Object javaScriptGetSlot(Conversation conversation, int n, BrowserSideObject browserSideObject, int n2) throws JSException {
        return LiveConnectSupport.getInfo(n).javaScriptGetSlot(conversation, browserSideObject, n2);
    }

    public static void javaScriptSetSlot(Conversation conversation, int n, BrowserSideObject browserSideObject, int n2, Object object) throws JSException {
        LiveConnectSupport.getInfo(n).javaScriptSetSlot(conversation, browserSideObject, n2, object);
    }

    public static String javaScriptToString(Conversation conversation, int n, BrowserSideObject browserSideObject) {
        return LiveConnectSupport.getInfo(n).javaScriptToString(conversation, browserSideObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultID sendGetApplet(Plugin plugin, AppletID appletID) throws IOException {
        int n = LiveConnectSupport.nextResultID();
        ResultID resultID = new ResultID(n);
        Class<LiveConnectSupport> clazz = LiveConnectSupport.class;
        synchronized (LiveConnectSupport.class) {
            resultIDInterestMap.put(resultID, plugin);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            LiveConnectSupport.resendGetApplet(appletID, resultID);
            return resultID;
        }
    }

    public static void resendGetApplet(AppletID appletID, ResultID resultID) throws IOException {
        JVMManager.getManager().sendGetApplet(appletID, resultID.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultID sendGetNameSpace(Plugin plugin, AppletID appletID, String string) throws IOException {
        int n = LiveConnectSupport.nextResultID();
        ResultID resultID = new ResultID(n);
        Class<LiveConnectSupport> clazz = LiveConnectSupport.class;
        synchronized (LiveConnectSupport.class) {
            resultIDInterestMap.put(resultID, plugin);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            JVMManager.getManager().sendGetNameSpace(appletID, string, n);
            return resultID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultID sendRemoteJavaObjectOp(Plugin plugin, RemoteJavaObject remoteJavaObject, String string, int n, Object[] objectArray) throws IOException, JSException {
        Object object;
        int n2 = remoteJavaObject.getJVMID();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (object2 == null || !(object2 instanceof RemoteJavaObject) || ((RemoteJavaObject)(object = (RemoteJavaObject)object2)).getJVMID() == n2) continue;
                throw new JSException("Can not pass objects between JVMs (arg " + i + " JVM ID = " + ((RemoteJavaObject)object).getJVMID() + ", required " + n2 + ")");
            }
        }
        Conversation conversation = LiveConnectSupport.getCurrentConversation(plugin);
        int n3 = LiveConnectSupport.nextResultID();
        object = new ResultID(n3);
        Class<LiveConnectSupport> clazz = LiveConnectSupport.class;
        synchronized (LiveConnectSupport.class) {
            resultIDInterestMap.put(object, plugin);
            // ** MonitorExit[var9_11] (shouldn't be in output)
            if (DEBUG) {
                System.out.println("LiveConnectSupport.sendRemoteJavaObjectOp: " + LiveConnectSupport.getOpName(n) + " \"" + string + "\"");
            }
            JVMManager.getManager().sendRemoteJavaObjectOp(conversation, remoteJavaObject, string, n, objectArray, n3);
            return object;
        }
    }

    public static synchronized void recordResult(ResultID resultID, Object object) {
        results.put(resultID, object);
        Plugin plugin = (Plugin)resultIDInterestMap.remove(resultID);
        if (DEBUG && plugin == null) {
            System.out.println("*** WARNING: no plugin was waiting for result " + resultID);
        }
        if (plugin != null) {
            plugin.notifyMainThread();
        }
    }

    public static synchronized boolean resultAvailable(ResultID resultID) {
        return results.containsKey(resultID);
    }

    public static synchronized Object getResult(ResultID resultID) throws RuntimeException {
        if (!LiveConnectSupport.resultAvailable(resultID)) {
            throw new RuntimeException("Result has not yet been produced for " + resultID);
        }
        Object v = results.remove(resultID);
        if (v != null && v instanceof RuntimeException) {
            if (DEBUG) {
                System.out.println("LiveConnectSupport: exception thrown during JavaScript -> Java call:");
                ((RuntimeException)v).printStackTrace();
            }
            throw (RuntimeException)v;
        }
        if (DEBUG) {
            System.out.println("LiveConnectSupport: result " + resultID + " = " + v);
        }
        return v;
    }

    private LiveConnectSupport() {
    }

    private static synchronized PerPluginInfo getInfo(int n) throws JSException {
        PerPluginInfo perPluginInfo = (PerPluginInfo)pluginInfoMap.get(new AppletID(n));
        if (perPluginInfo == null) {
            throw new JSException("Plugin instance for applet ID " + n + " was already released");
        }
        return perPluginInfo;
    }

    private static synchronized Conversation replaceCurrentConversation(Plugin plugin, Conversation conversation) {
        return currentConversationMap.put(plugin, conversation);
    }

    private static synchronized Conversation getCurrentConversation(Plugin plugin) {
        return (Conversation)currentConversationMap.get(plugin);
    }

    private static synchronized int nextResultID() {
        return ++curResultID;
    }

    private static String getOpName(int n) {
        switch (n) {
            case 1: {
                return "CALL_METHOD";
            }
            case 2: {
                return "GET_FIELD";
            }
            case 3: {
                return "SET_FIELD";
            }
            case 4: {
                return "HAS_FIELD";
            }
            case 5: {
                return "HAS_METHOD";
            }
            case 6: {
                return "HAS_FIELD_OR_METHOD";
            }
        }
        throw new IllegalArgumentException("Invalid operation kind " + n);
    }

    static {
        resultIDInterestMap = new HashMap();
        results = new HashMap();
    }

    public static class PerPluginInfo {
        private Plugin plugin;
        private int appletID;
        private Map registeredBrowserSideObjects = new HashMap();

        public PerPluginInfo(Plugin plugin, int n) {
            this.plugin = plugin;
            this.appletID = n;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public synchronized void registerObject(BrowserSideObject browserSideObject) {
            Integer n = (Integer)this.registeredBrowserSideObjects.get(browserSideObject);
            if (n == null) {
                this.plugin.javaScriptRetainObject(browserSideObject);
                if (DEBUG && VERBOSE) {
                    System.out.println("  LiveConnectSupport: retained " + browserSideObject + " for applet " + this.appletID);
                }
                n = 1;
            } else {
                n = n + 1;
            }
            this.registeredBrowserSideObjects.put(browserSideObject, n);
        }

        public synchronized void releaseObject(final BrowserSideObject browserSideObject) {
            Integer n = (Integer)this.registeredBrowserSideObjects.remove(browserSideObject);
            if (n == null) {
                if (DEBUG) {
                    System.out.println("!!! WARNING: LiveConnectSupport.releaseObject called for already released / untracked object 0x" + Long.toHexString(browserSideObject.getNativeObjectReference()));
                }
                return;
            }
            if (n < 1) {
                throw new IllegalStateException("Reference count should not be " + n);
            }
            if (n == 1) {
                if (DEBUG) {
                    System.out.println("  LiveConnectSupport: schedule release " + browserSideObject + " for applet " + this.appletID);
                }
                this.plugin.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PerPluginInfo.this.plugin.javaScriptReleaseObject(browserSideObject);
                    }
                });
            } else {
                n = n - 1;
                this.registeredBrowserSideObjects.put(browserSideObject, n);
            }
        }

        public synchronized void releaseAllObjects() {
            for (BrowserSideObject browserSideObject : this.registeredBrowserSideObjects.keySet()) {
                this.plugin.javaScriptReleaseObject(browserSideObject);
                if (!DEBUG || !VERBOSE) continue;
                System.out.println("  LiveConnectSupport: released " + browserSideObject + " for applet " + this.appletID);
            }
            this.registeredBrowserSideObjects.clear();
        }

        public BrowserSideObject javaScriptGetWindow(Conversation conversation) {
            return this.plugin.javaScriptGetWindow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object javaScriptCall(Conversation conversation, BrowserSideObject browserSideObject, String string, Object[] objectArray) throws JSException {
            this.validateObject(browserSideObject);
            this.validateObjectArray(objectArray);
            if (DEBUG) {
                System.out.println("LiveConnectSupport.PerPluginInfo.javaScriptCall:");
                System.out.println("  methodName: " + string);
                System.out.print("  args: ");
                if (objectArray == null) {
                    System.out.println("null");
                } else {
                    System.out.print("[");
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (i > 0) {
                            System.out.print(", ");
                        }
                        System.out.print(objectArray[i]);
                    }
                    System.out.println("]");
                }
            }
            Conversation conversation2 = LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation);
            try {
                Object object = this.plugin.javaScriptCall(browserSideObject, string, objectArray);
                if (DEBUG) {
                    System.out.println("  result of call to \"" + string + "\": " + object);
                }
                Object object2 = object;
                return object2;
            }
            finally {
                LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object javaScriptEval(Conversation conversation, BrowserSideObject browserSideObject, String string) throws JSException {
            this.validateObject(browserSideObject);
            Conversation conversation2 = LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation);
            try {
                Object object = this.plugin.javaScriptEval(browserSideObject, string);
                return object;
            }
            finally {
                LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object javaScriptGetMember(Conversation conversation, BrowserSideObject browserSideObject, String string) throws JSException {
            this.validateObject(browserSideObject);
            Conversation conversation2 = LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation);
            try {
                Object object = this.plugin.javaScriptGetMember(browserSideObject, string);
                return object;
            }
            finally {
                LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void javaScriptSetMember(Conversation conversation, BrowserSideObject browserSideObject, String string, Object object) throws JSException {
            this.validateObject(browserSideObject);
            this.validateObject(object);
            Conversation conversation2 = LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation);
            try {
                this.plugin.javaScriptSetMember(browserSideObject, string, object);
            }
            finally {
                LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void javaScriptRemoveMember(Conversation conversation, BrowserSideObject browserSideObject, String string) throws JSException {
            this.validateObject(browserSideObject);
            Conversation conversation2 = LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation);
            try {
                this.plugin.javaScriptRemoveMember(browserSideObject, string);
            }
            finally {
                LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object javaScriptGetSlot(Conversation conversation, BrowserSideObject browserSideObject, int n) throws JSException {
            this.validateObject(browserSideObject);
            Conversation conversation2 = LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation);
            try {
                Object object = this.plugin.javaScriptGetSlot(browserSideObject, n);
                return object;
            }
            finally {
                LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void javaScriptSetSlot(Conversation conversation, BrowserSideObject browserSideObject, int n, Object object) throws JSException {
            this.validateObject(browserSideObject);
            this.validateObject(object);
            Conversation conversation2 = LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation);
            try {
                this.plugin.javaScriptSetSlot(browserSideObject, n, object);
            }
            finally {
                LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String javaScriptToString(Conversation conversation, BrowserSideObject browserSideObject) {
            this.validateObject(browserSideObject);
            Conversation conversation2 = LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation);
            try {
                String string = this.plugin.javaScriptToString(browserSideObject);
                return string;
            }
            finally {
                LiveConnectSupport.replaceCurrentConversation(this.plugin, conversation2);
            }
        }

        private void validateObjectArray(Object[] objectArray) throws JSException {
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.validateObject(objectArray[i]);
                }
            }
        }

        private void validateObject(Object object) throws JSException {
            if (object == null) {
                return;
            }
            if (object instanceof BrowserSideObject && !this.registeredBrowserSideObjects.containsKey(object)) {
                throw new JSException("Attempt to reference unknown or already-released JavaScript object; may not pass JSObjects between applets directly");
            }
        }
    }
}

