/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Base64;

public class Base64Wrapper {
    public static byte[] decodeFromString(String src) throws IOException {
        if (Config.isJavaVersionAtLeast18()) {
            return Base64.getMimeDecoder().decode(src);
        }
        return SunMiscBase64Wrapper.decodeBuffer(src);
    }

    public static String encodeToString(byte[] src) {
        if (Config.isJavaVersionAtLeast18()) {
            return Base64.getMimeEncoder().encodeToString(src);
        }
        return SunMiscBase64Wrapper.encode(src);
    }

    public static String encodeToStringWithoutLineBreaks(byte[] src) {
        if (Config.isJavaVersionAtLeast18()) {
            return Base64.getEncoder().encodeToString(src);
        }
        return SunMiscBase64Wrapper.encodeToStringWithoutLineBreaks(src);
    }

    public static void encodeToBuffer(byte[] src, PrintStream dst) throws IOException {
        if (Config.isJavaVersionAtLeast18()) {
            dst.println(Base64Wrapper.encodeToString(src));
        } else {
            SunMiscBase64Wrapper.encodeBuffer(src, dst);
        }
    }

    private static class SunMiscBase64Wrapper {
        private static final Class<?> decoderClass;
        private static final Class<?> encoderClass;
        private static final Constructor<?> decoderCon;
        private static final Constructor<?> encoderCon;
        private static final Method decodeBuffer;
        private static final Method encode;
        private static final Method encodeBuffer;
        private static final char[] pem_array;

        private SunMiscBase64Wrapper() {
        }

        public static byte[] decodeBuffer(String src) {
            try {
                Object decoder = decoderCon.newInstance(new Object[0]);
                return (byte[])decodeBuffer.invoke(decoder, src);
            }
            catch (InvocationTargetException x) {
                SunMiscBase64Wrapper.rethrowCause(x);
                return null;
            }
            catch (ReflectiveOperationException x) {
                throw new InternalError(x);
            }
        }

        public static String encode(byte[] src) {
            try {
                Object encoder = encoderCon.newInstance(new Object[0]);
                return (String)encode.invoke(encoder, new Object[]{src});
            }
            catch (InvocationTargetException x) {
                SunMiscBase64Wrapper.rethrowCause(x);
                return null;
            }
            catch (ReflectiveOperationException x) {
                throw new InternalError(x);
            }
        }

        public static void encodeBuffer(byte[] src, PrintStream dst) {
            try {
                Object encoder = encoderCon.newInstance(new Object[0]);
                encodeBuffer.invoke(encoder, src, dst);
                return;
            }
            catch (InvocationTargetException x) {
                SunMiscBase64Wrapper.rethrowCause(x);
            }
            catch (ReflectiveOperationException x) {
                throw new InternalError(x);
            }
        }

        public static String encodeToStringWithoutLineBreaks(byte[] src) {
            return SunMiscBase64Wrapper.base64Encode(src);
        }

        private static void rethrowCause(InvocationTargetException t) {
            Throwable cause = t.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new AssertionError((Object)t);
        }

        private static String base64Encode(byte[] data) {
            int count;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int max = data.length;
            for (int offset = 0; offset < max; offset += count) {
                count = Math.min(max - offset, 3);
                try {
                    SunMiscBase64Wrapper.encodeAtom(baos, data, offset, count);
                    continue;
                }
                catch (IOException ioe) {
                    System.err.println("caught error encoding argument list: " + ioe);
                    return null;
                }
            }
            return baos.toString();
        }

        private static void encodeAtom(OutputStream outStream, byte[] data, int offset, int len) throws IOException {
            if (len == 1) {
                byte a = data[offset];
                int b = 0;
                boolean c = false;
                outStream.write(pem_array[a >>> 2 & 0x3F]);
                outStream.write(pem_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
                outStream.write(61);
                outStream.write(61);
            } else if (len == 2) {
                byte a = data[offset];
                byte b = data[offset + 1];
                int c = 0;
                outStream.write(pem_array[a >>> 2 & 0x3F]);
                outStream.write(pem_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
                outStream.write(pem_array[(b << 2 & 0x3C) + (c >>> 6 & 3)]);
                outStream.write(61);
            } else {
                byte a = data[offset];
                byte b = data[offset + 1];
                byte c = data[offset + 2];
                outStream.write(pem_array[a >>> 2 & 0x3F]);
                outStream.write(pem_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
                outStream.write(pem_array[(b << 2 & 0x3C) + (c >>> 6 & 3)]);
                outStream.write(pem_array[c & 0x3F]);
            }
        }

        static {
            try {
                decoderClass = Class.forName("sun.misc.BASE64Decoder");
                decodeBuffer = decoderClass.getMethod("decodeBuffer", String.class);
                encoderClass = Class.forName("sun.misc.BASE64Encoder");
                encode = encoderClass.getMethod("encode", byte[].class);
                encodeBuffer = encoderClass.getMethod("encodeBuffer", byte[].class, OutputStream.class);
                decoderCon = decoderClass.getConstructor(new Class[0]);
                encoderCon = encoderClass.getConstructor(new Class[0]);
            }
            catch (ReflectiveOperationException x) {
                throw new InternalError(x);
            }
            pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        }
    }
}

