/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.FancyButton;
import com.sun.deploy.ui.JSmartTextArea;
import com.sun.deploy.ui.MoreInfoDialog;
import com.sun.deploy.ui.PromptEditorKit;
import com.sun.deploy.ui.SelectableLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SSV3DialogContent {
    private static final int MAX_PROMPT_WIDTH = 480;
    private final AppInfo ainfo;
    private final String mastheadKey;
    private final String mainTextKey;
    private final String locationKey;
    private final String promptKey;
    private final String multiPromptKey;
    private final String multiTextKey;
    private final String runTextKey;
    private final String updateTextKey;
    private final String cancelTextKey;
    private final URL updateURL;
    private int userAnswer = -1;
    private JPanel contentPane;
    private final DialogTemplate template;
    private JCheckBox multiClickCheckBox;
    private JButton runButton;
    private JButton updateButton;
    private JButton cancelButton;
    private AbstractAction cancelAction;
    private static Font ssvSmallFont;
    private static Font ssvSmallBoldFont;
    private static Font ssvFont;
    private static Font ssvBoldFont;
    private static Font ssvBigBoldFont;
    static int invokeCount;

    public SSV3DialogContent(AppInfo ainfo, String title, String mastheadKey, String mainTextKey, String locationKey, String promptKey, String multiPromptKey, String multiTextKey, String runKey, String updateKey, String cancelKey, String alwaysTextKey, URL updateURL, DialogTemplate template) {
        SSV3DialogContent.setSSVFonts();
        this.template = template;
        this.ainfo = ainfo;
        this.mastheadKey = mastheadKey;
        this.mainTextKey = mainTextKey;
        this.locationKey = locationKey;
        this.promptKey = promptKey;
        this.multiPromptKey = multiPromptKey;
        this.multiTextKey = multiTextKey;
        this.runTextKey = runKey;
        this.updateTextKey = updateKey;
        this.cancelTextKey = cancelKey;
        this.updateURL = updateURL;
        this.initComponents();
    }

    public JPanel getContent() {
        return this.contentPane;
    }

    public int getAnswer() {
        if (this.userAnswer == -1) {
            this.userAnswer = 1;
        }
        return this.userAnswer;
    }

    private void initComponents() {
        this.contentPane = this.createContentPane();
        this.contentPane.add((Component)this.createMastHead(), "North");
        JComponent createMainContent = this.createMainContent();
        createMainContent.setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 0));
        this.contentPane.add((Component)createMainContent, "Center");
        this.contentPane.add((Component)this.createOkCancelPanel(), "South");
    }

    private JPanel createContentPane() {
        JPanel content = new JPanel();
        content.setOpaque(false);
        content.setBorder(BorderFactory.createEmptyBorder(16, 24, 23, 15));
        content.setOpaque(false);
        content.setLayout(new BorderLayout());
        return content;
    }

    private JComponent createMastHead() {
        Component closeIcon = null;
        JLabel mastHead = new JLabel(this.getMessage(this.mastheadKey));
        mastHead.setFont(ssvBigBoldFont);
        mastHead.setOpaque(false);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        if (closeIcon != null) {
            box.add(closeIcon);
        }
        box.add(mastHead);
        return box;
    }

    private JComponent createMainContent() {
        JComponent warningPanel = this.createWarningPanel();
        warningPanel.setAlignmentX(0.0f);
        Box box = Box.createVerticalBox();
        box.add(warningPanel);
        if (this.multiTextKey == null) {
            JEditorPane text = this.createPrompt();
            box.add(this.createWarningMorePrompt(text));
        }
        return box;
    }

    private JEditorPane createPrompt() {
        JEditorPane text = new JEditorPane();
        text.setEditorKit(new PromptEditorKit(ssvSmallFont, ssvBoldFont, true));
        text.setContentType("text/html");
        text.setPreferredSize(this.getPromptPreferredSize(this.getMessage(this.promptKey)));
        text.setText(this.html(this.getMessage(this.promptKey)));
        text.setEditable(false);
        text.setFocusable(false);
        text.setOpaque(false);
        return text;
    }

    private String html(String string) {
        String bolded = string.replaceAll("(" + this.getMessage(this.runTextKey) + ")|(" + this.getMessage(this.updateTextKey) + ")|(" + this.getMessage(this.cancelTextKey) + ")", "<b>$0</b>");
        return "<html><body>" + bolded + "</body></html>";
    }

    private Dimension getPromptPreferredSize(String text) {
        JEditorPane dummy = new JEditorPane();
        dummy.setFont(dummy.getFont().deriveFont(1));
        Font derivedFont = dummy.getFont();
        dummy.setSize(480, Short.MAX_VALUE);
        dummy.setText(text);
        Dimension preferredSize = dummy.getPreferredSize();
        int fontHeight = dummy.getFontMetrics(derivedFont).getHeight();
        int extraHeight = fontHeight / 2;
        if (preferredSize.height > fontHeight) {
            extraHeight *= preferredSize.height / fontHeight;
        }
        preferredSize.height = preferredSize.height + extraHeight + 10;
        return preferredSize;
    }

    private JComponent createWarningPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 0));
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.createShieldIcon(), "West");
        Box vBox = Box.createVerticalBox();
        vBox.setOpaque(false);
        JSmartTextArea ta = new JSmartTextArea(this.getMessage(this.mainTextKey));
        ta.setFont(ssvBoldFont);
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setOpaque(false);
        ta.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        vBox.add(ta);
        vBox.add(this.createSourcesPanel());
        panel.add((Component)vBox, "Center");
        return panel;
    }

    private JComponent createShieldIcon() {
        JLabel warningIcon = new JLabel();
        warningIcon.setOpaque(false);
        warningIcon.setIcon(ResourceManager.getIcon("warning48s.image"));
        warningIcon.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 20));
        Box box = Box.createVerticalBox();
        box.add(warningIcon);
        box.add(Box.createVerticalGlue());
        return box;
    }

    private JComponent createSourcesPanel() {
        System.out.println(invokeCount++);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel sourcesPanel = new JPanel(gb);
        sourcesPanel.setOpaque(false);
        sourcesPanel.setBorder(BorderFactory.createEmptyBorder());
        this.putLabelsToPanel(sourcesPanel, gb, c, this.createURLLabel(this.locationKey), this.createURLInfo(this.ainfo.getDisplayFrom(), this.ainfo.getFrom().toString()));
        if (this.ainfo.shouldDisplayMainJNLP()) {
            this.putLabelsToPanel(sourcesPanel, gb, c, Box.createGlue(), this.createURLInfo(this.ainfo.getDisplayMainJNLP(), this.ainfo.getDisplayMainJNLPTooltip()));
        }
        if (this.ainfo.shouldDisplayDocumentBase()) {
            this.putLabelsToPanel(sourcesPanel, gb, c, Box.createGlue(), this.createURLInfo(this.ainfo.getDisplayDocumentBase(), this.ainfo.getDocumentBase().toString()));
        }
        return sourcesPanel;
    }

    private void putLabelsToPanel(JPanel panel, GridBagLayout gb, GridBagConstraints c, Component label, Component info) {
        c.fill = 2;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(6, 16, 0, 0);
        gb.setConstraints(label, c);
        panel.add(label);
        c.insets = new Insets(6, 5, 0, 0);
        c.gridwidth = 0;
        c.weightx = 1.0;
        gb.setConstraints(info, c);
        panel.add(info);
    }

    private JComponent createURLLabel(String labelKey) {
        JLabel locationLabel = new JLabel(this.getMessage(labelKey));
        locationLabel.setOpaque(false);
        locationLabel.setFont(ssvSmallBoldFont);
        return locationLabel;
    }

    private JComponent createURLInfo(String diplayURL, String url) {
        SelectableLabel urlLabel = new SelectableLabel(diplayURL);
        urlLabel.setToolTipText(url);
        urlLabel.putClientProperty("html.disable", Boolean.TRUE);
        urlLabel.setOpaque(false);
        return urlLabel;
    }

    private JComponent createOkCancelPanel() {
        JButton[] btns;
        JPanel decisionPanel = new JPanel();
        decisionPanel.setLayout(new FlowLayout(2));
        this.runButton = this.makeButton(this.runTextKey);
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SSV3DialogContent.this.runAction();
            }
        });
        decisionPanel.add(this.runButton);
        if (this.updateTextKey != null) {
            this.updateButton = this.makeButton(this.updateTextKey);
            this.updateButton.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SSV3DialogContent.this.updateAction();
                }
            });
            decisionPanel.add(this.updateButton);
        }
        this.cancelButton = this.makeButton(this.cancelTextKey);
        this.cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SSV3DialogContent.this.cancelAction();
            }
        };
        this.cancelButton.addActionListener(this.cancelAction);
        this.template.setCancelAction(this.cancelAction);
        if (this.updateButton == null) {
            btns = new JButton[]{this.runButton, this.cancelButton};
            this.cancelButton.requestFocusInWindow();
            this.template.getDialog().getRootPane().setDefaultButton(this.cancelButton);
        } else {
            btns = new JButton[]{this.runButton, this.updateButton, this.cancelButton};
            this.updateButton.requestFocusInWindow();
            this.template.getDialog().getRootPane().setDefaultButton(this.updateButton);
        }
        DialogTemplate.resizeButtons(btns);
        decisionPanel.add(this.cancelButton);
        decisionPanel.setOpaque(false);
        decisionPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        Box box = Box.createVerticalBox();
        this.createMultiSelection(box);
        box.add(decisionPanel);
        return box;
    }

    private void createMultiSelection(Box box) {
        if (this.multiPromptKey != null && this.multiTextKey != null) {
            this.runButton.setEnabled(false);
            JLabel multiMessage = new JLabel(this.getMessage(this.multiPromptKey));
            multiMessage.setOpaque(false);
            multiMessage.setFont(ssvSmallBoldFont);
            Box vb = this.createWarningMorePrompt(multiMessage);
            Box mb = Box.createHorizontalBox();
            mb.add(vb);
            mb.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            box.add(mb);
            this.multiClickCheckBox = new JCheckBox();
            this.setupCheckbox(box, this.multiTextKey, this.multiClickCheckBox);
            this.multiClickCheckBox.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SSV3DialogContent.this.runButton.setEnabled(SSV3DialogContent.this.multiClickCheckBox.isSelected());
                    if (SSV3DialogContent.this.multiClickCheckBox.isSelected()) {
                        SSV3DialogContent.this.template.getDialog().getRootPane().setDefaultButton(SSV3DialogContent.this.runButton);
                        SSV3DialogContent.this.runButton.requestFocusInWindow();
                    } else if (SSV3DialogContent.this.updateButton != null) {
                        SSV3DialogContent.this.template.getDialog().getRootPane().setDefaultButton(SSV3DialogContent.this.updateButton);
                        SSV3DialogContent.this.updateButton.requestFocusInWindow();
                    } else if (SSV3DialogContent.this.cancelButton != null) {
                        SSV3DialogContent.this.template.getDialog().getRootPane().setDefaultButton(SSV3DialogContent.this.cancelButton);
                        SSV3DialogContent.this.cancelButton.requestFocusInWindow();
                    }
                }
            });
        }
    }

    private JComponent getMoreInfoButton() {
        String key = "dialog.template.more.info2";
        FancyButton moreInfoButton = new FancyButton(this.getMessage(key), ResourceManager.getMnemonic(key));
        moreInfoButton.setFont(ssvSmallFont);
        moreInfoButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getComponent() instanceof FancyButton) {
                    SSV3DialogContent.this.showMoreInfo();
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
            }

            @Override
            public void mouseReleased(MouseEvent me) {
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }
        });
        moreInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SSV3DialogContent.this.showMoreInfo();
            }
        });
        moreInfoButton.setAlignmentX(0.0f);
        moreInfoButton.setBorder(BorderFactory.createEmptyBorder());
        return moreInfoButton;
    }

    private void showMoreInfo() {
        ArrayList<String> moreInfo = new ArrayList<String>();
        if (SSV3DialogContent.isLocalApp(this.ainfo)) {
            moreInfo.add(this.getMessage("sandbox.security.info.local.description"));
        } else {
            moreInfo.add(this.getMessage("sandbox.security.info.description"));
        }
        if (this.updateTextKey != null) {
            moreInfo.add(this.getMessage("deployment.dialog.ssv3.more.insecure"));
        }
        if (SSV3DialogContent.isLocalApp(this.ainfo)) {
            moreInfo.add(this.getMessage("deployment.dialog.ssv3.more.local"));
        }
        if (this.multiTextKey != null) {
            moreInfo.add(this.getMessage("deployment.dialog.ssv3.more.multi"));
        }
        moreInfo.add(this.getMessage("deployment.dialog.ssv3.more.general"));
        MoreInfoDialog info = new MoreInfoDialog(this.template.getDialog(), moreInfo.toArray(new String[moreInfo.size()]), null, 0, null, 0, 0, false, false, false);
        info.setVisible(true);
    }

    private static boolean isLocalApp(AppInfo ai) {
        URL u = ai.getFrom();
        return u != null && u.getProtocol().equals("file");
    }

    private Box createWarningMorePrompt(JComponent messagePrompt) {
        messagePrompt.setAlignmentX(0.0f);
        Box vb = Box.createVerticalBox();
        vb.add(this.getMoreInfoButton());
        vb.add(Box.createVerticalStrut(10));
        vb.add(messagePrompt);
        return vb;
    }

    private void setupCheckbox(Box box, String checkboxTextKey, JCheckBox checkboxField) {
        if (checkboxTextKey != null) {
            checkboxField.setOpaque(false);
            checkboxField.setText(this.getMessage(checkboxTextKey));
            checkboxField.setMnemonic(this.getShortCut(checkboxTextKey));
            Box cb = Box.createHorizontalBox();
            cb.add(checkboxField);
            cb.add(Box.createHorizontalGlue());
            box.add(cb);
        }
    }

    private JButton makeButton(String textKey) {
        JButton b = new JButton(this.getMessage(textKey));
        int shortCut = this.getShortCut(textKey);
        if (shortCut > 0) {
            b.setMnemonic(shortCut);
        }
        b.setOpaque(false);
        return b;
    }

    private void runAction() {
        this.userAnswer = 0;
        this.closeDialog();
    }

    private void updateAction() {
        try {
            Platform.get().updateJava(this.updateURL.toString());
        }
        catch (Exception e) {
            Trace.ignored(e);
        }
    }

    private void closeDialog() {
        this.template.setVisible(false);
    }

    private void cancelAction() {
        this.userAnswer = 1;
        this.closeDialog();
    }

    private String getMessage(String key) {
        if (key == null) {
            return null;
        }
        return ResourceManager.getString(key);
    }

    private int getShortCut(String key) {
        return ResourceManager.getMnemonic(key);
    }

    private static void setSSVFonts() {
        if (ssvFont == null) {
            int size;
            JLabel label = new JLabel();
            int small = size = ResourceManager.getUIFont().getSize();
            int medium = size + 1;
            int big = size + 4;
            ssvSmallFont = label.getFont().deriveFont(0, small);
            ssvSmallBoldFont = label.getFont().deriveFont(1, small);
            ssvFont = label.getFont().deriveFont(0, medium);
            ssvBoldFont = label.getFont().deriveFont(1, medium);
            ssvBigBoldFont = label.getFont().deriveFont(1, big);
        }
    }

    static {
        invokeCount = 0;
    }
}

