/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.ui.ManageSelection;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class JSmartTextArea
extends JTextArea {
    private static final long serialVersionUID = 5787147550544751729L;
    protected static final int JCP_FIXED_WIDTH = 520;
    int preferred_width = 480;

    public JSmartTextArea(String text) {
        this();
        this.setText(text);
    }

    public JSmartTextArea() {
        JLabel label = new JLabel();
        this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.setEditable(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setFont(label.getFont());
        this.setFocusable(false);
        this.setRows(0);
        this.invalidate();
    }

    public JSmartTextArea(int fz, int my_width, boolean bold) {
        this.preferred_width = my_width;
        JLabel label = new JLabel();
        Font system_font = label.getFont();
        Font new_font = bold ? system_font.deriveFont(1, fz) : system_font.deriveFont(system_font.getStyle(), fz);
        this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.setEditable(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setFont(new_font);
        this.setRows(0);
        this.setFocusable(false);
        this.invalidate();
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.invalidate();
    }

    public void setSelectable() {
        this.setFocusable(true);
        ManageSelection manageSelection = new ManageSelection(this);
        this.addFocusListener(manageSelection);
        this.addMouseListener(manageSelection);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setBackground(new Color(this.getParent().getBackground().getRGB()));
        super.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d;
        if (this.getRows() == 0 && this.getColumns() == 0) {
            int columns = this.preferred_width / this.getColumnWidth();
            this.setColumns(columns);
            d = super.getPreferredSize();
            this.setColumns(0);
        } else {
            d = super.getPreferredSize();
        }
        return d;
    }
}

