/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.ref.AppModel;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.LinkedList;

public class AppInfo {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_APPLET = 2;
    public static final int TYPE_LIBRARY = 3;
    public static final int TYPE_INSTALLER = 4;
    public static final int ICON_SIZE = 48;
    public static final int TITLE_MAX = 40;
    public static final int VENDOR_MAX = 40;
    public static final int URL_MAX = 80;
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_SANDBOX = 1;
    public static final int MODE_ENHANCED = 2;
    private static final String JNLP_FROM_UNKNOWN_SOURCE = "tag93872907981234for.jnlp";
    private int type = 0;
    private String title = null;
    private String vendor = null;
    private URL from = null;
    private URL mainJNLP = null;
    private URL documentBase = null;
    private URL iconRef = null;
    private String iconVersion = null;
    private boolean desktopHint = false;
    private boolean menuHint = false;
    private String submenu = null;
    private AssociationDesc[] associations = null;
    private int security = 0;
    private URL lapURL = null;
    private boolean permissionAttr = false;
    private boolean hasSignedJNLP = false;
    private String appArgs = null;
    private URL emURL = null;
    private String emVersion = null;
    private String hashString = null;
    private boolean permissionAttrOverride = false;
    private AppModel appModel = null;
    private String blockedText = null;
    private Throwable throwable = null;
    private static final AccessControlContext ACC_FILE_INSTANCE;

    public AppInfo() {
        this.type = 2;
        this.title = this.getTitleFromAppContext();
    }

    public AppInfo(Throwable throwable) {
        this.throwable = throwable;
        this.title = this.getTitleFromAppContext();
    }

    private String getTitleFromAppContext() {
        Object obj = ToolkitStore.get().getAppContext().get("deploy.trust.decider.app.name");
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public AppInfo(int type, String title, String vendor, URL from, URL mainJNLP, URL iconRef, String iconVersion, boolean desktop, boolean menu, String submenu, AssociationDesc[] associations) {
        this.type = type;
        this.title = title;
        this.vendor = vendor;
        this.from = from;
        this.mainJNLP = mainJNLP;
        this.iconRef = iconRef;
        this.iconVersion = iconVersion;
        this.desktopHint = desktop;
        this.menuHint = menu;
        this.submenu = submenu;
        if (associations != null) {
            this.associations = (AssociationDesc[])associations.clone();
        }
        this.lapURL = from;
    }

    public AppInfo(AppInfo template) {
        this.type = template.type;
        this.title = template.title;
        this.vendor = template.vendor;
        this.from = template.from;
        this.mainJNLP = template.mainJNLP;
        this.documentBase = template.documentBase;
        this.iconRef = template.iconRef;
        this.iconVersion = template.iconVersion;
        this.desktopHint = template.desktopHint;
        this.menuHint = template.menuHint;
        this.submenu = template.submenu;
        if (template.associations != null) {
            this.associations = (AssociationDesc[])template.associations.clone();
        }
        this.security = template.security;
        this.lapURL = template.lapURL;
        this.permissionAttr = template.permissionAttr;
        this.hasSignedJNLP = template.hasSignedJNLP;
        this.hashString = template.hashString;
        this.appArgs = template.appArgs;
        this.emURL = template.emURL;
        this.emVersion = template.emVersion;
        this.permissionAttrOverride = template.permissionAttrOverride;
        this.blockedText = template.getBlockedText();
    }

    private String limitString(String in, int max) {
        if (in != null && in.length() > max) {
            return in.substring(0, max - 4) + " ...";
        }
        return in;
    }

    public int getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVendor() {
        return this.vendor;
    }

    public URL getFrom() {
        return this.from;
    }

    public URL getMainJNLP() {
        return this.mainJNLP;
    }

    public URL getDocumentBase() {
        return this.documentBase;
    }

    public URL getIconRef() {
        return this.iconRef;
    }

    public String getIconVersion() {
        return this.iconVersion;
    }

    public boolean getDesktopHint() {
        return this.desktopHint;
    }

    public boolean getMenuHint() {
        return this.menuHint;
    }

    public String getSubmenu() {
        return this.submenu;
    }

    public AssociationDesc[] getAssociations() {
        return this.associations != null ? (AssociationDesc[])this.associations.clone() : new AssociationDesc[]{};
    }

    public int getSecurity() {
        return this.security;
    }

    public URL getLapURL() {
        return this.lapURL;
    }

    public boolean hasSignedJNLP() {
        return this.hasSignedJNLP;
    }

    public String getBlockedText() {
        return this.blockedText;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public URL getEMURL() {
        return this.emURL;
    }

    public String getEMVersion() {
        return this.emVersion;
    }

    public String getHashString() {
        if (this.hashString == null) {
            this.hashString = "Main:";
            if (this.emURL != null) {
                try {
                    final Resource ce = ResourceProvider.get().getCachedResource(this.emURL, this.emVersion);
                    if (ce != null) {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws IOException {
                                AppInfo.this.hashString = AppInfo.this.hashString + SystemUtils.getFileChecksum(ce.getDataFile(), null);
                                return null;
                            }
                        }, ACC_FILE_INSTANCE);
                    }
                }
                catch (Exception ioe) {
                    Trace.ignored(ioe);
                }
            }
            if (this.appArgs != null) {
                this.hashString = this.hashString + "JNLP:" + this.getAppArgsHashString();
            }
        }
        return this.hashString;
    }

    public String getAppArgsHashString() {
        return this.appArgs == null ? null : SystemUtils.getChecksum(this.appArgs.getBytes(), null);
    }

    public String getDisplayTitle() {
        return this.limitString(this.title, 40);
    }

    public String getDisplayVendor() {
        return this.limitString(this.vendor, 40);
    }

    public String getDisplayFrom() {
        return AppInfo.truncatedURL(this.from);
    }

    public String getDisplayMainJNLP() {
        if (this.isJNLPSourceUnknown()) {
            return ResourceManager.getString("deployment.dialog.jnlp.downloaded");
        }
        return AppInfo.truncatedURL(this.mainJNLP);
    }

    public String getDisplayMainJNLPTooltip() {
        String tooltip = "";
        if (this.isJNLPSourceUnknown()) {
            tooltip = ResourceManager.getString("deployment.dialog.jnlp.downloaded.tooltip");
        } else if (this.mainJNLP != null) {
            tooltip = this.getMainJNLP().toString();
        }
        return tooltip;
    }

    public boolean isJNLPSourceUnknown() {
        return this.mainJNLP != null && this.mainJNLP.getProtocol().equals("file") && this.mainJNLP.getFile().endsWith(JNLP_FROM_UNKNOWN_SOURCE);
    }

    public String getDisplayDocumentBase() {
        return AppInfo.truncatedURL(this.documentBase);
    }

    public boolean shouldDisplayMainJNLP() {
        if (this.mainJNLP == null || "file".equals(this.mainJNLP.getProtocol()) && "".equals(this.mainJNLP.getHost()) && !this.mainJNLP.getPath().endsWith(JNLP_FROM_UNKNOWN_SOURCE)) {
            return false;
        }
        return !URLUtil.sameBase(this.from, this.mainJNLP);
    }

    public boolean shouldDisplayDocumentBase() {
        if (this.documentBase == null || "file".equals(this.documentBase.getProtocol()) && "".equals(this.documentBase.getHost())) {
            return false;
        }
        if (this.mainJNLP == null) {
            return !URLUtil.sameBase(this.from, this.documentBase);
        }
        return !URLUtil.sameBase(this.from, this.documentBase) && !URLUtil.sameBase(this.mainJNLP, this.documentBase);
    }

    public boolean isMultiHost() {
        return this.shouldDisplayDocumentBase() || this.shouldDisplayMainJNLP();
    }

    public URL[] getMultiHostUrls() {
        LinkedList<URL> result = new LinkedList<URL>();
        result.add(this.getFrom());
        if (this.shouldDisplayMainJNLP()) {
            result.add(this.getMainJNLP());
        }
        if (this.shouldDisplayDocumentBase()) {
            result.add(this.getDocumentBase());
        }
        return result.toArray(new URL[result.size()]);
    }

    public static String truncatedURL(URL url) {
        int len;
        if (url == null) {
            return "";
        }
        String result = url.getProtocol() + "://" + url.getHost();
        int port = url.getPort();
        if (port != -1) {
            result = result + ":" + Integer.toString(port);
        }
        if ((len = result.length()) <= 80) {
            return result;
        }
        return result.substring(0, 77) + "...";
    }

    public String toString() {
        return "Appinfo:\ntype = " + this.type + "\ntitle = " + this.title + "\nvendor = " + this.vendor + "\nfrom = " + this.from + "\nsecurity = " + this.security + "\nlapURL = " + this.lapURL + "\nappArgs = " + this.appArgs;
    }

    public boolean hasPermissionAttr() {
        if (this.permissionAttrOverride) {
            return true;
        }
        return this.permissionAttr;
    }

    public void setPermissionAttrOverride() {
        this.permissionAttrOverride = true;
    }

    public void unsetPermissionAttrOverride() {
        this.permissionAttrOverride = false;
    }

    public void setPermissionAttr(boolean attr) {
        this.permissionAttr = attr;
    }

    public void setType(int i) {
        this.type = i;
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public void setVendor(String s) {
        this.vendor = s;
    }

    public void setFrom(URL u) {
        this.from = u;
    }

    public void setMainJNLP(URL u) {
        this.mainJNLP = u;
    }

    public void setDocumentBase(URL u) {
        this.documentBase = u;
    }

    public void setIconRef(URL url) {
        this.iconRef = url;
    }

    public void setIconVersion(String s) {
        this.iconVersion = s;
    }

    public void setDesktopHint(boolean b) {
        this.desktopHint = b;
    }

    public void setMenuHint(boolean b) {
        this.menuHint = b;
    }

    public void setSubmenu(String s) {
        this.submenu = s;
    }

    public void setAssociations(AssociationDesc[] a) {
        this.associations = a != null ? (AssociationDesc[])a.clone() : null;
    }

    public void setSecurity(int mode) {
        this.security = mode;
    }

    public void setLapURL(URL url) {
        this.lapURL = url;
    }

    public void setSignedJNLPL(boolean signed) {
        this.hasSignedJNLP = signed;
    }

    public void setAppArgs(String args) {
        this.appArgs = args;
    }

    public void setEMURL(URL url) {
        this.emURL = url;
    }

    public void setEMVersion(String ver) {
        this.emVersion = ver;
    }

    public void setBlockedText(String s) {
        this.blockedText = s;
    }

    public void setThrowable(Throwable t) {
        this.throwable = t;
    }

    public static AppInfo createSingleHostAppInfo(AppInfo template) {
        AppInfo result = new AppInfo(template);
        result.setDocumentBase(null);
        result.setMainJNLP(null);
        return result;
    }

    public static URL getJNLPFromUnknownSource() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    return new File("", AppInfo.JNLP_FROM_UNKNOWN_SOURCE).toURI().toURL();
                }
            });
        }
        catch (Exception e) {
            Trace.ignored(e);
            return null;
        }
    }

    public void setAppModel(AppModel appModel) {
        this.appModel = appModel;
    }

    public AppModel getAppModel() {
        return this.appModel;
    }

    static {
        Permissions perms = new Permissions();
        FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write");
        ((PermissionCollection)perms).add(perm);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }
}

