/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.DeploySIListener;
import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.ui.UITextArea;
import com.sun.deploy.util.DeployUIManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;

public class AboutDialog
extends JDialog
implements DeploySIListener {
    private static final long serialVersionUID = 6981940603918151921L;
    private SingleInstanceImpl sil = null;
    private static String ABOUT_JAVA_ID = "com_sun_deploy_AboutJava-" + Config.getStringProperty("deployment.version");
    private static final String TEXT_COLOR = "#7A7277";
    private static final String LINK_COLOR = "#214F83";
    private static final String LINK_HIGHLIGHT_COLOR = "#C03F3F";

    public AboutDialog(JFrame parent, boolean modal, boolean si) {
        super((Frame)parent, modal);
        if (si) {
            this.initSIImpl();
        }
        this.initComponents();
    }

    public AboutDialog(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
    }

    public AboutDialog(JDialog parent, boolean modal) {
        super((Dialog)parent, modal);
        this.initComponents();
    }

    private void initSIImpl() {
        this.sil = new SingleInstanceImpl();
        this.sil.addSingleInstanceListener(this, ABOUT_JAVA_ID);
    }

    public static boolean shouldStartNewInstance() {
        return !SingleInstanceManager.isServerRunning(ABOUT_JAVA_ID) || !SingleInstanceManager.connectToServer("");
    }

    private void initComponents() {
        this.setTitle(ResourceManager.getString("about.dialog.title"));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AboutDialog.this.closeDialog();
            }
        });
        Color backgrnd = Color.white;
        Color foregrnd = new Color(122, 114, 119);
        JPanel pane = new JPanel(new BorderLayout());
        pane.setForeground(backgrnd);
        pane.setBackground(backgrnd);
        pane.setOpaque(true);
        pane.setBorder(BorderFactory.createLineBorder(Color.black));
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        pane.setLayout(gb);
        c.fill = 1;
        ImageIcon imageTopIcon = ResourceManager.getIconResource("aboutjava.png");
        JLabel topImage = new JLabel(imageTopIcon);
        c.gridwidth = 0;
        gb.setConstraints(topImage, c);
        pane.add(topImage);
        final int lineWidth = imageTopIcon.getIconWidth() - 20;
        String version = this.getVersion();
        String buildInfo = this.getBuildInfo();
        String copyright = ResourceManager.getString("about.copyright", BuiltInProperties.getProperty("DEPLOY_COPYRIGHT_YEAR"));
        String strInfo = ResourceManager.getString("about.prompt.info");
        String linkURL = ResourceManager.getString("about.home.link");
        Font derivedFont = ResourceManager.getUIFont().deriveFont((float)DialogTemplate.getSubpanelFontSize());
        JLabel versionText = new JLabel(version);
        versionText.setForeground(foregrnd);
        versionText.setBackground(backgrnd);
        versionText.setFont(derivedFont);
        JTextArea buildText = new JTextArea(buildInfo);
        buildText.setEditable(false);
        buildText.setForeground(foregrnd);
        buildText.setBackground(backgrnd);
        buildText.setFont(derivedFont);
        UITextArea topText = new UITextArea(DialogTemplate.getSubpanelFontSize(), lineWidth, false);
        topText.setText(copyright);
        topText.setForeground(foregrnd);
        JPanel topTextPanel = new JPanel();
        topTextPanel.setBackground(backgrnd);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints co = new GridBagConstraints();
        topTextPanel.setLayout(gbl);
        co.fill = 1;
        co.gridwidth = -1;
        gbl.setConstraints(versionText, co);
        topTextPanel.add(versionText);
        co.gridwidth = 0;
        co.fill = 2;
        co.anchor = 15;
        co.insets = new Insets(0, 10, 0, 0);
        gbl.setConstraints(buildText, co);
        topTextPanel.add(buildText);
        co.fill = 1;
        co.insets = new Insets(0, 0, 0, 0);
        co.weightx = 0.0;
        gbl.setConstraints(topText, co);
        topTextPanel.add(topText);
        final String infoText = new StringBuffer("<font face=").append(ResourceManager.getUIFont().getFamily()).append(" color=#7A7277>").append(strInfo).append(" ").append(" <a style='color:#214F83' href=").append(linkURL).append('>').append(linkURL).append("</a></font>").toString();
        final JEditorPane editPane = new JEditorPane(){

            @Override
            public Dimension getPreferredSize() {
                if (this.getWidth() == 0) {
                    Insets insets = this.getInsets();
                    this.setSize(lineWidth, insets.top + insets.bottom + 1);
                }
                Dimension pref = super.getPreferredSize();
                pref.width = this.getWidth();
                return pref;
            }
        };
        editPane.setFont(derivedFont);
        editPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        editPane.setContentType("text/html");
        editPane.setText(infoText);
        editPane.setForeground(foregrnd);
        editPane.setBackground(backgrnd);
        FontMetrics fm = editPane.getFontMetrics(derivedFont);
        int txtLen = fm.stringWidth(strInfo + linkURL);
        editPane.setEditable(false);
        editPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Platform.get().showDocument(e.getURL().toString());
                } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    editPane.setText(infoText.replaceFirst("color:#214F83", "color:#C03F3F"));
                } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    editPane.setText(infoText);
                }
            }
        });
        c.insets = new Insets(10, 10, 0, 10);
        gb.setConstraints(topTextPanel, c);
        pane.add(topTextPanel);
        c.insets = new Insets(10, 10, 30, 10);
        gb.setConstraints(editPane, c);
        pane.add(editPane);
        JLabel sunLogoLabel = new JLabel();
        ImageIcon icon = ResourceManager.getIcon("sun.logo.image");
        sunLogoLabel.setIcon(icon);
        c.insets = new Insets(0, 10, 10, 10);
        switch (OSType.getOSType()) {
            case 2: 
            case 3: {
                c.ipady += 14;
            }
        }
        gb.setConstraints(sunLogoLabel, c);
        pane.add(sunLogoLabel);
        MouseInputAdapter closeOnMouseClick = new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AboutDialog.this.closeDialog();
            }
        };
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.closeDialog();
            }
        };
        this.getContentPane().addMouseListener(closeOnMouseClick);
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(2).put(esc, "cancel");
        KeyStroke ret = KeyStroke.getKeyStroke(10, 0);
        this.getRootPane().getInputMap(2).put(ret, "cancel");
        this.getRootPane().getActionMap().put("cancel", closeAction);
        editPane.getInputMap().put(esc, "cancel");
        editPane.getActionMap().put("cancel", null);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)pane, "Center");
        if (OSType.getOSType() == 3) {
            this.getRootPane().putClientProperty("Window.zoomable", "false");
        }
        this.pack();
        this.setResizable(false);
        UIFactory.placeWindow(this);
    }

    private void closeDialog() {
        if (this.sil != null) {
            this.sil.removeSingleInstanceListener(this);
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void newActivation(String[] params) {
        this.toFront();
    }

    @Override
    public Object getSingleInstanceListener() {
        return this;
    }

    private String getVersion() {
        String javaVersion = System.getProperty("java.version");
        boolean isOldVersion = javaVersion.startsWith("1.");
        if (isOldVersion) {
            return this.getOldVersion();
        }
        return this.getNewVersion();
    }

    private String getNewVersion() {
        String javaVersion = System.getProperty("java.version");
        return ResourceManager.getString("about.java.version", javaVersion);
    }

    private String getOldVersion() {
        int dashIdx;
        String javaVersion = System.getProperty("java.version");
        int firstDot = javaVersion.indexOf(".");
        String marketingVersion = javaVersion.substring(firstDot + 1, javaVersion.indexOf(".", firstDot + 1));
        int pos = javaVersion.lastIndexOf("_");
        String updateVersion = null;
        if (pos != -1 && (updateVersion = (dashIdx = javaVersion.indexOf("-")) != -1 ? javaVersion.substring(pos + 1, dashIdx) : javaVersion.substring(pos + 1, javaVersion.length())).startsWith("0")) {
            updateVersion = updateVersion.substring(1);
        }
        String version = updateVersion != null ? ResourceManager.getString("about.java.version.update", marketingVersion, updateVersion) : ResourceManager.getString("about.java.version", marketingVersion);
        return version;
    }

    private String getBuildInfo() {
        return ResourceManager.getString("about.java.build", System.getProperty("java.runtime.version"));
    }

    static {
        DeployUIManager.setLookAndFeel();
    }
}

