/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertType;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.ClientCertDialog;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.security.DeployKeyStore;
import com.sun.deploy.security.PasswordCallbackHandler;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509KeyManager;

public final class X509DeployKeyManager
implements X509KeyManager {
    private X509KeyManager myKeyManager = null;
    private X509KeyManager browserKeyManager = null;
    private String userKeyStore = null;
    private String systemKeyStore = null;
    private DeployKeyStore browserKeyStore = null;
    private boolean isWindows = Config.getOSName().indexOf("Windows") != -1;
    private static HashMap<String, String> clientAuthCertsCachedMap = new HashMap();
    private static ThreadLocal<Boolean> clientCertDialogCancelled = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static ThreadLocal<Boolean> passwdDialogCancelled = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public X509DeployKeyManager() {
        this.userKeyStore = Config.getUserClientAuthCertFile();
        this.systemKeyStore = Config.getSystemClientAuthCertFile();
        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
            Service service = ServiceManager.getService();
            this.browserKeyStore = service.getBrowserClientAuthKeyStore();
        }
    }

    private void init() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
                    X509DeployKeyManager.this.do_init();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof KeyStoreException) {
                throw (KeyStoreException)ex;
            }
            if (ex instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ex;
            }
            if (ex instanceof NoSuchProviderException) {
                throw (NoSuchProviderException)ex;
            }
            if (ex instanceof FileNotFoundException) {
                throw (FileNotFoundException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)ex;
            }
            if (ex instanceof CertificateException) {
                throw (CertificateException)ex;
            }
            Trace.securityPrintException(e);
        }
    }

    private void do_init() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        this.browserKeyManager = this.getBrowserKeyManager(this.browserKeyStore);
        this.myKeyManager = this.getNewMyKeyManager(this.userKeyStore, this.systemKeyStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        TreeMap<String, X509Certificate[]> clientAuthCertsMap = new TreeMap<String, X509Certificate[]>();
        TreeMap<String, CertType> clientAuthTypeMap = new TreeMap<String, CertType>();
        String certName = null;
        String hostname = null;
        if (clientCertDialogCancelled.get().equals(Boolean.FALSE)) {
            hostname = this.getHostnameForSocket(socket);
            for (int i = 0; i < keyType.length; ++i) {
                String[] aliases = this.getClientAliases(keyType[i], issuers);
                if (aliases == null || aliases.length <= 0) continue;
                for (int j = 0; j < aliases.length; ++j) {
                    int certTypeLen = CertType.PLUGIN.getType().length();
                    String newAlias = aliases[j].substring(certTypeLen);
                    X509Certificate[] certs = this.getCertificateChain(newAlias);
                    try {
                        if (!CertUtils.checkTLSClient(certs[0])) continue;
                        clientAuthCertsMap.put(newAlias, certs);
                        if (aliases[j].startsWith(CertType.PLUGIN.getType())) {
                            clientAuthTypeMap.put(newAlias, CertType.PLUGIN);
                        }
                        if (!aliases[j].startsWith(CertType.BROWSER.getType())) continue;
                        clientAuthTypeMap.put(newAlias, CertType.BROWSER);
                        continue;
                    }
                    catch (CertificateException ce) {
                        Trace.msgSecurityPrintln("clientauth.checkTLSClient.failed", new Object[]{newAlias});
                    }
                }
            }
            if (passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                final TreeMap<String, X509Certificate[]> theClientAuthCertsMap = clientAuthCertsMap;
                final TreeMap<String, CertType> theClientAuthTypeMap = clientAuthTypeMap;
                if (hostname != null) {
                    HashMap<String, String> j = clientAuthCertsCachedMap;
                    synchronized (j) {
                        if (clientAuthCertsCachedMap.size() > 0) {
                            Iterator<String> hostCachedItor = clientAuthCertsCachedMap.keySet().iterator();
                            String cachedHostname = null;
                            String certNameCached = null;
                            while (hostCachedItor.hasNext()) {
                                cachedHostname = hostCachedItor.next();
                                if (cachedHostname.compareToIgnoreCase(hostname) != 0) continue;
                                certNameCached = clientAuthCertsCachedMap.get(cachedHostname);
                                Trace.msgSecurityPrintln("clientauth.readFromCache.success", new Object[]{certNameCached});
                                return certNameCached;
                            }
                        }
                    }
                }
                if (Config.getBooleanProperty("deployment.security.clientauth.keystore.auto") && theClientAuthCertsMap.size() <= 1) {
                    if (theClientAuthCertsMap.size() == 0) {
                        certName = null;
                    } else {
                        Object[] certNameArray = theClientAuthCertsMap.keySet().toArray();
                        certName = (String)certNameArray[0];
                    }
                } else {
                    DeploySysAction action = new DeploySysAction(){

                        @Override
                        public Object execute() {
                            return ClientCertDialog.showDialog(theClientAuthCertsMap, theClientAuthTypeMap);
                        }
                    };
                    certName = (String)DeploySysRun.executePrivileged(action, null);
                }
            }
            if (certName == null) {
                clientCertDialogCancelled.set(Boolean.TRUE);
            }
            if (socket instanceof SSLSocket) {
                MyListener myListener = new MyListener(hostname, certName);
                ((SSLSocket)socket).addHandshakeCompletedListener(myListener);
            }
            return certName;
        }
        return null;
    }

    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseClientAlias(keyType, issuers, null);
    }

    @Override
    public synchronized String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String serverAliasName = null;
        if (this.myKeyManager != null) {
            serverAliasName = this.myKeyManager.chooseServerAlias(keyType, issuers, socket);
        }
        if (serverAliasName == null && this.browserKeyManager != null) {
            serverAliasName = this.browserKeyManager.chooseServerAlias(keyType, issuers, socket);
        }
        return serverAliasName;
    }

    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseServerAlias(keyType, issuers, null);
    }

    @Override
    public synchronized X509Certificate[] getCertificateChain(String alias) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        X509Certificate[] certChain = null;
        if (this.myKeyManager != null && !alias.contains("Mozilla") && !alias.contains("MSCrypto")) {
            certChain = this.myKeyManager.getCertificateChain(alias);
        }
        if (certChain == null && this.browserKeyManager != null) {
            certChain = this.browserKeyManager.getCertificateChain(alias);
        }
        return certChain;
    }

    @Override
    public synchronized String[] getClientAliases(String keyType, Principal[] issuers) {
        int i;
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] myClientAliases = null;
        String[] browserClientAliases = null;
        if (this.myKeyManager != null) {
            myClientAliases = this.myKeyManager.getClientAliases(keyType, issuers);
        }
        if (this.browserKeyManager != null) {
            browserClientAliases = this.browserKeyManager.getClientAliases(keyType, issuers);
        }
        if (myClientAliases == null) {
            if (browserClientAliases != null) {
                for (int i2 = 0; i2 < browserClientAliases.length; ++i2) {
                    browserClientAliases[i2] = CertType.BROWSER.getType() + browserClientAliases[i2];
                }
            }
            return browserClientAliases;
        }
        if (browserClientAliases == null) {
            if (myClientAliases != null) {
                for (int i3 = 0; i3 < myClientAliases.length; ++i3) {
                    myClientAliases[i3] = CertType.PLUGIN.getType() + myClientAliases[i3];
                }
            }
            return myClientAliases;
        }
        for (i = 0; i < myClientAliases.length; ++i) {
            myClientAliases[i] = CertType.PLUGIN.getType() + myClientAliases[i];
        }
        for (i = 0; i < browserClientAliases.length; ++i) {
            browserClientAliases[i] = CertType.BROWSER.getType() + browserClientAliases[i];
        }
        String[] temp = new String[myClientAliases.length + browserClientAliases.length];
        System.arraycopy(myClientAliases, 0, temp, 0, myClientAliases.length);
        System.arraycopy(browserClientAliases, 0, temp, myClientAliases.length, browserClientAliases.length);
        return temp;
    }

    @Override
    public synchronized String[] getServerAliases(String keyType, Principal[] issuers) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] myServerAliases = null;
        String[] browserServerAliases = null;
        if (this.myKeyManager != null) {
            myServerAliases = this.myKeyManager.getServerAliases(keyType, issuers);
        }
        if (this.browserKeyManager != null) {
            browserServerAliases = this.browserKeyManager.getServerAliases(keyType, issuers);
        }
        if (myServerAliases == null) {
            return browserServerAliases;
        }
        if (browserServerAliases == null) {
            return myServerAliases;
        }
        String[] temp = new String[myServerAliases.length + browserServerAliases.length];
        System.arraycopy(myServerAliases, 0, temp, 0, myServerAliases.length);
        System.arraycopy(browserServerAliases, 0, temp, myServerAliases.length, browserServerAliases.length);
        return temp;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        try {
            if (this.myKeyManager == null && this.browserKeyManager == null && passwdDialogCancelled.get().equals(Boolean.FALSE)) {
                this.init();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PrivateKey privateKey = null;
        if (this.myKeyManager != null && !alias.contains("Mozilla") && !alias.contains("MSCrypto")) {
            privateKey = this.myKeyManager.getPrivateKey(alias);
        }
        if (privateKey == null && this.browserKeyManager != null) {
            privateKey = this.browserKeyManager.getPrivateKey(alias);
        }
        return privateKey;
    }

    private X509KeyManager getBrowserKeyManager(DeployKeyStore myBrowserKeyStore) throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        X509KeyManager myBrowserKeyManager = null;
        if (myBrowserKeyStore != null) {
            try {
                KeyStore[] keyStores = myBrowserKeyStore.getKeyStores();
                KeyStore.Builder[] builders = new KeyStore.Builder[keyStores.length];
                for (int i = 0; i < keyStores.length; ++i) {
                    keyStores[i].load(null, new char[0]);
                    builders[i] = KeyStore.Builder.newInstance(keyStores[i], (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(null));
                }
                KeyStoreBuilderParameters ksParams = new KeyStoreBuilderParameters(Arrays.asList(builders));
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("NewSunX509");
                kmf.init(ksParams);
                KeyManager[] kmArray = kmf.getKeyManagers();
                for (int i = 0; i < kmArray.length; ++i) {
                    if (!(kmArray[i] instanceof X509KeyManager)) continue;
                    myBrowserKeyManager = (X509KeyManager)kmArray[i];
                    break;
                }
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
        }
        return myBrowserKeyManager;
    }

    private X509KeyManager getNewMyKeyManager(String userMykeyStore, String systemMykeyStore) throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, FileNotFoundException, IOException, UnrecoverableKeyException, CertificateException {
        X509KeyManager myNewKeyManager;
        block6: {
            myNewKeyManager = null;
            File userKeyStoreFile = new File(userMykeyStore);
            File systemKeyStoreFile = new File(systemMykeyStore);
            if (userKeyStoreFile.exists() || systemKeyStoreFile.exists()) {
                try {
                    PasswordCallbackHandler usermcb = new PasswordCallbackHandler("clientauth.user.password.dialog.text");
                    PasswordCallbackHandler sysmcb = new PasswordCallbackHandler("clientauth.system.password.dialog.text");
                    KeyStore.Builder fsBuilder = null;
                    KeyStore.Builder ssBuilder = null;
                    if (userKeyStoreFile.exists()) {
                        fsBuilder = KeyStore.Builder.newInstance("JKS", null, userKeyStoreFile, new KeyStore.CallbackHandlerProtection(usermcb));
                    }
                    if (systemKeyStoreFile.exists()) {
                        ssBuilder = KeyStore.Builder.newInstance("JKS", null, systemKeyStoreFile, new KeyStore.CallbackHandlerProtection(sysmcb));
                    }
                    KeyStoreBuilderParameters ksParams = new KeyStoreBuilderParameters(Arrays.asList(fsBuilder, ssBuilder));
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance("NewSunX509");
                    kmf.init(ksParams);
                    KeyManager[] kmArray = kmf.getKeyManagers();
                    for (int i = 0; i < kmArray.length; ++i) {
                        if (!(kmArray[i] instanceof X509KeyManager)) continue;
                        myNewKeyManager = (X509KeyManager)kmArray[i];
                        break;
                    }
                }
                catch (Exception ioe) {
                    ioe.printStackTrace();
                    if (Trace.isAutomationEnabled()) break block6;
                    String errorMsg = X509DeployKeyManager.getMessage("clientauth.password.dialog.error.text");
                    String errorTitle = X509DeployKeyManager.getMessage("clientauth.password.dialog.error.caption");
                    ToolkitStore.getUI().showExceptionDialog(null, null, ioe, errorTitle, errorMsg, null, null);
                }
            }
        }
        return myNewKeyManager;
    }

    private char[] getPasswordDialog(String inLabel) {
        CredentialInfo passwordInfo = ToolkitStore.getUI().showPasswordDialog(null, X509DeployKeyManager.getMessage("password.dialog.title"), X509DeployKeyManager.getMessage(inLabel), false, false, null, false, null);
        if (passwordInfo == null) {
            passwdDialogCancelled.set(Boolean.TRUE);
            return null;
        }
        return passwordInfo.getPassword();
    }

    private static String getMessage(String key) {
        return ResourceManager.getString(key);
    }

    String getHostnameForSocket(Socket socket) {
        String hostname = null;
        try {
            if (SSLSocket.class.isInstance(socket)) {
                hostname = ((SSLSocket)socket).getHandshakeSession().getPeerHost();
            }
        }
        catch (Exception ex) {
            Trace.ignored(ex);
        }
        if (hostname == null) {
            Trace.msgSecurityPrintln("clientauth.readFromCache.failed");
        }
        return hostname;
    }

    static final class MyListener
    implements HandshakeCompletedListener {
        private String hostname;
        private String certName;

        public MyListener(String socketHostName, String aliasName) {
            this.hostname = socketHostName;
            this.certName = aliasName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handshakeCompleted(HandshakeCompletedEvent event) {
            if (this.hostname != null) {
                HashMap hashMap = clientAuthCertsCachedMap;
                synchronized (hashMap) {
                    clientAuthCertsCachedMap.put(this.hostname, this.certName);
                }
            }
            try {
                SSLSocket sslSocket = event.getSocket();
                sslSocket.removeHandshakeCompletedListener(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public int hashCode() {
            int hash = 3;
            hash = 17 * hash + (this.hostname != null ? this.hostname.hashCode() : 0);
            hash = 17 * hash + (this.certName != null ? this.certName.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyListener)) {
                return false;
            }
            MyListener newListener = (MyListener)obj;
            return newListener.hostname.compareToIgnoreCase(this.hostname) == 0;
        }
    }
}

