/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertType;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JList;

final class ClientCertDialog {
    ClientCertDialog() {
    }

    static String showDialog(TreeMap<String, X509Certificate[]> clientAuthCertsMap, TreeMap<String, Object> clientAuthTypeMap) {
        int selectedIndex;
        Vector<String> certs = new Vector<String>();
        for (String aliasName : clientAuthCertsMap.keySet()) {
            X509Certificate[] xcerts = clientAuthCertsMap.get(aliasName);
            Object certType = clientAuthTypeMap.get(aliasName);
            String subjectName = CertUtils.extractSubjectAliasName(xcerts[0]);
            String issuerName = CertUtils.extractIssuerAliasName(xcerts[0]);
            String certString = subjectName + ":" + issuerName;
            String key = "clientauth.certlist.dialog.browserKS";
            if (certType.equals(CertType.PLUGIN)) {
                key = "clientauth.certlist.dialog.javaKS";
            }
            certs.add(ResourceManager.getString(key, certString));
        }
        JList<String> certList = new JList<String>();
        certList.setSelectionMode(0);
        certList.setListData(certs);
        if (certs.size() > 0) {
            certList.setSelectedIndex(0);
        }
        String alias = null;
        if (selectedIndex != -1) {
            Iterator<String> iter = clientAuthCertsMap.keySet().iterator();
            for (selectedIndex = ToolkitStore.getUI().showListDialog(null, ClientCertDialog.getMessage("clientauth.certlist.dialog.caption"), ClientCertDialog.getMessage("clientauth.certlist.dialog.text"), null, true, certs, clientAuthCertsMap); selectedIndex >= 0 && iter.hasNext(); --selectedIndex) {
                alias = iter.next();
            }
        }
        return alias;
    }

    private static String getMessage(String key) {
        return ResourceManager.getString(key);
    }
}

