/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.X509Util;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import java.io.IOException;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

final class CertValidator {
    CertValidator() {
    }

    public static boolean validate(CodeSource cs, AppInfo ainfo, Certificate[] certs, int chainNum, CertStore rootStore, CertStore browserRootStore, CertStore browserTrustedStore, CertStore sessionStore, CertStore permanentStore, CertStore deniedStore, DeploymentRuleSet drs) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        String loc = TrustDecider.getLocString(cs.getLocation(), ainfo);
        boolean rootCANotValid = false;
        boolean timeValid = true;
        int certValidity = 0;
        boolean trustDecision = false;
        int start = 0;
        int end = 0;
        HashMap<Principal, Collection<X509Certificate>> trustedPrincipals = CertValidator.getCertMap(rootStore, browserRootStore);
        Date date = new Date();
        certs = CertValidator.canonicalize(certs, date, trustedPrincipals);
        chainNum = 0;
        while (end < certs.length) {
            boolean verified;
            int i;
            CertificateExpiredException certExpiredException = null;
            CertificateNotYetValidException certNotYetValidException = null;
            for (i = start; i < certs.length; ++i) {
                X509Certificate issuerCert;
                X509Certificate currentCert;
                block38: {
                    currentCert = null;
                    if (certs[i] instanceof X509Certificate) {
                        currentCert = (X509Certificate)certs[i];
                    }
                    issuerCert = i + 1 < certs.length && certs[i + 1] instanceof X509Certificate ? (X509Certificate)certs[i + 1] : currentCert;
                    try {
                        currentCert.checkValidity();
                    }
                    catch (CertificateExpiredException e1) {
                        if (certExpiredException == null) {
                            certExpiredException = e1;
                        }
                    }
                    catch (CertificateNotYetValidException e2) {
                        if (certNotYetValidException != null) break block38;
                        certNotYetValidException = e2;
                    }
                }
                if (!(rootStore.contains(currentCert) || i + 1 == certs.length || !CertUtils.isIssuerOf(currentCert, issuerCert) || browserRootStore != null && browserRootStore.contains(currentCert))) {
                    CertUtils.checkUsageForCodeSigning(currentCert, i - start);
                }
                if (!CertUtils.isIssuerOf(currentCert, issuerCert)) break;
                try {
                    currentCert.verify(issuerCert.getPublicKey());
                    continue;
                }
                catch (GeneralSecurityException se) {
                    Trace.msgSecurityPrintln("trustdecider.check.signature");
                    String msg = ResourceManager.getString("trustdecider.check.signature");
                    throw new CertificateException(msg);
                }
            }
            int n = end = i < certs.length ? i + 1 : i;
            if (!drs.isAskGrantShowSet()) {
                String msg = ResourceManager.getString("trustdecider.user.cannot.grant.any");
                throw new CertificateException(msg);
            }
            boolean bl = verified = rootStore.verify(certs[end - 1]) || browserRootStore != null && browserRootStore.verify(certs[end - 1]);
            if (!verified) {
                if (!drs.isAskGrantSelfSignedSet()) {
                    String msg = ResourceManager.getString("trustdecider.user.cannot.grant.notinca");
                    throw new CertificateException(msg);
                }
                rootCANotValid = true;
            }
            if (certExpiredException != null) {
                timeValid = false;
                certValidity = -1;
            }
            if (certNotYetValidException != null) {
                timeValid = false;
                certValidity = 1;
            }
            Date timeStampInfo = null;
            try {
                CodeSigner[] signersArray = cs.getCodeSigners();
                Timestamp ts = signersArray[chainNum].getTimestamp();
                if (ts != null) {
                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.yes");
                    timeStampInfo = ts.getTimestamp();
                    CertPath tsCertPath = ts.getSignerCertPath();
                    if (!timeValid) {
                        Date certNotAfter = ((X509Certificate)certs[end - 1]).getNotAfter();
                        Date certNotBefore = ((X509Certificate)certs[end - 1]).getNotBefore();
                        if (timeStampInfo.before(certNotAfter) && timeStampInfo.after(certNotBefore)) {
                            Trace.msgSecurityPrintln("trustdecider.check.timestamping.valid");
                            boolean tsaValid = CertValidator.checkTSAPath(tsCertPath, date, browserRootStore, rootStore, trustedPrincipals);
                            if (tsaValid) {
                                timeValid = true;
                                certValidity = 0;
                            } else {
                                timeStampInfo = null;
                            }
                        } else {
                            Trace.msgSecurityPrintln("trustdecider.check.timestamping.invalid");
                        }
                    }
                } else {
                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.no");
                }
            }
            catch (NoSuchMethodError nsme) {
                Trace.msgSecurityPrintln("trustdecider.check.timestamping.notfound");
            }
            boolean denyFlag = false;
            if (deniedStore.contains(certs[start])) {
                if (deniedStore.contains(certs[start], loc, true)) {
                    denyFlag = true;
                } else {
                    boolean bl2 = denyFlag = !timeValid;
                }
            }
            if (!denyFlag) {
                if (!rootCANotValid && permanentStore.contains(certs[start]) && (timeValid || !permanentStore.contains(certs[start], loc, true))) {
                    return true;
                }
                if (sessionStore.contains(certs[start]) && (timeValid || !sessionStore.contains(certs[start], loc, true))) {
                    return true;
                }
                if (browserTrustedStore != null && browserTrustedStore.contains(certs[start])) {
                    return true;
                }
                if (drs.isRuleRun()) {
                    return true;
                }
                boolean revStatusUnknown = false;
                int action = X509Util.showSecurityDialog(certs, cs.getLocation(), start, end, rootCANotValid, certValidity, timeStampInfo, ainfo, revStatusUnknown);
                if (action == 0) {
                    Trace.msgSecurityPrintln("trustdecider.user.grant.session");
                    sessionStore.add(certs[start], loc, timeValid);
                    sessionStore.save();
                    trustDecision = true;
                } else if (action == 2) {
                    Trace.msgSecurityPrintln("trustdecider.user.grant.forever");
                    CertStore userPermanentStore = DeploySigningCertStore.getUserCertStore();
                    userPermanentStore.load(true);
                    if (userPermanentStore.add(certs[start], loc, timeValid)) {
                        userPermanentStore.save();
                    }
                    trustDecision = true;
                } else {
                    Trace.msgSecurityPrintln("trustdecider.user.deny");
                    deniedStore.add(certs[start], loc, timeValid);
                    deniedStore.save();
                }
                if (trustDecision) {
                    return true;
                }
            }
            start = end;
            ++chainNum;
        }
        return false;
    }

    private static boolean checkTSAPath(CertPath tsCertPath, Date currDate, CertStore browserRootStore, CertStore rootStore, HashMap<Principal, Collection<X509Certificate>> trustedPrincipals) {
        Trace.msgSecurityPrintln("trustdecider.check.timestamping.tsapath");
        try {
            int tsSize;
            List<? extends Certificate> tsCertList = tsCertPath.getCertificates();
            Object[] tsCertsObj = tsCertList.toArray();
            int certLen = tsCertsObj.length;
            Certificate[] tsCerts = new Certificate[certLen];
            for (int k = 0; k < certLen; ++k) {
                tsCerts[k] = (Certificate)tsCertsObj[k];
            }
            Certificate trustAnchorCert = (tsCerts = CertValidator.canonicalize(tsCerts, currDate, trustedPrincipals))[(tsSize = tsCerts.length) - 1];
            if (rootStore.verify(trustAnchorCert) || browserRootStore != null && browserRootStore.verify(trustAnchorCert)) {
                Trace.msgSecurityPrintln("trustdecider.check.timestamping.valid");
                for (int i = 0; i < tsSize - 1; ++i) {
                    X509Certificate currentCert = (X509Certificate)tsCerts[i];
                    X509Certificate issuerCert = (X509Certificate)tsCerts[i + 1];
                    try {
                        CertUtils.checkUsageForCodeSigning(currentCert, i, true);
                        currentCert.verify(issuerCert.getPublicKey());
                        continue;
                    }
                    catch (GeneralSecurityException se) {
                        Trace.msgSecurityPrintln("trustdecider.check.signature");
                        return false;
                    }
                }
                return true;
            }
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.notinca");
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static synchronized HashMap<Principal, Collection<X509Certificate>> getCertMap(CertStore rootStore, CertStore browserRootStore) throws KeyStoreException {
        HashMap<Principal, Collection<X509Certificate>> trustedPrinMap = new HashMap<Principal, Collection<X509Certificate>>();
        if (rootStore != null) {
            for (X509Certificate cert : rootStore.getCertificates()) {
                if (!(cert instanceof X509Certificate)) continue;
                trustedPrinMap = CertValidator.addTrustedCert(cert, trustedPrinMap);
            }
        }
        if (browserRootStore != null) {
            for (X509Certificate cert : browserRootStore.getCertificates()) {
                if (!(cert instanceof X509Certificate)) continue;
                trustedPrinMap = CertValidator.addTrustedCert(cert, trustedPrinMap);
            }
        }
        return trustedPrinMap;
    }

    private static HashMap<Principal, Collection<X509Certificate>> addTrustedCert(X509Certificate cert, HashMap<Principal, Collection<X509Certificate>> trustedPrincipals) {
        Principal principal = X509Util.getSubjectPrincipal(cert);
        Collection<X509Certificate> coll = trustedPrincipals.get(principal);
        if (coll == null) {
            coll = new ArrayList<X509Certificate>();
            trustedPrincipals.put(principal, coll);
        }
        coll.add(cert);
        return trustedPrincipals;
    }

    private static Certificate[] canonicalize(Certificate[] chain, Date date, HashMap<Principal, Collection<X509Certificate>> trustedPrincipals) throws CertificateException {
        ArrayList<X509Certificate> c = new ArrayList<X509Certificate>(chain.length);
        boolean updated = false;
        if (chain.length == 0) {
            return chain;
        }
        for (int i = 0; i < chain.length; ++i) {
            X509Certificate issuer;
            X509Certificate currentCert = (X509Certificate)chain[i];
            X509Certificate trustedCert = CertValidator.getTrustedCertificate(currentCert, date, trustedPrincipals);
            if (trustedCert != null) {
                Trace.msgSecurityPrintln("trustdecider.check.canonicalize.updatecert");
                currentCert = trustedCert;
                updated = true;
            }
            c.add(currentCert);
            Principal subjectName = X509Util.getSubjectPrincipal(chain[i]);
            Principal issuerName = X509Util.getIssuerPrincipal(chain[i]);
            Principal nextSubjectName = null;
            if (i < chain.length - 1) {
                nextSubjectName = X509Util.getSubjectPrincipal(chain[i + 1]);
            }
            if (issuerName.equals(subjectName) || issuerName.equals(nextSubjectName) || (issuer = CertValidator.getTrustedIssuerCertificate((X509Certificate)chain[i], date, trustedPrincipals)) == null) continue;
            Trace.msgSecurityPrintln("trustdecider.check.canonicalize.missing");
            updated = true;
            c.add(issuer);
        }
        if (updated) {
            return c.toArray(new Certificate[c.size()]);
        }
        return chain;
    }

    private static X509Certificate getTrustedCertificate(X509Certificate cert, Date date, HashMap<Principal, Collection<X509Certificate>> trustedPrincipals) {
        Principal certSubjectName = X509Util.getSubjectPrincipal(cert);
        List list = (List)trustedPrincipals.get(certSubjectName);
        if (list == null) {
            return null;
        }
        Principal certIssuerName = X509Util.getIssuerPrincipal(cert);
        PublicKey certPublicKey = cert.getPublicKey();
        for (X509Certificate mycert : list) {
            if (mycert.equals(cert) || !X509Util.getIssuerPrincipal(mycert).equals(certIssuerName) || !mycert.getPublicKey().equals(certPublicKey)) continue;
            try {
                mycert.checkValidity(date);
            }
            catch (Exception e) {
                continue;
            }
            Trace.msgSecurityPrintln("trustdecider.check.gettrustedcert.find");
            return mycert;
        }
        return null;
    }

    private static X509Certificate getTrustedIssuerCertificate(X509Certificate cert, Date date, HashMap<Principal, Collection<X509Certificate>> trustedPrincipals) {
        Principal certIssuerName = X509Util.getIssuerPrincipal(cert);
        List list = (List)trustedPrincipals.get(certIssuerName);
        if (list == null) {
            return null;
        }
        for (X509Certificate mycert : list) {
            try {
                mycert.checkValidity(date);
            }
            catch (Exception e) {
                continue;
            }
            Trace.msgSecurityPrintln("trustdecider.check.gettrustedissuercert.find");
            return mycert;
        }
        return null;
    }

    public static boolean isSigner(Certificate check, Certificate signer) {
        try {
            check.verify(signer.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

