/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.SecureCookiePermission;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.URL;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

final class BasicPermissionCollection
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = 739301742472979399L;
    private transient Map<String, Permission> perms = new HashMap<String, Permission>(11);
    private boolean all_allowed = false;
    private Class<?> permClass;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class), new ObjectStreamField("all_allowed", Boolean.TYPE), new ObjectStreamField("permClass", Class.class)};

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof BasicPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        BasicPermission bp = (BasicPermission)permission;
        if (this.perms.size() == 0) {
            this.permClass = bp.getClass();
        } else if (bp.getClass() != this.permClass) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        this.perms.put(bp.getName(), permission);
        if (!this.all_allowed && bp.getName().equals("*")) {
            this.all_allowed = true;
        }
    }

    @Override
    public boolean implies(Permission permission) {
        int last;
        if (!(permission instanceof BasicPermission)) {
            return false;
        }
        BasicPermission bp = (BasicPermission)permission;
        if (bp.getClass() != this.permClass) {
            return false;
        }
        if (this.all_allowed) {
            return true;
        }
        Object path = bp.getName();
        Permission x = this.perms.get(path);
        if (x != null) {
            return x.implies(permission);
        }
        int offset = ((String)path).length() - 1;
        while ((last = ((String)path).lastIndexOf(".", offset)) != -1) {
            x = this.perms.get(path = ((String)path).substring(0, last + 1) + "*");
            if (x != null) {
                return x.implies(permission);
            }
            offset = last - 1;
        }
        if (!permission.getName().toLowerCase().startsWith(SecureCookiePermission.ORIGIN_PREFIX + "https:")) {
            return true;
        }
        for (Permission p : this.perms.values()) {
            if (!p.getName().startsWith(SecureCookiePermission.ORIGIN_PREFIX) || !permission.getName().startsWith(SecureCookiePermission.ORIGIN_PREFIX)) continue;
            try {
                URL origin = new URL(p.getName().substring(SecureCookiePermission.ORIGIN_PREFIX.length()));
                URL target = new URL(permission.getName().substring(SecureCookiePermission.ORIGIN_PREFIX.length()));
                if (!origin.getProtocol().toLowerCase().equals(target.getProtocol().toLowerCase()) || !origin.getHost().equals(target.getHost())) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    @Override
    public Enumeration<Permission> elements() {
        return Collections.enumeration(this.perms.values());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Hashtable<String, Permission> permissions = new Hashtable<String, Permission>(this.perms.size() * 2);
        permissions.putAll(this.perms);
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("all_allowed", this.all_allowed);
        pfields.put("permissions", permissions);
        pfields.put("permClass", this.permClass);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Enumeration e;
        ObjectInputStream.GetField gfields = in.readFields();
        Hashtable permissions = (Hashtable)gfields.get("permissions", null);
        this.perms = new HashMap<String, Permission>(permissions.size() * 2);
        this.perms.putAll(permissions);
        this.all_allowed = gfields.get("all_allowed", false);
        this.permClass = (Class)gfields.get("permClass", null);
        if (this.permClass == null && (e = permissions.elements()).hasMoreElements()) {
            Permission p = (Permission)e.nextElement();
            this.permClass = p.getClass();
        }
    }
}

