/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.resources;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ResourceManager {
    private static ResourceBundle rb;
    private static final Method transferToMethod;
    static Class<?> _keyEventClazz;

    private static byte[] loadResourceData(InputStream is) throws IOException {
        ByteArrayOutputStream baos;
        if (transferToMethod != null) {
            baos = new ByteArrayOutputStream();
            try {
                transferToMethod.invoke((Object)is, baos);
            }
            catch (Exception ex) {
                Trace.printException(ex);
            }
        } else {
            int count;
            byte[] readBuf = new byte[65536];
            baos = new ByteArrayOutputStream(readBuf.length);
            while ((count = is.read(readBuf, 0, readBuf.length)) != -1) {
                baos.write(readBuf, 0, count);
            }
            baos.flush();
        }
        return baos.toByteArray();
    }

    static void reset() {
        rb = ResourceBundle.getBundle("com.sun.deploy.resources.Deployment");
    }

    public static ResourceBundle getResourceBundle() {
        return rb;
    }

    public static String getString(String key) {
        try {
            return ResourceManager.removeMnemonics(rb.getString(key));
        }
        catch (MissingResourceException mre) {
            ResourceManager.missing(key, mre);
            return key;
        }
    }

    public static String getString(String key, Object ... args) {
        try {
            return MessageFormat.format(ResourceManager.getString(key), args);
        }
        catch (MissingResourceException mre) {
            ResourceManager.missing(key, mre);
            return key;
        }
    }

    public static ImageIcon getIcon(String key) {
        String resourceName = ResourceManager.getString(key);
        if (resourceName != null) {
            return ResourceManager.getIconResource(resourceName);
        }
        return null;
    }

    public static InputStream getImageResourceStream(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        if (((String)resourceName).indexOf(47) == -1) {
            resourceName = "image/" + (String)resourceName;
        }
        return ResourceManager.class.getResourceAsStream((String)resourceName);
    }

    public static Image getImageResource(String resourceName) {
        return ResourceManager.getImageResource(ResourceManager.getImageResourceStream(resourceName));
    }

    public static Image getImageResource(InputStream is) {
        try {
            byte[] data = ResourceManager.loadResourceData(is);
            if (data != null) {
                return Toolkit.getDefaultToolkit().createImage(data);
            }
        }
        catch (Exception e) {
            Trace.printException(e);
        }
        return null;
    }

    public static ImageIcon getIconResource(String resourceName) {
        return new ImageIcon(ResourceManager.getImageResource(resourceName), resourceName);
    }

    public static ImageIcon[] getButtonIcons(String key) {
        ImageIcon[] icons = new ImageIcon[4];
        String name = ResourceManager.getString(key);
        icons[0] = ResourceManager.getIconResource(name);
        int i = name.lastIndexOf(".");
        String root = name;
        String extension = "";
        if (i > 0) {
            root = name.substring(0, i);
            extension = name.substring(i);
        }
        icons[1] = ResourceManager.getIconResource(root + "-p" + extension);
        icons[2] = ResourceManager.getIconResource(root + "-d" + extension);
        icons[3] = ResourceManager.getIconResource(root + "-o" + extension);
        return icons;
    }

    public static Font getUIFont() {
        return new JLabel().getFont();
    }

    public static int getMinFontSize() {
        int fontSize = 0;
        try {
            fontSize = (Integer)rb.getObject("ui.min.font.size");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return fontSize;
    }

    private static String removeMnemonics(String s) {
        int i = s.indexOf("&");
        int len = s.length();
        if (i < 0 || i == len - 1) {
            return s;
        }
        int j = s.indexOf("&", i + 1);
        if (j == i + 1) {
            if (j + 1 == len) {
                return s.substring(0, i);
            }
            return s.substring(0, i) + ResourceManager.removeMnemonics(s.substring(j + 1));
        }
        if (i == 0) {
            return ResourceManager.removeMnemonics(s.substring(1));
        }
        return s.substring(0, i) + ResourceManager.removeMnemonics(s.substring(i + 1));
    }

    private static String extractMnemonic(String s) {
        if (s != null) {
            try {
                int i = s.indexOf("&");
                int len = s.length();
                if (i < 0 || i == len - 1) {
                    return null;
                }
                int j = s.indexOf("&", i + 1);
                if (j == i + 1) {
                    if (j + 1 == len) {
                        return null;
                    }
                    return ResourceManager.extractMnemonic(s.substring(j + 1));
                }
                return s.substring(i + 1, i + 2);
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
        }
        return null;
    }

    public static int getMnemonic(String key) {
        String resource;
        try {
            resource = rb.getString(key);
        }
        catch (MissingResourceException mre) {
            ResourceManager.missing(key, mre);
            return 0;
        }
        String s = ResourceManager.extractMnemonic(resource);
        if (s == null || s.length() != 1) {
            return 0;
        }
        String vkString = "VK_" + s.toUpperCase();
        try {
            if (_keyEventClazz == null) {
                _keyEventClazz = Class.forName("java.awt.event.KeyEvent");
            }
            Field field = _keyEventClazz.getDeclaredField(vkString);
            int value = field.getInt(null);
            return value;
        }
        catch (ClassNotFoundException cnfe) {
            Trace.ignoredException(cnfe);
        }
        catch (NoSuchFieldException nsfe) {
            Trace.ignoredException(nsfe);
        }
        catch (SecurityException se) {
            Trace.ignoredException(se);
        }
        catch (Exception e) {
            Trace.ignoredException(e);
        }
        return 0;
    }

    private static void missing(String key, MissingResourceException mre) {
        if (!key.endsWith(".tooltip") && key.contains(".") && !key.contains(" ")) {
            Trace.println(mre.toString(), TraceLevel.UI);
        }
    }

    static {
        Method tm = null;
        try {
            tm = InputStream.class.getDeclaredMethod("transferTo", OutputStream.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        transferToMethod = tm;
        ResourceManager.reset();
        _keyEventClazz = null;
    }
}

