/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.BufferedInputStream;
import java.net.HttpURLConnection;
import java.net.URL;

final class BasicHttpResponse
implements HttpResponse {
    private URL _request;
    private int _status;
    private int _length;
    private long _lastModified;
    private long _expiration;
    private String _mimeType;
    private BufferedInputStream _bis;
    private HttpURLConnection _httpURLConnection;
    private String _contentEncoding;
    private MessageHeader _headers;

    BasicHttpResponse(URL request, int status, int length, long expiration, long lastModified, String mimeType, MessageHeader headers, BufferedInputStream bis, HttpURLConnection httpconn, String contentEncoding) {
        this._request = request;
        this._status = status;
        this._length = length;
        this._expiration = expiration;
        this._lastModified = lastModified;
        this._mimeType = mimeType;
        this._headers = headers;
        this._bis = bis;
        this._httpURLConnection = httpconn;
        this._contentEncoding = contentEncoding;
    }

    @Override
    public void disconnect() {
        if (this._httpURLConnection != null) {
            this._httpURLConnection.disconnect();
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.println(ResourceManager.getString("basicHttpResponse.disconnect", this._request == null ? "" : this._request.toString()), TraceLevel.NETWORK);
            }
        }
    }

    @Override
    public MessageHeader getHeaders() {
        return this._headers;
    }

    @Override
    public URL getRequest() {
        return this._request;
    }

    @Override
    public int getStatusCode() {
        return this._status;
    }

    @Override
    public int getContentLength() {
        return this._length;
    }

    @Override
    public long getLastModified() {
        return this._lastModified;
    }

    @Override
    public long getExpiration() {
        return this._expiration;
    }

    @Override
    public String getContentType() {
        return this._mimeType;
    }

    @Override
    public String getContentEncoding() {
        return this._contentEncoding;
    }

    @Override
    public String getResponseHeader(String key) {
        return this._headers.findValue(key);
    }

    @Override
    public BufferedInputStream getInputStream() {
        return this._bis;
    }

    public URL getFinalURL() {
        if (this._httpURLConnection != null) {
            return this._httpURLConnection.getURL();
        }
        return null;
    }
}

