/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.BasicHttpResponse;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;

public final class BasicHttpRequest
implements HttpRequest {
    private static final String USER_AGENT_JAVA_VERSION = "UA-Java-Version";
    private static final String USER_AGENT = "User-Agent";

    @Override
    public HttpResponse doGetRequestEX(URL url, long lastModified) throws IOException {
        return this.doRequest(url, false, null, null, true, lastModified);
    }

    @Override
    public HttpResponse doGetRequestEX(URL url, String[] headerKeys, String[] headerValues, long lastModified) throws IOException {
        return this.doRequest(url, false, headerKeys, headerValues, true, lastModified);
    }

    @Override
    public HttpResponse doGetRequest(URL url) throws IOException {
        return this.doRequest(url, false, null, null, true);
    }

    @Override
    public HttpResponse doGetRequest(URL url, boolean httpCompression) throws IOException {
        return this.doRequest(url, false, null, null, httpCompression);
    }

    @Override
    public HttpResponse doHeadRequest(URL url) throws IOException {
        return this.doRequest(url, !Environment.isJavaPlugin(), null, null, true);
    }

    @Override
    public HttpResponse doHeadRequest(URL url, boolean httpCompression) throws IOException {
        return this.doRequest(url, true, null, null, httpCompression);
    }

    @Override
    public HttpResponse doGetRequest(URL url, String[] headerKeys, String[] headerValues) throws IOException {
        return this.doRequest(url, false, headerKeys, headerValues, true);
    }

    @Override
    public HttpResponse doGetRequest(URL url, String[] headerKeys, String[] headerValues, boolean httpCompression) throws IOException {
        return this.doRequest(url, false, headerKeys, headerValues, httpCompression);
    }

    @Override
    public HttpResponse doHeadRequest(URL url, String[] headerKeys, String[] headerValues) throws IOException {
        return this.doRequest(url, true, headerKeys, headerValues, true);
    }

    @Override
    public HttpResponse doHeadRequest(URL url, String[] headerKeys, String[] headerValues, boolean httpCompression) throws IOException {
        return this.doRequest(url, true, headerKeys, headerValues, httpCompression);
    }

    private HttpResponse doRequest(URL url, boolean isHead, String[] headerKeys, String[] headerValues, boolean httpCompression) throws IOException {
        return this.doRequest(url, isHead, headerKeys, headerValues, httpCompression, 0L);
    }

    private HttpResponse doRequest(URL url, boolean isHead, String[] headerKeys, String[] headerValues, boolean httpCompression, long cacheLastModified) throws IOException {
        MessageHeader messageHeader;
        String encoding;
        String mimeType;
        long fileTimeStamp = 0L;
        String fileMimeType = null;
        if ("file".equals(url.getProtocol()) && url.getFile() != null) {
            try {
                String path = URLUtil.getPathFromURL(url);
                File f = new File(path);
                fileTimeStamp = f.lastModified();
                if (path.endsWith(".jnlp")) {
                    fileMimeType = "application/x-java-jnlp-file";
                } else if (path.endsWith(".jardiff")) {
                    fileMimeType = "application/x-java-archive-diff";
                }
            }
            catch (Exception path) {
                // empty catch block
            }
        }
        URLConnection connection = null;
        connection = url.getProtocol().equals("file") ? this.createUrlConnection(HttpUtils.removeQueryStringFromURL(url), isHead, headerKeys, headerValues, httpCompression) : this.createUrlConnection(url, isHead, headerKeys, headerValues, httpCompression);
        URLUtil.setHostHeader(connection);
        connection.setUseCaches(false);
        connection.setIfModifiedSince(cacheLastModified);
        boolean connected = false;
        if (Environment.getImportModeCodebase() == null && Environment.getImportModeCodebaseOverride() == null && connection instanceof HttpURLConnection) {
            connection = HttpUtils.followRedirects(connection);
            connected = true;
        }
        if (!connected) {
            connection.connect();
        }
        int status = 200;
        HttpURLConnection httpconn = null;
        if (connection instanceof HttpURLConnection) {
            httpconn = (HttpURLConnection)connection;
            status = httpconn.getResponseCode();
        }
        if (Trace.isEnabled(TraceLevel.NETWORK)) {
            Trace.println(ResourceManager.getString("basicHttpRequest.responseCode", url == null ? "" : url.toString(), String.valueOf(status)), TraceLevel.NETWORK);
        }
        int length = connection.getContentLength();
        long lastModified = fileTimeStamp != 0L ? fileTimeStamp : connection.getLastModified();
        long expiration = connection.getExpiration();
        String string = mimeType = fileMimeType != null ? fileMimeType : connection.getContentType();
        if (mimeType != null && mimeType.indexOf(59) != -1) {
            mimeType = mimeType.substring(0, mimeType.indexOf(59)).trim();
        }
        if ((encoding = (messageHeader = BasicHttpRequest.initializeHeaderFields(connection)).findValue("content-encoding")) != null) {
            encoding = encoding.toLowerCase();
        }
        if (Trace.isEnabled(TraceLevel.NETWORK)) {
            Trace.println(ResourceManager.getString("basicHttpRequest.encoding", url == null ? "" : url.toString(), encoding), TraceLevel.NETWORK);
        }
        BufferedInputStream bis = null;
        bis = isHead ? null : new BufferedInputStream(connection.getInputStream());
        return new BasicHttpResponse(url, status, length, expiration, lastModified, mimeType, messageHeader, bis, httpconn, encoding);
    }

    public static MessageHeader initializeHeaderFields(URLConnection uc) throws IOException {
        MessageHeader headerFields = new MessageHeader();
        for (Map.Entry<String, List<String>> entry : uc.getHeaderFields().entrySet()) {
            String key;
            String value;
            List<String> values = entry.getValue();
            if (values == null || values.size() <= 0 || (value = values.get(0)) == null) continue;
            if (value.equalsIgnoreCase("application/x-java-archive-diff")) {
                value = "application/java-archive";
            }
            if ((key = entry.getKey()) != null) {
                key = key.toLowerCase();
            }
            headerFields.add(key, value);
        }
        return headerFields;
    }

    private URLConnection createUrlConnection(URL u, boolean isHead, String[] keys, String[] values, boolean httpCompression) throws MalformedURLException, IOException {
        URLConnection conn = u.openConnection();
        if (httpCompression) {
            Object encoding = "gzip";
            String urlNoQuery = HttpUtils.removeQueryStringFromURL(u).toString().toLowerCase();
            if (urlNoQuery.endsWith(".jar") || urlNoQuery.endsWith(".jarjar")) {
                this.addToRequestProperty(conn, "content-type", "application/x-java-archive");
                encoding = "pack200-gzip," + (String)encoding;
            }
            this.addToRequestProperty(conn, "accept-encoding", (String)encoding);
        }
        if (SystemUtils.priviledgedGetSystemProperty("http.agent") == null) {
            conn.setRequestProperty(USER_AGENT, Environment.getUserAgent());
            conn.setRequestProperty(USER_AGENT_JAVA_VERSION, Config.getJavaVersion());
        }
        if (keys != null && values != null) {
            for (int i = 0; i < keys.length; ++i) {
                conn.setRequestProperty(keys[i], values[i]);
            }
        }
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).setRequestMethod(isHead ? "HEAD" : "GET");
        }
        return conn;
    }

    private void addToRequestProperty(URLConnection conn, String key, String value) {
        Object curvalue = conn.getRequestProperty(key);
        curvalue = curvalue == null || ((String)curvalue).trim().length() == 0 ? value : (String)curvalue + "," + value;
        conn.setRequestProperty(key, (String)curvalue);
    }
}

