/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.deploy.update;

import com.oracle.deploy.update.UpdateCheckFactory;
import com.oracle.deploy.update.UpdateCheckListener;
import com.oracle.deploy.update.UpdateInfo;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.util.Calendar;

public abstract class UpdateCheck {
    private static UpdateCheck sInstance = UpdateCheckFactory.getInstance();
    private UpdateCheckListener mUpdateListener;
    private UpdateInfo mUpdateInfo;
    private int mCurrentState;

    public static UpdateCheck getInstance() {
        return sInstance;
    }

    public synchronized boolean startUpdateCheck(UpdateCheckListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (this.mUpdateListener != null) {
            return false;
        }
        this.mUpdateInfo = null;
        this.mUpdateListener = listener;
        if (!this.checkForUpdate()) {
            this.mUpdateListener = null;
            return false;
        }
        return true;
    }

    public int getCurrentState() {
        return this.mCurrentState;
    }

    public UpdateInfo getUpdateInfo() {
        return this.mUpdateInfo;
    }

    private static void doInvokeLater(Runnable r) {
        AppContext ac;
        if (r != null && (ac = ToolkitStore.get().getAppContext()) != null) {
            ac.invokeLater(r);
        }
    }

    private void updateStateChange(final int newState) {
        UpdateCheck.doInvokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateCheck.this.mUpdateListener.updateCheckStateChanged(newState);
                UpdateCheck.this.mCurrentState = newState;
                if (newState == 6) {
                    UpdateCheck.this.mUpdateListener = null;
                    UpdateCheck.this.mCurrentState = 1;
                }
            }
        });
    }

    private void updateAvailable(final String version, final String size, final String type) {
        UpdateCheck.doInvokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateCheck.this.mUpdateInfo = new UpdateInfo(version, size, type);
            }
        });
    }

    public abstract Calendar getLastUpdateCheck();

    abstract boolean checkForUpdate();

    public final class UpdateCheckState {
        public static final int IDLE = 1;
        public static final int CONNECTING = 2;
        public static final int CONNECTED = 3;
        public static final int FAILED_TO_CONNECT = 4;
        public static final int UPDATE_INFO_READY = 5;
        public static final int DONE = 6;
    }
}

