/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.JNLPClassLoaderUtil;
import javax.jnlp.ServiceManagerStub;
import javax.jnlp.UnavailableServiceException;

public final class JnlpLookupStub
implements ServiceManagerStub {
    public Object lookup(String name) throws UnavailableServiceException {
        Object service = this.findService(name);
        if (service == null) {
            throw new UnavailableServiceException(name);
        }
        return service;
    }

    private Object findService(String name) {
        if (name != null) {
            JNLPClassLoaderIf loader = JNLPClassLoaderUtil.getInstance();
            if (loader == null) {
                return null;
            }
            if (name.equals("javax.jnlp.BasicService")) {
                return loader.getBasicService();
            }
            if (name.equals("javax.jnlp.FileOpenService")) {
                return loader.getFileOpenService();
            }
            if (name.equals("javax.jnlp.FileSaveService")) {
                return loader.getFileSaveService();
            }
            if (name.equals("javax.jnlp.ExtensionInstallerService")) {
                return loader.getExtensionInstallerService();
            }
            if (name.equals("javax.jnlp.DownloadService")) {
                return loader.getDownloadService();
            }
            if (name.equals("javax.jnlp.ClipboardService")) {
                return loader.getClipboardService();
            }
            if (name.equals("javax.jnlp.PrintService")) {
                return loader.getPrintService();
            }
            if (name.equals("javax.jnlp.PersistenceService")) {
                return loader.getPersistenceService();
            }
            if (name.equals("javax.jnlp.ExtendedService")) {
                return loader.getExtendedService();
            }
            if (name.equals("javax.jnlp.SingleInstanceService")) {
                return loader.getSingleInstanceService();
            }
            if (name.equals("javax.jnlp.IntegrationService")) {
                return loader.getIntegrationService();
            }
            if (name.equals("javax.jnlp.DownloadService2")) {
                return loader.getDownloadService2();
            }
        }
        return null;
    }

    public String[] getServiceNames() {
        if (ExtensionInstallerServiceImpl.getInstance() != null) {
            return new String[]{"javax.jnlp.BasicService", "javax.jnlp.FileOpenService", "javax.jnlp.FileSaveService", "javax.jnlp.ExtensionInstallerService", "javax.jnlp.DownloadService", "javax.jnlp.ClipboardService", "javax.jnlp.PersistenceService", "javax.jnlp.PrintService", "javax.jnlp.ExtendedService", "javax.jnlp.SingleInstanceService", "com.sun.jnlp.IntegrationService"};
        }
        return new String[]{"javax.jnlp.BasicService", "javax.jnlp.FileOpenService", "javax.jnlp.FileSaveService", "javax.jnlp.DownloadService", "javax.jnlp.ClipboardService", "javax.jnlp.PersistenceService", "javax.jnlp.PrintService", "javax.jnlp.ExtendedService", "javax.jnlp.SingleInstanceService"};
    }
}

