/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import com.sun.jnlp.JNLPClassLoaderIf;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.PropertyPermission;
import javax.jnlp.IntegrationService;

public final class IntegrationServiceImpl
implements IntegrationService {
    private JNLPClassLoaderIf jnlpClassLoader;
    private static final AccessControlContext ACC_INT_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            ((PermissionCollection)perms).add(new FilePermission("<<ALL FILES>>", "read,write,delete,execute"));
            ((PermissionCollection)perms).add(new PropertyPermission("os.name", "read"));
            ((PermissionCollection)perms).add(new PropertyPermission("user.home", "read"));
            ((PermissionCollection)perms).add(new SocketPermission("*", "connect,resolve"));
            if (Config.isJavaVersionAtLeast18()) {
                ((PermissionCollection)perms).add(new URLPermission("http:*", "*:*"));
                ((PermissionCollection)perms).add(new URLPermission("https:*", "*:*"));
            }
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });
    private static final String TSPECIALS = "()<>@,;:\\\"/[]?=";

    public IntegrationServiceImpl(JNLPClassLoaderIf loader) {
        this.jnlpClassLoader = loader;
    }

    public boolean requestShortcut(boolean desktop, boolean menu, String submenu) {
        final boolean anyShortcuts = desktop || menu;
        final LaunchDesc ld = this.jnlpClassLoader.getLaunchDesc();
        InformationDesc id = ld.getInformation();
        id.setShortcut(new ShortcutDesc(true, false, desktop, menu, submenu));
        final LocalInstallHandler lih = LocalInstallHandler.getInstance();
        final LocalApplicationProperties lap = this.getLocalApplicationProperties(ld);
        Boolean success = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean success = false;
                if (lih.isLocalInstallSupported()) {
                    success = lih.performIntegration(null, ld, lap, false, true, false);
                    try {
                        lap.store();
                    }
                    catch (Exception exception) {}
                } else {
                    success = !anyShortcuts;
                }
                return success;
            }
        }, ACC_INT_INSTANCE);
        return success;
    }

    public boolean hasDesktopShortcut() {
        return this.hasShortcut(0);
    }

    public boolean hasMenuShortcut() {
        return this.hasShortcut(1);
    }

    private boolean hasShortcut(int index) {
        LaunchDesc ld = this.jnlpClassLoader.getLaunchDesc();
        final LocalInstallHandler lih = LocalInstallHandler.getInstance();
        final LocalApplicationProperties lap = this.getLocalApplicationProperties(ld);
        boolean[] which = AccessController.doPrivileged(new PrivilegedAction<boolean[]>(){

            @Override
            public boolean[] run() {
                return lih.whichShortcutsExist(lap);
            }
        }, ACC_INT_INSTANCE);
        return which[index];
    }

    private LocalApplicationProperties getLocalApplicationProperties(final LaunchDesc ld) {
        LocalApplicationProperties lap = AccessController.doPrivileged(new PrivilegedAction<LocalApplicationProperties>(){

            @Override
            public LocalApplicationProperties run() {
                URL home = ld.getCanonicalHome();
                return ResourceProvider.get().getLocalApplicationProperties(home, null, true);
            }
        }, ACC_INT_INSTANCE);
        return lap;
    }

    public boolean removeShortcuts() {
        final LaunchDesc ld = this.jnlpClassLoader.getLaunchDesc();
        final LocalInstallHandler lih = LocalInstallHandler.getInstance();
        final LocalApplicationProperties lap = this.getLocalApplicationProperties(ld);
        Boolean success = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean success = lih.uninstallShortcuts(ld, lap);
                try {
                    lap.store();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return success;
            }
        }, ACC_INT_INSTANCE);
        return success;
    }

    public boolean requestAssociation(String mimetype, String[] extensions) {
        this.validateAssociationArguments(mimetype, extensions);
        final LaunchDesc ld = this.jnlpClassLoader.getLaunchDesc();
        InformationDesc id = ld.getInformation();
        AssociationDesc association = this.createAssociationDesc(mimetype, extensions);
        id.setAssociation(association);
        final LocalApplicationProperties lap = this.getLocalApplicationProperties(ld);
        final LocalInstallHandler lih = LocalInstallHandler.getInstance();
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean success = false;
                if (lih.isAssociationSupported()) {
                    success = lih.performIntegration(null, ld, lap, false, false, true);
                }
                return success;
            }
        }, ACC_INT_INSTANCE);
    }

    public boolean hasAssociation(String mimetype, String[] extensions) {
        this.validateAssociationArguments(mimetype, extensions);
        final LaunchDesc ld = this.jnlpClassLoader.getLaunchDesc();
        final LocalApplicationProperties lap = this.getLocalApplicationProperties(ld);
        final Association association = this.createAssociation(mimetype, extensions);
        final LocalInstallHandler lih = LocalInstallHandler.getInstance();
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return lih.hasAssociation(ld, lap, association);
            }
        }, ACC_INT_INSTANCE);
    }

    public boolean removeAssociation(String mimetype, String[] extensions) {
        this.validateAssociationArguments(mimetype, extensions);
        final LaunchDesc ld = this.jnlpClassLoader.getLaunchDesc();
        final LocalApplicationProperties lap = this.getLocalApplicationProperties(ld);
        final Association association = this.createAssociation(mimetype, extensions);
        final LocalInstallHandler lih = LocalInstallHandler.getInstance();
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Boolean success = Boolean.TRUE;
                if (lih.isAssociationSupported()) {
                    try {
                        lih.unregisterAssociationInternal(ld, lap, association);
                    }
                    catch (AssociationNotRegisteredException ex) {
                        success = Boolean.FALSE;
                    }
                    catch (RegisterFailedException ex) {
                        success = Boolean.FALSE;
                    }
                }
                return success;
            }
        }, ACC_INT_INSTANCE);
    }

    private void validateAssociationArguments(String mimeType, String[] extensions) {
        this.validateMimeType(mimeType);
        this.validateExtensions(extensions);
    }

    private void validateExtensions(String[] extensions) {
        if (extensions == null || extensions.length == 0) {
            throw new IllegalArgumentException("Null or empty extensions array not allowed");
        }
        for (String ext : extensions) {
            if (ext == null) {
                throw new IllegalArgumentException("Null extension not allowed");
            }
            if (!ext.equals("")) continue;
            throw new IllegalArgumentException("Empty extension not allowed");
        }
    }

    private void validateMimeType(String mimeType) {
        String subType;
        String primaryType;
        if (mimeType == null) {
            throw new IllegalArgumentException("Null mimetype not allowed");
        }
        int slashIndex = mimeType.indexOf(47);
        int semIndex = mimeType.indexOf(59);
        if (slashIndex < 0 && semIndex < 0) {
            throw new IllegalArgumentException("Unable to find a sub type.");
        }
        if (slashIndex < 0 && semIndex >= 0) {
            throw new IllegalArgumentException("Unable to find a sub type.");
        }
        if (slashIndex >= 0 && semIndex < 0) {
            primaryType = mimeType.substring(0, slashIndex).trim().toLowerCase();
            subType = mimeType.substring(slashIndex + 1).trim().toLowerCase();
        } else if (slashIndex < semIndex) {
            primaryType = mimeType.substring(0, slashIndex).trim().toLowerCase();
            subType = mimeType.substring(slashIndex + 1, semIndex).trim().toLowerCase();
        } else {
            throw new IllegalArgumentException("Unable to find a sub type.");
        }
        if (!this.isValidToken(primaryType)) {
            throw new IllegalArgumentException("Primary type is invalid.");
        }
        if (!this.isValidToken(subType)) {
            throw new IllegalArgumentException("Sub type is invalid.");
        }
    }

    private boolean isValidToken(String s) {
        int len = s.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (IntegrationServiceImpl.isTokenChar(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    private Association createAssociation(String mimetype, String[] extensions) {
        Association association = new Association();
        association.setMimeType(mimetype);
        for (String extension : extensions) {
            association.addFileExtension(extension);
        }
        LaunchDesc ld = this.jnlpClassLoader.getLaunchDesc();
        association.setName(this.getAssociationDescription(ld));
        return association;
    }

    private AssociationDesc createAssociationDesc(String mimetype, String[] exts) {
        StringBuilder extString = new StringBuilder();
        for (int i = 0; i < exts.length; ++i) {
            extString.append(exts[i]);
            if (i >= exts.length - 1) continue;
            extString.append(' ');
        }
        LaunchDesc ld = this.jnlpClassLoader.getLaunchDesc();
        AssociationDesc assoc = new AssociationDesc(extString.toString(), mimetype, this.getAssociationDescription(ld), null);
        return assoc;
    }

    private String getAssociationDescription(LaunchDesc ld) {
        return ld.getInformation().getTitle();
    }
}

