/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xml;

import com.sun.deploy.xml.XMLNode;

public class XMLAttribute {
    private String _name;
    private String _value;
    private XMLAttribute _next;

    public XMLAttribute(String name, String value) {
        this(name, value, null);
    }

    public XMLAttribute(String name, String value, XMLAttribute next) {
        this._name = XMLNode.stripNameSpace(name);
        this._value = value;
        this._next = next;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public XMLAttribute getNext() {
        return this._next;
    }

    public void setNext(XMLAttribute next) {
        this._next = next;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + (this._name != null ? this._name.hashCode() : 0);
        hash = 73 * hash + (this._value != null ? this._value.hashCode() : 0);
        hash = 73 * hash + (this._next != null ? this._next.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XMLAttribute)) {
            return false;
        }
        XMLAttribute other = (XMLAttribute)o;
        return XMLAttribute.match(this._name, other._name) && XMLAttribute.match(this._value, other._value) && XMLAttribute.match(this._next, other._next);
    }

    public boolean equalsTemplate(XMLAttribute other) {
        if (other == null) {
            return false;
        }
        return XMLAttribute.match(this._name, other._name) && XMLAttribute.matchTemplateValue(this._value, other._value) && XMLAttribute.matchTemplateAttribute(this._next, other._next);
    }

    private static boolean match(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private static boolean matchTemplateValue(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2) || "*".equals(s2);
    }

    private static boolean matchTemplateAttribute(XMLAttribute a1, XMLAttribute a2) {
        if (a1 == null) {
            return a2 == null;
        }
        return a1.equalsTemplate(a2);
    }

    public String toString() {
        if (this._next != null) {
            if (this._value != null && this._value.contains("\"")) {
                return this._name + "='" + this._value + "' " + this._next.toString();
            }
            return this._name + "=\"" + this._value + "\" " + this._next.toString();
        }
        if (this._value != null && this._value.contains("\"")) {
            return this._name + "='" + this._value + "'";
        }
        return this._name + "=\"" + this._value + "\"";
    }
}

