/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class SessionState {
    private static File sessionDataFolder;
    private static List<Client> sessionObjects;

    public static synchronized void register(Client c) {
        sessionObjects.add(c);
        if (sessionDataFolder != null) {
            c.importState(sessionDataFolder);
        }
    }

    public static synchronized File save() {
        File exportFolder = null;
        try {
            exportFolder = File.createTempFile("session", "");
            exportFolder.delete();
            exportFolder.mkdirs();
            Trace.println("Saving session state to " + exportFolder.getAbsolutePath(), TraceLevel.BASIC);
            for (Client c : sessionObjects) {
                c.exportState(exportFolder);
            }
        }
        catch (IOException ioe) {
            Trace.ignored(ioe);
        }
        return exportFolder;
    }

    public static synchronized void init(String folder) {
        if (folder != null) {
            sessionDataFolder = new File(folder);
            for (Client c : sessionObjects) {
                c.importState(sessionDataFolder);
            }
            Trace.println("Session state location: " + sessionDataFolder.getAbsolutePath(), TraceLevel.BASIC);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (sessionDataFolder != null) {
                        SystemUtils.deleteRecursive(sessionDataFolder);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    static {
        sessionObjects = new LinkedList<Client>();
    }

    public static interface Client {
        public void importState(File var1);

        public void exportState(File var1);
    }
}

