/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.util.HashMap;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class DeployUIManager {
    private static final String _v = System.getProperty("java.version");
    private static final boolean _isOldJava = _v.startsWith("1.2") || _v.startsWith("1.3") || _v.startsWith("1.4");

    public static void setLookAndFeel() {
        try {
            if (_isOldJava) {
                MetalLookAndFeel.setCurrentTheme(new DeployMetalTheme());
            }
            HashMap<String, Object> lafData = new HashMap<String, Object>(2);
            if (Config.useSystemLookAndFeel()) {
                lafData.put("defaultlaf", DeployUIManager.getSystemLookAndFeelClassName());
                lafData.put("Slider.paintValue", Boolean.FALSE);
            } else {
                lafData.put("defaultlaf", "javax.swing.plaf.metal.MetalLookAndFeel");
            }
            ToolkitStore.get().getAppContext().put("swing.lafdata", lafData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getSystemLookAndFeelClassName() {
        String systemLAF = System.getProperty("swing.systemlaf");
        if (systemLAF != null) {
            return systemLAF;
        }
        String osName = System.getProperty("os.name");
        if (osName != null) {
            if (osName.indexOf("Windows") != -1) {
                return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            }
            if (osName.indexOf("OS X") != -1) {
                return "com.apple.laf.AquaLookAndFeel";
            }
            String desktop = System.getProperty("sun.desktop");
            if ("gnome".equals(desktop)) {
                return "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            }
            if (osName.indexOf("Solaris") != -1 || osName.indexOf("SunOS") != -1) {
                return "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            }
        }
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    static class DeployMetalTheme
    extends DefaultMetalTheme {
        private FontUIResource controlTextFont = null;
        private FontUIResource menuTextFont = null;
        private FontUIResource windowTitleFont = null;

        DeployMetalTheme() {
            FontUIResource resource = super.getControlTextFont();
            this.controlTextFont = new FontUIResource(resource.getName(), resource.getStyle() & 0xFFFFFFFE, resource.getSize());
            resource = super.getMenuTextFont();
            this.menuTextFont = new FontUIResource(resource.getName(), resource.getStyle() & 0xFFFFFFFE, resource.getSize());
            resource = super.getWindowTitleFont();
            this.windowTitleFont = new FontUIResource(resource.getName(), resource.getStyle() & 0xFFFFFFFE, resource.getSize());
        }

        @Override
        public FontUIResource getControlTextFont() {
            return this.controlTextFont;
        }

        @Override
        public FontUIResource getMenuTextFont() {
            return this.menuTextFont;
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.windowTitleFont;
        }
    }
}

