/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.ui;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.trace.TraceListener;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import com.sun.deploy.util.SafeThreadFactory;

public final class ConsoleTraceListener
implements TraceListener {
    private static final long MIN_CONSOLE_OUTPUT_INTERVAL = 100L;
    private ConsoleWindow console = null;
    private final BoundedStringBuffer buffer;
    private Thread writerThread;
    private ConsoleWriter writer;
    private boolean running;

    public ConsoleTraceListener() {
        this(1048575);
    }

    public ConsoleTraceListener(int bound) {
        this.buffer = new BoundedStringBuffer(bound);
    }

    @Override
    public void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void setConsole(ConsoleWindow console) {
        if (this.console == console) {
            return;
        }
        if (console == null) {
            Trace.println("Calling ConsoleTraceListener.setConsole() with null console", TraceLevel.UI);
            this.cleanupWriter();
            return;
        }
        if (this.console != null || this.writer != null) {
            Trace.println("Calling ConsoleTraceListener.setConsole() when console already set", TraceLevel.UI);
            this.cleanupWriter();
        }
        this.buffer.setBound(0);
        this.console = console;
        this.running = true;
        this.writerThread = SafeThreadFactory.createThread(new ConsoleWriter(), "ConsoleTraceListener");
        this.writerThread.setDaemon(true);
        this.writerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(String msg) {
        if (msg == null || msg.length() == 0) {
            return;
        }
        BoundedStringBuffer boundedStringBuffer = this.buffer;
        synchronized (boundedStringBuffer) {
            boolean shouldNotify = this.buffer.length() == 0;
            this.buffer.append(msg);
            if (shouldNotify && this.console != null) {
                this.buffer.notifyAll();
            }
        }
    }

    private void cleanupWriter() {
        if (this.writerThread != null && this.writerThread.isAlive()) {
            this.running = false;
            this.writerThread.interrupt();
            this.writerThread = null;
        }
    }

    public String getTraceMessages() {
        return this.buffer.toString();
    }

    void stopWriter() {
        if (this.writerThread != null) {
            this.running = false;
            this.writerThread.interrupt();
        }
    }

    static class BoundedStringBuffer {
        private int bound;
        private final StringBuffer sb = new StringBuffer();

        BoundedStringBuffer(int bound) {
            this.bound = bound;
        }

        public String toString() {
            return this.sb.toString();
        }

        public boolean equals(Object obj) {
            return this.sb.equals(obj);
        }

        public int hashCode() {
            return this.sb.hashCode();
        }

        int length() {
            return this.sb.length();
        }

        void append(String msg) {
            if (this.bound == 0) {
                this.sb.append(msg);
                return;
            }
            int trimLen = 0;
            int total = this.sb.length() + msg.length();
            if (total > this.bound) {
                trimLen = total - this.bound;
            }
            if (trimLen > this.sb.length()) {
                this.clear();
            } else {
                this.sb.delete(0, trimLen);
            }
            this.sb.append(msg);
        }

        void clear() {
            this.sb.delete(0, this.sb.length());
        }

        void setBound(int v) {
            this.bound = v;
        }
    }

    class ConsoleWriter
    implements Runnable {
        ConsoleWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long t1 = System.currentTimeMillis();
            while (ConsoleTraceListener.this.running) {
                String append;
                long t2 = System.currentTimeMillis();
                BoundedStringBuffer boundedStringBuffer = ConsoleTraceListener.this.buffer;
                synchronized (boundedStringBuffer) {
                    if (t2 - t1 < 100L || ConsoleTraceListener.this.buffer.length() <= 0) {
                        try {
                            if (ConsoleTraceListener.this.buffer.length() == 0) {
                                ConsoleTraceListener.this.buffer.wait();
                            } else {
                                ConsoleTraceListener.this.buffer.wait(100L - (t2 - t1));
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                        }
                        continue;
                    }
                    append = ConsoleTraceListener.this.buffer.toString();
                    ConsoleTraceListener.this.buffer.clear();
                    t1 = t2;
                }
                ConsoleTraceListener.this.console.append(append);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            String append;
            BoundedStringBuffer boundedStringBuffer = ConsoleTraceListener.this.buffer;
            synchronized (boundedStringBuffer) {
                if (ConsoleTraceListener.this.buffer.length() <= 0) {
                    return;
                }
                append = ConsoleTraceListener.this.buffer.toString();
                ConsoleTraceListener.this.buffer.clear();
            }
            ConsoleTraceListener.this.console.append(append);
        }
    }
}

