/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SessionState;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

public final class SessionCertStore
implements CertStore,
SessionState.Client {
    private KeyStore sessionKS = null;
    private String name;
    private File sessionDataFolder;

    private SessionCertStore() {
    }

    public SessionCertStore(String name) {
        this.name = name;
        SessionState.register(this);
    }

    @Override
    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    @Override
    public synchronized void load(boolean integrityCheck) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.loading");
        if (this.sessionKS == null) {
            try {
                this.sessionKS = KeyStore.getInstance("JKS");
                this.sessionKS.load(null, new char[0]);
                if (this.sessionDataFolder != null) {
                    this.importState(this.sessionDataFolder);
                    this.sessionDataFolder = null;
                }
            }
            catch (IOException ioe) {
                Trace.msgSecurityPrintln(ioe.getMessage());
            }
            catch (KeyStoreException kse) {
                Trace.msgSecurityPrintln(kse.getMessage());
            }
            catch (NoSuchAlgorithmException nsae) {
                Trace.msgSecurityPrintln(nsae.getMessage());
            }
            catch (CertificateException ce) {
                Trace.msgSecurityPrintln(ce.getMessage());
            }
        }
        Trace.msgSecurityPrintln("sessioncertstore.cert.loaded");
    }

    @Override
    public synchronized void importState(final File folder) {
        if (this.sessionKS == null) {
            this.sessionDataFolder = folder;
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file = new File(folder, SessionCertStore.this.name);
                    if (file != null && file.exists()) {
                        FileInputStream fis = new FileInputStream(file);
                        BufferedInputStream bis = new BufferedInputStream(fis);
                        SessionCertStore.this.sessionKS.load(bis, new char[0]);
                        bis.close();
                        fis.close();
                        file.delete();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Trace.ignored(e.getException());
        }
    }

    @Override
    public void exportState(File folder) {
        if (this.sessionKS == null) {
            return;
        }
        final File outfile = new File(folder, this.name);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    outfile.getParentFile().mkdirs();
                    FileOutputStream fos = new FileOutputStream(outfile);
                    BufferedOutputStream bos = new BufferedOutputStream(fos);
                    char[] keyPassphrase = new char[]{};
                    SessionCertStore.this.sessionKS.store(bos, keyPassphrase);
                    bos.close();
                    fos.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Trace.ignored(e.getException());
        }
    }

    @Override
    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.saving");
        Trace.msgSecurityPrintln("sessioncertstore.cert.saved");
    }

    @Override
    public boolean add(Certificate cert) throws KeyStoreException {
        return this.add(cert, null, false);
    }

    @Override
    public boolean add(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        return CertUtils.add(this.sessionKS, "sessioncertstore", cert, loc, tsFlag);
    }

    @Override
    public boolean remove(Certificate cert) throws IOException, KeyStoreException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.removing");
        String alias = this.sessionKS.getCertificateAlias(cert);
        if (alias != null) {
            this.sessionKS.deleteEntry(alias);
        }
        Trace.msgSecurityPrintln("sessioncertstore.cert.removed");
        return true;
    }

    @Override
    public boolean contains(Certificate cert) throws KeyStoreException {
        return this.contains(cert, null, false);
    }

    @Override
    public boolean contains(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        return CertUtils.contains(this.sessionKS, cert, loc, tsFlag);
    }

    @Override
    public boolean verify(Certificate cert) throws KeyStoreException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.canverify");
        return false;
    }

    @Override
    public Collection<X509Certificate> getCertificates() throws KeyStoreException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.getcertificates");
        ArrayList<X509Certificate> certCollection = new ArrayList<X509Certificate>();
        Enumeration<String> keyAliases = this.sessionKS.aliases();
        while (keyAliases.hasMoreElements()) {
            String myAlias = keyAliases.nextElement();
            X509Certificate cert = (X509Certificate)this.sessionKS.getCertificate(myAlias);
            certCollection.add(cert);
        }
        return certCollection;
    }
}

