/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.security.JarSignature;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.BlackList;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.TrustedLibraries;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarAsBLOBVerifier
extends JarVerifier {
    private JarSignature js = null;

    public static JarVerifier create(URL location, String version, File jar, File nativePath) {
        JarAsBLOBVerifier jv = new JarAsBLOBVerifier(location, version, jar, nativePath);
        if (jv.detectedSignature()) {
            return jv;
        }
        return null;
    }

    JarAsBLOBVerifier(URL location, String version, File jar, File nativePath) {
        super(location, version, jar, nativePath);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new FileInputStream(this.jarFile));
            ZipEntry e = zis.getNextEntry();
            if (e != null && "META-INF/".equals(e.getName())) {
                e = zis.getNextEntry();
            }
            if (e != null && e.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                e = zis.getNextEntry();
            }
            if (e != null && "META-INF/SIGNATURE.BSF".equals(e.getName())) {
                byte[] bytes = JarAsBLOBVerifier.getBytes(zis);
                this.js = JarSignature.load(bytes);
            }
        }
        catch (Exception e) {
            if (Config.getDebug()) {
                Trace.ignored(e);
            }
            this.js = null;
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException ioe) {
                    Trace.ignored(ioe);
                }
            }
        }
    }

    private boolean detectedSignature() {
        return this.js != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(DownloadDelegate dd) throws IOException, JARSigningException {
        try (JarFile jar = JarUtil.createJarFile(this.jarFile, true);){
            int i;
            int total = jar.size();
            int count = 0;
            this.manifest = jar.getManifest();
            Enumeration<JarEntry> entries = jar.entries();
            if (dd != null) {
                dd.validating(this.jarLocation, 0, total);
            }
            if (BlackList.getInstance().checkJarFile(jar)) {
                throw new JARSigningException(this.jarLocation, this.jarVersion, 5);
            }
            if (TrustedLibraries.checkJarFile(jar)) {
                Attributes attrs = this.manifest.getMainAttributes();
                attrs.putValue("Trusted-Library", Boolean.TRUE.toString());
            }
            while (entries.hasMoreElements()) {
                ++count;
                String name = null;
                JarEntry entry = null;
                entry = entries.nextElement();
                name = entry.getName();
                if ("META-INF/SIGNATURE.BSF".equals(name) || JarUtil.isDirectory(entry)) continue;
                this.authenticateJarEntry(jar, entry);
            }
            if (!this.js.isValid()) {
                throw new JARSigningException(this.jarLocation, this.jarVersion, 2);
            }
            this.hasOnlySignedEntries = true;
            this.hasSingleCodeSource = true;
            this.hasMissingSignedEntries = false;
            CodeSigner[] knownSigners = this.js.getCodeSigners();
            CodeSource cs = new CodeSource(this.jarLocation, knownSigners);
            Certificate[] certs = cs.getCertificates();
            this.singleSignerIndicesCert = new int[certs.length];
            for (i = 0; i < certs.length; ++i) {
                this.signerCerts.add(certs[i]);
                this.singleSignerIndicesCert[i] = i;
            }
            this.codeSourceCertCache.put(this.singleSignerIndicesCert, cs);
            this.singleSignerIndicesCS = new int[knownSigners.length];
            for (i = 0; i < knownSigners.length; ++i) {
                this.signersCS.add(knownSigners[i]);
                this.singleSignerIndicesCS[i] = i;
            }
            this.codeSourceCache.put(this.singleSignerIndicesCS, cs);
            this.signerMap.put(null, this.singleSignerIndicesCS);
            this.signerMapCert.put(null, this.singleSignerIndicesCert);
        }
    }

    @Override
    protected void authenticateJarEntry(JarFile jar, JarEntry entry) throws IOException, JARSigningException {
        String name = entry.getName();
        boolean needToSave = this.nativePath != null && name.indexOf("/") == -1 && name.indexOf("\\") == -1;
        try {
            InputStream is = this.js.updateWithZipEntry(name, jar.getInputStream(entry));
            JarAsBLOBVerifier.readAndMaybeSaveStreamTo(is, needToSave, name, this.nativePath);
        }
        catch (SignatureException e) {
            throw new JARSigningException(this.jarLocation, this.jarVersion, 2, e);
        }
        catch (SecurityException se) {
            throw new JARSigningException(this.jarLocation, this.jarVersion, 2, se);
        }
    }

    private static byte[] getBytes(InputStream is) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, n);
        }
        return baos.toByteArray();
    }
}

