/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MessageHeader {
    private String[] keys;
    private String[] values;
    private int nkeys;

    public MessageHeader() {
        this.grow();
    }

    public MessageHeader(MessageHeader copy) {
        this.keys = (String[])copy.keys.clone();
        this.values = (String[])copy.values.clone();
        this.nkeys = copy.nkeys;
    }

    synchronized String findValue(String k) {
        if (k == null) {
            int i = this.nkeys;
            while (--i >= 0) {
                if (this.keys[i] != null) continue;
                return this.values[i];
            }
        } else {
            int i = this.nkeys;
            while (--i >= 0) {
                if (!k.equalsIgnoreCase(this.keys[i])) continue;
                return this.values[i];
            }
        }
        return null;
    }

    public synchronized int getKey(String k) {
        int i = this.nkeys;
        while (--i >= 0) {
            if (this.keys[i] != k && (k == null || !k.equalsIgnoreCase(this.keys[i]))) continue;
            return i;
        }
        return -1;
    }

    public synchronized String getKey(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.keys[n];
    }

    public synchronized String getValue(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.values[n];
    }

    public synchronized Map<String, List<String>> getHeaders() {
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        int i = this.nkeys;
        while (--i >= 0) {
            ArrayList<String> l = (ArrayList<String>)m.get(this.keys[i]);
            if (l == null) {
                l = new ArrayList<String>();
                m.put(this.keys[i], l);
            }
            l.add(this.values[i]);
        }
        for (String key : m.keySet()) {
            List l = (List)m.get(key);
            m.put(key, Collections.unmodifiableList(l));
        }
        return Collections.unmodifiableMap(m);
    }

    public synchronized void add(String k, String v) {
        this.grow();
        this.keys[this.nkeys] = k;
        this.values[this.nkeys] = v;
        ++this.nkeys;
    }

    public static MessageHeader merge(MessageHeader current, MessageHeader update) {
        if (update == null) {
            return current;
        }
        HashSet<String> toAdd = new HashSet<String>(Arrays.asList(update.keys));
        MessageHeader res = new MessageHeader();
        for (int i = 0; i < current.keys.length; ++i) {
            String key = current.keys[i];
            String currentValue = current.values[i];
            if (key == null) {
                if (currentValue == null) continue;
                res.add(key, currentValue);
                continue;
            }
            int found = update.getKey(key);
            if (found == -1) {
                if (currentValue == null) continue;
                res.add(key, currentValue);
                continue;
            }
            toAdd.remove(key);
            String updateValue = update.values[found];
            if (updateValue == null) continue;
            res.add(key, updateValue);
        }
        for (String key : toAdd) {
            String value = update.findValue(key);
            if (value == null) continue;
            res.add(key, value);
        }
        return res;
    }

    private void grow() {
        if (this.keys == null || this.nkeys >= this.keys.length) {
            String[] nk = new String[this.nkeys + 4];
            String[] nv = new String[this.nkeys + 4];
            if (this.keys != null) {
                System.arraycopy(this.keys, 0, nk, 0, this.nkeys);
            }
            if (this.values != null) {
                System.arraycopy(this.values, 0, nv, 0, this.nkeys);
            }
            this.keys = nk;
            this.values = nv;
        }
    }

    public synchronized String toString() {
        Object result = super.toString();
        for (int i = 0; i < this.keys.length; ++i) {
            result = (String)result + "{" + this.keys[i] + ": " + this.values[i] + "}";
        }
        return result;
    }

    public int getContentLength(int defaultValue) {
        String value = this.findValue("content-length");
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

