/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.UpdateTracker;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SafeThreadFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.jar.JarFile;

public class MemoryCache {
    private static final Map<String, LoadedResourceReference> loadedResource;
    private static ReferenceQueue<Object> refQueue;
    private static Thread cleanupThread;
    static long CLEANUP_DELAY;
    private static WeakHashMap<CacheEntry, Object> fileExistenceConfirmedResources;

    static synchronized void reset() {
        loadedResource.clear();
    }

    public static synchronized Object addLoadedResource(String url, Object o) {
        LoadedResourceReference ref2;
        Object cur;
        LoadedResourceReference r = loadedResource.get(url);
        Object object = cur = r != null ? r.get() : null;
        if (cur != null) {
            if (o == cur) {
                return null;
            }
            if (r.getReferenceCount() > 0 && DownloadEngine.isBackgroundUpdateRequest()) {
                Trace.println("MemoryCache: skip loading backgroung update " + url + ": refcnt=" + r.refcnt, TraceLevel.CACHE);
                return null;
            }
            Trace.println("MemoryCache replacing " + url + " (refcnt=" + r.refcnt + "). Was: " + cur + " Now: " + o, TraceLevel.CACHE);
        } else {
            Trace.println("Adding MemoryCache entry: " + url, TraceLevel.CACHE);
        }
        LoadedResourceReference ref = new LoadedResourceReference(o);
        if (!(o instanceof CacheEntry)) {
            ref.registerReference(new CachedResourceReference(o, refQueue, url));
        }
        if ((ref2 = loadedResource.put(url, ref)) != null) {
            return ref2.get();
        }
        return null;
    }

    public static synchronized Object getLoadedResource(String url) {
        return MemoryCache.getLoadedResource(url, true);
    }

    static synchronized Object getLoadedResource(String url, boolean referencing) {
        LoadedResourceReference ref = loadedResource.get(url);
        if (ref == null) {
            return null;
        }
        Object result = ref.get();
        if (result != null) {
            if (MemoryCache.validateResource(result)) {
                if (referencing) {
                    ref.cancelDelayRemoval();
                    MemoryCache.addResourceReference(result, url);
                }
                return result;
            }
            loadedResource.remove(url);
        }
        return null;
    }

    static synchronized Object removeLoadedResource(String url) {
        LoadedResourceReference ref = loadedResource.remove(url);
        if (ref != null) {
            Object o = ref.get();
            Trace.println("MemoryCache: removed entry " + url, TraceLevel.CACHE);
            return o;
        }
        return null;
    }

    public static synchronized void clearLoadedResources() {
        loadedResource.clear();
        UpdateTracker.clear();
        DownloadEngine.clearRedirectURLs();
    }

    public static synchronized void shutdown() {
        MemoryCache.closeJars();
        MemoryCache.clearLoadedResources();
    }

    private static void closeJars() {
        for (Map.Entry<String, LoadedResourceReference> e : loadedResource.entrySet()) {
            MemoryCache.ensureJarsClosed(e.getValue());
        }
        MemoryCache.reset();
    }

    private static void ensureJarsClosed(Object o) {
        if (o instanceof LoadedResourceReference) {
            LoadedResourceReference ref = (LoadedResourceReference)o;
            MemoryCache.closeIfJar(ref.get());
            Iterator<Reference<?>> j = ref.getReferences();
            while (j.hasNext()) {
                CachedResourceReference r = (CachedResourceReference)j.next();
                MemoryCache.closeIfJar(r.get());
            }
        }
    }

    private static void closeIfJar(Object o) {
        try {
            if (o instanceof CacheEntry) {
                CacheEntry ce = (CacheEntry)o;
                o = ce.getRefJar();
            } else if (o instanceof Resource && ((Resource)o).isJarFile()) {
                o = ((Resource)o).getJarFile();
            }
            if (o instanceof ResourceObject) {
                ((ResourceObject)o).doClose();
            } else if (o instanceof JarFile) {
                ((JarFile)o).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static synchronized void addResourceReference(Object file, String url) {
        LoadedResourceReference loadedRef = loadedResource.get(url);
        if (loadedRef != null) {
            loadedRef.registerReference(new CachedResourceReference(file, refQueue, url));
        }
    }

    static synchronized boolean contains(String url) {
        return loadedResource.containsKey(url);
    }

    public static synchronized void resetFileExistenceCheck() {
        fileExistenceConfirmedResources.clear();
    }

    private static boolean validateResource(Object resource) {
        if (resource == null) {
            return false;
        }
        if (resource instanceof CacheEntry) {
            CacheEntry ce = (CacheEntry)resource;
            if (Cache.hasIncompatibleCompressEncoding(ce)) {
                return false;
            }
            if (!fileExistenceConfirmedResources.containsKey(ce)) {
                if (!ce.storageFilesExist()) {
                    return false;
                }
                fileExistenceConfirmedResources.put(ce, null);
            }
        }
        return true;
    }

    public static synchronized boolean isCacheEntryLoaded(String url, String version) {
        CacheEntry ce;
        Object loaded = MemoryCache.getLoadedResource(url, false);
        return loaded instanceof CacheEntry && ((ce = (CacheEntry)loaded).getVersion() == null && version == null || version != null && version.equals(ce.getVersion()));
    }

    static int getReferenceCount(String url) {
        LoadedResourceReference ref = loadedResource.get(url);
        return ref == null ? 0 : ref.getReferenceCount();
    }

    static LoadedResourceReference getReferences(String url) {
        return loadedResource.get(url);
    }

    static {
        refQueue = new ReferenceQueue();
        CLEANUP_DELAY = 60000L;
        loadedResource = new HashMap<String, LoadedResourceReference>();
        cleanupThread = SafeThreadFactory.createThread(new LoadedResourceCleanup(), "CacheMemoryCleanUpThread");
        cleanupThread.setDaemon(true);
        cleanupThread.start();
        Thread shutdownHook = SafeThreadFactory.createThread(new Runnable(){

            @Override
            public void run() {
                MemoryCache.shutdown();
            }
        });
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        fileExistenceConfirmedResources = new WeakHashMap();
    }

    static class LoadedResourceCleanup
    implements Runnable {
        Timer timer = new Timer("MemoryCache-DelayedCleanup", true);

        LoadedResourceCleanup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        CachedResourceReference ref = (CachedResourceReference)refQueue.remove();
                        Map map = loadedResource;
                        synchronized (map) {
                            String u = ref.getURL();
                            Trace.println("Clean up the reference queue: " + u, TraceLevel.CACHE);
                            LoadedResourceReference loadedRef = (LoadedResourceReference)loadedResource.get(u);
                            if (loadedRef != null && loadedRef.deregisterReference(ref)) {
                                this.delayedRemoveResource(loadedRef, u);
                                Trace.println("delayedRemoveResource: " + u, TraceLevel.CACHE);
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception ex) {
                    if (!Trace.isEnabled(TraceLevel.CACHE)) continue;
                    Trace.ignored(ex);
                    continue;
                }
                break;
            }
        }

        private void delayedRemoveResource(LoadedResourceReference ref, final String url) {
            TimerTask tt = new TimerTask(){

                @Override
                public void run() {
                    if (Cache.DEBUG) {
                        Trace.println("Cleanup delay timer expires @" + System.currentTimeMillis() + " for " + url, TraceLevel.CACHE);
                    }
                    MemoryCache.removeLoadedResource(url);
                }
            };
            this.timer.schedule(tt, CLEANUP_DELAY);
            if (Cache.DEBUG) {
                Trace.println("Started cleanup timer (" + CLEANUP_DELAY + " ms) for: " + url, TraceLevel.CACHE);
            }
            ref.setCleanupTask(tt);
        }
    }

    private static class CachedResourceReference
    extends WeakReference<Object> {
        String url;

        public CachedResourceReference(Object obj, ReferenceQueue<Object> q, String url) {
            super(obj, q);
            this.url = url;
        }

        public String getURL() {
            return this.url;
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(Object o) {
            CachedResourceReference r = (CachedResourceReference)o;
            return r != null && this.get() == r.get() && this.url.equals(r.getURL());
        }
    }

    static class LoadedResourceReference {
        private Set<Reference<?>> resourceRefs = new HashSet();
        private int refcnt = 0;
        private Object o;
        private TimerTask delayedRemoveTask;

        LoadedResourceReference(Object ref) {
            this.o = ref;
        }

        Object get() {
            return this.o;
        }

        synchronized void registerReference(Reference<?> r) {
            if (this.resourceRefs.add(r)) {
                ++this.refcnt;
                Trace.println("registerReference: " + r.toString() + ": " + this.refcnt, TraceLevel.CACHE);
            }
        }

        synchronized boolean deregisterReference(Reference<?> r) {
            --this.refcnt;
            this.resourceRefs.remove(r);
            Trace.println("deregisterReference: " + r.toString() + ": " + this.refcnt, TraceLevel.CACHE);
            return this.refcnt <= 1;
        }

        synchronized int getReferenceCount() {
            return this.refcnt;
        }

        synchronized Iterator<Reference<?>> getReferences() {
            return this.resourceRefs.iterator();
        }

        synchronized void cancelDelayRemoval() {
            if (this.delayedRemoveTask != null) {
                Trace.println("Cancel delay cleanup: " + this.o, TraceLevel.CACHE);
                this.delayedRemoveTask.cancel();
                this.delayedRemoveTask = null;
            }
        }

        synchronized void setCleanupTask(TimerTask tt) {
            this.cancelDelayRemoval();
            this.delayedRemoveTask = tt;
        }
    }
}

