/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.ImmutableAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

final class ImmutableManifest
extends Manifest {
    private final Manifest backingStore;
    private final Attributes readOnlyAttributes;
    private final Map<String, Attributes> readOnlyEntries;

    public ImmutableManifest() {
        this(new Manifest());
    }

    public ImmutableManifest(InputStream is) throws IOException {
        this(new Manifest(is));
    }

    public ImmutableManifest(Manifest man) {
        this.backingStore = new Manifest(man);
        this.readOnlyAttributes = new ImmutableAttributes(this.backingStore.getMainAttributes());
        Map<String, Attributes> entries = this.backingStore.getEntries();
        LinkedHashMap<String, ImmutableAttributes> roEntries = new LinkedHashMap<String, ImmutableAttributes>();
        for (String key : entries.keySet()) {
            roEntries.put(key, new ImmutableAttributes(entries.get(key)));
        }
        this.readOnlyEntries = Collections.unmodifiableMap(roEntries);
    }

    @Override
    public Attributes getMainAttributes() {
        return this.readOnlyAttributes;
    }

    @Override
    public Map<String, Attributes> getEntries() {
        return this.readOnlyEntries;
    }

    @Override
    public Attributes getAttributes(String name) {
        return this.readOnlyEntries.get(name);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Manifest) {
            Manifest m = (Manifest)o;
            return this.readOnlyAttributes.equals(m.getMainAttributes()) && this.readOnlyEntries.equals(m.getEntries());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.readOnlyAttributes.hashCode() + this.readOnlyEntries.hashCode();
    }

    @Override
    public Object clone() {
        return new ImmutableManifest(this);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.backingStore.write(out);
    }

    @Override
    public void read(InputStream is) throws IOException {
        throw new UnsupportedOperationException();
    }
}

