/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.DeployCacheRequest;
import com.sun.deploy.cache.DeployCacheResponse;
import com.sun.deploy.cache.DeploySecureCacheResponse;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.BasicHttpRequest;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.net.UpdateTracker;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeployCacheHandler
extends ResponseCache {
    private final HashMap<URI, Object> inProgress = new HashMap();
    private ThreadLocal<Boolean> inCacheHandler = new ThreadLocal();
    static final AccessControlContext ACC_FILE_INSTANCE;

    public static void reset() {
        ResponseCache.setDefault(new DeployCacheHandler());
        URLUtil.clearPack200Original();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfInternalLocksInUse() {
        HashMap<URI, Object> hashMap = this.inProgress;
        synchronized (hashMap) {
            return this.inProgress.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CacheResponse get(URI uri, String rqstMethod, final Map<String, List<String>> requestHeaders) throws IOException {
        Object lock;
        if (DownloadEngine.haveDownloadInProgress()) {
            return null;
        }
        CacheResponse response = null;
        if (!Cache.isCacheEnabled()) return null;
        if (!rqstMethod.equals("GET")) return null;
        if (this.inCacheHandler.get() != null) {
            return null;
        }
        Object object = this.inProgress;
        synchronized (object) {
            if (!this.inProgress.containsKey(uri)) {
                this.inProgress.put(uri, new Object());
            }
            lock = this.inProgress.get(uri);
        }
        object = lock;
        synchronized (object) {
            try {
                Map<String, List<String>> cachedHeadersNEW;
                this.inCacheHandler.set(Boolean.TRUE);
                File cachedFile = null;
                URL origUrl = URLUtil.getPack200Original(uri.toURL());
                final boolean isPackEnabled = origUrl != null;
                final URL url = isPackEnabled ? origUrl : uri.toURL();
                final URL urlNoQuery = HttpUtils.removeQueryStringFromURL(url);
                final String jarVersion = (String)ToolkitStore.get().getAppContext().get("deploy-" + urlNoQuery);
                boolean updateAvail = false;
                int downloadTypes = 1;
                if (isPackEnabled) {
                    downloadTypes = 4352;
                }
                if (!DeployOfflineManager.isGlobalOffline() && UpdateTracker.isUpdateCheckNeeded(url.toString())) {
                    updateAvail = ResourceProvider.get().isUpdateAvailable(url, jarVersion, downloadTypes, requestHeaders);
                }
                if (!updateAvail) {
                    try {
                        cachedFile = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                            @Override
                            public File run() throws IOException {
                                URL u = jarVersion == null ? url : urlNoQuery;
                                return DeployCacheHandler.this.getCacheFile(u, jarVersion, requestHeaders, isPackEnabled);
                            }
                        }, ACC_FILE_INSTANCE);
                    }
                    catch (PrivilegedActionException pae) {
                        Trace.ignoredException(pae);
                    }
                }
                if (cachedFile == null) {
                    CacheResponse pae = null;
                    return pae;
                }
                InputStream is = null;
                final File cachedFileF = cachedFile;
                if (cachedFileF == null) return response;
                try {
                    is = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws IOException {
                            return new FileInputStream(cachedFileF);
                        }
                    }, ACC_FILE_INSTANCE);
                }
                catch (PrivilegedActionException e) {
                    Trace.ignoredException(e);
                }
                if (is == null) return response;
                Resource r = ResourceProvider.get().getCachedResource(jarVersion == null ? url : urlNoQuery, jarVersion);
                Map<String, List<String>> map = cachedHeadersNEW = r != null ? r.getHeaders() : null;
                response = uri.getScheme().equals("https") ? new DeploySecureCacheResponse(is, cachedHeadersNEW) : new DeployCacheResponse(is, cachedHeadersNEW);
            }
            finally {
                this.inCacheHandler.set(null);
                HashMap<URI, Object> hashMap = this.inProgress;
                synchronized (hashMap) {
                    this.inProgress.remove(uri);
                }
            }
            return response;
        }
    }

    private File getCacheFile(URL url, String version, Map<String, List<String>> requestHeaders, boolean packEnabled) {
        CacheEntry ce = Cache.getCacheEntry(url, version);
        boolean internalUse = ResourceProvider.get().isInternalUse();
        if (ce != null && ce.isJarFile()) {
            if (internalUse || packEnabled) {
                if (ce.hasCompressEncoding()) {
                    ce = null;
                }
            } else if (ce.hasCompressEncoding()) {
                if (!HttpUtils.matchEncoding(null, requestHeaders, ce.getHeaders())) {
                    ce = null;
                }
            } else if (!ce.hasCompressEncoding() && HttpUtils.refusesIdentityEncodings(requestHeaders)) {
                ce = null;
            }
        }
        if (ce != null) {
            return new File(ce.getResourceFilename());
        }
        return null;
    }

    static boolean isResourceCacheable(String url, URLConnection conn) {
        if (!conn.getUseCaches() && !DownloadEngine.isAlwaysCached(url)) {
            return false;
        }
        if (conn instanceof HttpURLConnection && !((HttpURLConnection)conn).getRequestMethod().equals("GET")) {
            return false;
        }
        try {
            MessageHeader header = BasicHttpRequest.initializeHeaderFields(conn);
            return HttpUtils.isResourceCacheable(url, header, true);
        }
        catch (IOException ex) {
            Trace.ignored(ex);
            return false;
        }
    }

    @Override
    public CacheRequest put(URI uri, URLConnection conn) throws IOException {
        if (DownloadEngine.haveDownloadInProgress()) {
            return null;
        }
        if (!DeployCacheHandler.isResourceCacheable(uri.toString(), conn)) {
            return null;
        }
        URL origUrl = URLUtil.getPack200Original(uri.toURL());
        boolean isPackEnabled = false;
        if (origUrl != null) {
            isPackEnabled = true;
        }
        URL url = isPackEnabled ? origUrl : uri.toURL();
        return new DeployCacheRequest(url, conn, isPackEnabled);
    }

    static {
        Permissions perms = new Permissions();
        FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write,delete");
        ((PermissionCollection)perms).add(new RuntimePermission("accessDeclaredMembers"));
        ((PermissionCollection)perms).add(perm);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }
}

