/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.cache.AbstractLocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;

public abstract class BaseLocalApplicationProperties
extends AbstractLocalApplicationProperties {
    protected static final String REBOOT_NEEDED_KEY = "rebootNeeded";
    protected static final String UPDATE_CHECK_KEY = "forcedUpdateCheck";
    protected static final String NATIVELIB_DIR_KEY = "nativeLibDir";
    protected static final String INSTALL_DIR_KEY = "installDir";
    protected static final String LAST_ACCESSED_KEY = "lastAccessed";
    protected static final String LAUNCH_COUNT_KEY = "launchCount";
    protected static final String ASK_INSTALL_KEY = "askedInstall";
    protected static final String SHORTCUT_KEY = "locallyInstalled";
    protected static final String EXTENSION_KEY = "extensionInstalled";
    protected static final String JNLP_INSTALLED_KEY = "jnlpInstalled";
    protected static final String INDIRECT_PATH_KEY = "indirectPath";
    protected static final String ASSOCIATION_MIME_KEY = "mime.types.";
    protected static final String REGISTERED_TITLE_KEY = "title";
    protected static final String ASSOCIATION_EXTENSIONS_KEY = "extensions.";
    protected static final String DRAGGED_APPLET_KEY = "draggedApplet";
    protected static final String DOCUMENTBASE_KEY = "documentBase";
    protected static final String CODEBASE_KEY = "codebase";
    protected static final String ORIGINAL_URL_KEY = "originalURL";
    protected static final String MAIN_PUBLISHER_KEY = "mainPublisher";
    protected static final String MAIN_TITLE_KEY = "mainTitle";
    protected Properties _properties;
    private URL _location;
    private String _versionId;
    private boolean _isApplicationDescriptor;
    protected boolean _isShortcutInstalledSystem;

    public BaseLocalApplicationProperties(URL location, String versionId, boolean isApplicationDescriptor) {
        this._location = location;
        this._versionId = versionId;
        this._isApplicationDescriptor = isApplicationDescriptor;
        this._isShortcutInstalledSystem = false;
        this._properties = new Properties();
    }

    @Override
    public void clearMainPublisherAndTitle() {
        this.setMainPublisher(null);
        this.setMainTitle(null);
        try {
            this.store();
        }
        catch (IOException ioe) {
            Trace.ignored(ioe);
        }
    }

    @Override
    public void storeMainPublisherAndTitle(String mainPublisher, String mainTitle) {
        String unknown = ResourceManager.getString("security.dialog.notverified.subject").toUpperCase();
        if (this.getMainPublisher() != null && this.getMainTitle() != null) {
            return;
        }
        if (mainPublisher == null) {
            mainPublisher = unknown;
        }
        if (mainTitle == null) {
            mainTitle = unknown;
        }
        this.setMainPublisher(mainPublisher);
        this.setMainTitle(mainTitle);
        try {
            this.store();
        }
        catch (IOException ioe) {
            Trace.ignored(ioe);
        }
    }

    private void setMainPublisher(String mainPublisher) {
        this.put(MAIN_PUBLISHER_KEY, mainPublisher);
    }

    @Override
    public String getMainPublisher() {
        return this.get(MAIN_PUBLISHER_KEY);
    }

    private void setMainTitle(String mainTitle) {
        this.put(MAIN_TITLE_KEY, mainTitle);
    }

    @Override
    public String getMainTitle() {
        return this.get(MAIN_TITLE_KEY);
    }

    @Override
    public void setEnableCustomPreloader(boolean enable) {
        this.put("ssv.enable.custom.preloader", Boolean.toString(enable));
    }

    @Override
    public boolean getEnableCustomPreloader() {
        return this.getBoolean("ssv.enable.custom.preloader");
    }

    @Override
    public URL getLocation() {
        return this._location;
    }

    @Override
    public String getVersionId() {
        return this._versionId;
    }

    @Override
    public void setLastAccessed(Date date) {
        this.put(LAST_ACCESSED_KEY, _df.format(date));
    }

    @Override
    public Date getLastAccessed() {
        return this.getDate(LAST_ACCESSED_KEY);
    }

    @Override
    public void incrementLaunchCount() {
        int count = this.getLaunchCount();
        this.put(LAUNCH_COUNT_KEY, Integer.toString(++count));
    }

    @Override
    public int getLaunchCount() {
        return this.getInteger(LAUNCH_COUNT_KEY);
    }

    @Override
    public void setAskedForInstall(boolean askedForInstall) {
        this.put(ASK_INSTALL_KEY, Boolean.toString(askedForInstall));
    }

    @Override
    public boolean getAskedForInstall() {
        return this.getBoolean(ASK_INSTALL_KEY);
    }

    @Override
    public void setRebootNeeded(boolean reboot) {
        this.put(REBOOT_NEEDED_KEY, Boolean.toString(reboot));
    }

    @Override
    public boolean isRebootNeeded() {
        return this.getBoolean(REBOOT_NEEDED_KEY);
    }

    @Override
    public void setDraggedApplet() {
        this.put(DRAGGED_APPLET_KEY, Boolean.toString(true));
    }

    @Override
    public boolean isDraggedApplet() {
        return this.getBoolean(DRAGGED_APPLET_KEY);
    }

    @Override
    public void setDocumentBase(String documentBase) {
        this.put(DOCUMENTBASE_KEY, documentBase);
    }

    @Override
    public String getDocumentBase() {
        return this.get(DOCUMENTBASE_KEY);
    }

    @Override
    public void setCodebase(String codebase) {
        this.put(CODEBASE_KEY, codebase);
    }

    @Override
    public String getCodebase() {
        return this.get(CODEBASE_KEY);
    }

    @Override
    public String getOriginalURL() {
        return this.get(ORIGINAL_URL_KEY);
    }

    @Override
    public void setOriginalURL(String originalURL) {
        this.put(ORIGINAL_URL_KEY, originalURL);
    }

    @Override
    public void setShortcutInstalled(boolean installed) {
        this.put(SHORTCUT_KEY, Boolean.toString(installed));
    }

    @Override
    public boolean isShortcutInstalled() {
        return this.getBoolean(SHORTCUT_KEY);
    }

    @Override
    public boolean isShortcutInstalledSystem() {
        return this._isShortcutInstalledSystem;
    }

    @Override
    public void setExtensionInstalled(boolean installed) {
        this.setShortcutInstalled(false);
        this.put(EXTENSION_KEY, Boolean.toString(installed));
    }

    @Override
    public boolean isExtensionInstalled() {
        return this.getBoolean(EXTENSION_KEY) || this.getBoolean(SHORTCUT_KEY);
    }

    @Override
    public void setJnlpInstalled(boolean installed) {
        this.put(JNLP_INSTALLED_KEY, Boolean.toString(installed));
    }

    @Override
    public boolean isJnlpInstalled() {
        return this.getBoolean(JNLP_INSTALLED_KEY);
    }

    @Override
    public boolean forceUpdateCheck() {
        return this.getBoolean(UPDATE_CHECK_KEY);
    }

    @Override
    public void setForceUpdateCheck(boolean state) {
        this.put(UPDATE_CHECK_KEY, Boolean.toString(state));
    }

    @Override
    public boolean isApplicationDescriptor() {
        return this._isApplicationDescriptor;
    }

    @Override
    public boolean isExtensionDescriptor() {
        return !this._isApplicationDescriptor;
    }

    @Override
    public String getInstallDirectory() {
        return this.get(INSTALL_DIR_KEY);
    }

    @Override
    public void setInstallDirectory(String path) {
        this.put(INSTALL_DIR_KEY, path);
    }

    @Override
    public String getNativeLibDirectory() {
        return this.get(NATIVELIB_DIR_KEY);
    }

    @Override
    public void setNativeLibDirectory(String path) {
        this.put(NATIVELIB_DIR_KEY, path);
    }

    @Override
    public String getRegisteredTitle() {
        return this.get(REGISTERED_TITLE_KEY);
    }

    @Override
    public void setRegisteredTitle(String title) {
        this.put(REGISTERED_TITLE_KEY, title);
    }

    @Override
    public void setAssociations(AssociationDesc[] associations) {
        int i = 0;
        if (associations == null) {
            AssociationDesc[] old = this.getAssociations();
            if (old != null) {
                this.put(ASSOCIATION_MIME_KEY + i, null);
                this.put(ASSOCIATION_EXTENSIONS_KEY + i, null);
            }
        } else {
            for (i = 0; i < associations.length; ++i) {
                this.put(ASSOCIATION_MIME_KEY + i, associations[i].getMimeType());
                this.put(ASSOCIATION_EXTENSIONS_KEY + i, associations[i].getExtensions());
            }
            this.put(ASSOCIATION_MIME_KEY + i, null);
            this.put(ASSOCIATION_EXTENSIONS_KEY + i, null);
        }
    }

    @Override
    public void addAssociation(AssociationDesc association) {
        AssociationDesc[] list;
        AssociationDesc[] old = this.getAssociations();
        if (old == null) {
            list = new AssociationDesc[1];
        } else {
            list = new AssociationDesc[old.length + 1];
            for (int i = 0; i < old.length; ++i) {
                list[i] = old[i];
            }
        }
        list[i] = association;
        this.setAssociations(list);
    }

    @Override
    public AssociationDesc[] getAssociations() {
        ArrayList<AssociationDesc> al = new ArrayList<AssociationDesc>();
        int i = 0;
        while (true) {
            String mimeType = this.get(ASSOCIATION_MIME_KEY + i);
            String extensions = this.get(ASSOCIATION_EXTENSIONS_KEY + i);
            if (mimeType == null && extensions == null) break;
            al.add(new AssociationDesc(extensions, mimeType, null, null));
            ++i;
        }
        return al.toArray(new AssociationDesc[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String value) {
        BaseLocalApplicationProperties baseLocalApplicationProperties = this;
        synchronized (baseLocalApplicationProperties) {
            if (value == null) {
                this._properties.remove(key);
            } else {
                this._properties.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        BaseLocalApplicationProperties baseLocalApplicationProperties = this;
        synchronized (baseLocalApplicationProperties) {
            return (String)this._properties.get(key);
        }
    }

    public String toString() {
        return "lap key: " + this._location + " contains properties: " + this._properties;
    }
}

