/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class HexDumpEncoderWrapper {
    private static final Class<?> encoderClass;
    private static final Method encodeBuffer;
    private static final Constructor<?> encoderCon;

    public static String encodeBuffer(byte[] byArray) {
        try {
            Object obj = encoderCon.newInstance(new Object[0]);
            return (String)encodeBuffer.invoke(obj, new Object[]{byArray});
        }
        catch (InvocationTargetException invocationTargetException) {
            HexDumpEncoderWrapper.rethrowCause(invocationTargetException);
            return null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    private static void rethrowCause(InvocationTargetException invocationTargetException) {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new AssertionError((Object)invocationTargetException);
    }

    static {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("sun.security.util.HexDumpEncoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName("sun.misc.HexDumpEncoder");
            }
            encoderClass = clazz;
            encodeBuffer = encoderClass.getMethod("encodeBuffer", byte[].class);
            encoderCon = encoderClass.getConstructor(new Class[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }
}

