/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.AuthKey;
import com.sun.deploy.trace.Trace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.net.www.protocol.http.AuthCacheValue;
import sun.net.www.protocol.http.AuthenticationInfo;

public class AuthCacheBridge {
    private AuthCacheBridge() {
    }

    public static AuthKey create(AuthCacheValue authCacheValue) {
        try {
            return new DelegateAuthCacheBridge(authCacheValue);
        }
        catch (IllegalAccessError illegalAccessError) {
            return new ReflectiveAuthCacheBridge(authCacheValue);
        }
    }

    private static class ReflectiveAuthCacheBridge
    implements AuthKey {
        private static Method getAuthTypeMethod;
        private static Method getProtocolSchemeMethod;
        private static Method getPortMethod;
        private static Method getHostMethod;
        private static Method getPathMethod;
        private static Method getPromptMethod;
        private final AuthCacheValue cacheValue;

        ReflectiveAuthCacheBridge(AuthCacheValue authCacheValue) {
            this.cacheValue = authCacheValue;
        }

        private Object invoke(Method method) {
            try {
                return method.invoke((Object)this.cacheValue, new Object[]{null});
            }
            catch (IllegalAccessException illegalAccessException) {
                Trace.ignored(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Trace.ignored(invocationTargetException);
            }
            return null;
        }

        @Override
        public boolean isProxy() {
            return (AuthCacheValue.Type)((Object)this.invoke(getAuthTypeMethod)) == AuthCacheValue.Type.Proxy;
        }

        @Override
        public String getProtocolScheme() {
            return (String)this.invoke(getProtocolSchemeMethod);
        }

        @Override
        public int getPort() {
            Integer n = (Integer)this.invoke(getPortMethod);
            return n == null ? 0 : n;
        }

        @Override
        public String getHost() {
            return (String)this.invoke(getHostMethod);
        }

        @Override
        public String getPath() {
            return (String)this.invoke(getPathMethod);
        }

        @Override
        public String getScheme() {
            return (String)this.invoke(getProtocolSchemeMethod);
        }

        @Override
        public String getPrompt() {
            return (String)this.invoke(getPromptMethod);
        }

        static {
            try {
                Class<?> clazz = Class.forName("sun.net.www.protocol.http.AuthenticationInfo");
                getAuthTypeMethod = clazz.getDeclaredMethod("getAuthType", new Class[0]);
                getProtocolSchemeMethod = clazz.getDeclaredMethod("getProtocolScheme", new Class[0]);
                getPortMethod = clazz.getDeclaredMethod("getPort", new Class[0]);
                getHostMethod = clazz.getDeclaredMethod("getHost", new Class[0]);
                getPathMethod = clazz.getDeclaredMethod("getPath", new Class[0]);
                getPromptMethod = clazz.getDeclaredMethod("getPrompt", new Class[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Trace.ignored(classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Trace.ignored(noSuchMethodException);
            }
        }
    }

    private static class DelegateAuthCacheBridge
    implements AuthKey {
        private final AuthenticationInfo cacheValue;

        DelegateAuthCacheBridge(AuthCacheValue authCacheValue) {
            this.cacheValue = (AuthenticationInfo)authCacheValue;
        }

        @Override
        public boolean isProxy() {
            return this.cacheValue.getAuthType() == AuthCacheValue.Type.Proxy;
        }

        @Override
        public String getProtocolScheme() {
            return this.cacheValue.getProtocolScheme();
        }

        @Override
        public int getPort() {
            return this.cacheValue.getPort();
        }

        @Override
        public String getHost() {
            return this.cacheValue.getHost();
        }

        @Override
        public String getPath() {
            return this.cacheValue.getPath();
        }

        @Override
        public String getScheme() {
            return this.cacheValue.getProtocolScheme();
        }

        @Override
        public String getPrompt() {
            return this.cacheValue.getRealm();
        }
    }
}

