/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.cookie;

import com.sun.deploy.net.cookie.CookieStore;
import com.sun.deploy.net.cookie.HttpCookie;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import java.util.TreeMap;

final class NetscapeCookieStore
extends CookieStore {
    private Date lastAccessDate = new Date(0L);
    private File cookieFile = null;
    private static final AccessControlContext ACC_COOKIE_INSTANCE;

    NetscapeCookieStore(File file) {
        this.cookieFile = file;
    }

    @Override
    protected void loadCookieJar() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                NetscapeCookieStore.this.loadCookieJarFromStorage();
                return null;
            }
        }, ACC_COOKIE_INSTANCE);
    }

    private void loadCookieJarFromStorage() {
        Date date;
        if (this.cookieFile.exists() && (date = new Date(this.cookieFile.lastModified())).after(this.lastAccessDate)) {
            TreeMap<String, ArrayList<HttpCookie>> treeMap = new TreeMap<String, ArrayList<HttpCookie>>();
            try {
                FileInputStream fileInputStream = new FileInputStream(this.cookieFile);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    HttpCookie httpCookie;
                    if (string.startsWith("#") || string.trim().equals("") || (httpCookie = this.readCookieRecord(string)) == null || httpCookie.hasExpired() || this.shouldRejectCookie(httpCookie)) continue;
                    String string2 = httpCookie.getDomain().toLowerCase();
                    ArrayList<HttpCookie> arrayList = (ArrayList<HttpCookie>)treeMap.get(string2);
                    if (arrayList == null) {
                        arrayList = new ArrayList<HttpCookie>();
                    }
                    if (!this.addOrReplaceCookie(arrayList, httpCookie)) continue;
                    treeMap.put(string2, arrayList);
                }
                bufferedReader.close();
                inputStreamReader.close();
                fileInputStream.close();
                this.lastAccessDate = new Date(this.cookieFile.lastModified());
                this.cookieJar = treeMap;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    protected void saveCookieJar() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                NetscapeCookieStore.this.saveCookieJarToStorage();
                return null;
            }
        }, ACC_COOKIE_INSTANCE);
    }

    private void saveCookieJarToStorage() {
        try {
            Object object;
            Object object22;
            String string = System.getProperty("line.separator");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("# Java Deployment HTTP Cookie File");
            stringBuffer.append(string);
            stringBuffer.append("# http://www.netscape.com/newsref/std/cookie_spec.html");
            stringBuffer.append(string);
            stringBuffer.append("# This is a generated file!  Do not edit.");
            stringBuffer.append(string);
            stringBuffer.append(string);
            for (Object object22 : this.cookieJar.values()) {
                object = object22.iterator();
                while (object.hasNext()) {
                    HttpCookie httpCookie = (HttpCookie)object.next();
                    if (httpCookie.hasExpired()) continue;
                    this.writeCookieRecord(httpCookie, stringBuffer);
                    stringBuffer.append(string);
                }
            }
            this.cookieFile.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(this.cookieFile);
            object22 = new BufferedOutputStream(fileOutputStream);
            object = new PrintWriter((OutputStream)object22);
            ((PrintWriter)object).println(stringBuffer.toString());
            ((PrintWriter)object).close();
            ((FilterOutputStream)object22).close();
            fileOutputStream.close();
            this.lastAccessDate = new Date(this.cookieFile.lastModified());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected String getName() {
        return "Persistent Cookie Store";
    }

    @Override
    protected boolean shouldRejectCookie(HttpCookie httpCookie) {
        if (super.shouldRejectCookie(httpCookie)) {
            return true;
        }
        return httpCookie.getExpirationDate() == null || httpCookie.hasExpired();
    }

    private HttpCookie readCookieRecord(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", true);
            if (stringTokenizer.countTokens() < 10) {
                return null;
            }
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(".") == -1) {
                return null;
            }
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("\t")) {
                string3 = "FALSE";
            } else {
                stringTokenizer.nextToken();
            }
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("\t")) {
                string4 = "/";
            } else {
                stringTokenizer.nextToken();
            }
            String string5 = stringTokenizer.nextToken();
            if (string5.equals("\t")) {
                string5 = "TRUE";
            } else {
                stringTokenizer.nextToken();
            }
            boolean bl = !string5.equalsIgnoreCase("false");
            Date date = new Date(Long.parseLong(stringTokenizer.nextToken()) * 1000L);
            stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            if (string6.equals("\t") || string6.trim().equals("")) {
                return null;
            }
            stringTokenizer.nextToken();
            String string7 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                string7 = string7 + stringTokenizer.nextToken();
            }
            String string8 = string6 + "=" + string7;
            return HttpCookie.create(date, string8, string4, string2, bl);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private void writeCookieRecord(HttpCookie httpCookie, StringBuffer stringBuffer) {
        String string = httpCookie.getDomain();
        stringBuffer.append(string);
        stringBuffer.append("\t");
        if (string.startsWith(".")) {
            stringBuffer.append("TRUE\t");
        } else {
            stringBuffer.append("FALSE\t");
        }
        stringBuffer.append(httpCookie.getPath());
        stringBuffer.append("\t");
        if (httpCookie.isSecure()) {
            stringBuffer.append("TRUE\t");
        } else {
            stringBuffer.append("FALSE\t");
        }
        stringBuffer.append(httpCookie.getExpirationDate().getTime() / 1000L + "\t");
        stringBuffer.append(httpCookie.getName());
        stringBuffer.append("\t");
        stringBuffer.append(httpCookie.getValue());
    }

    static {
        Permissions permissions = new Permissions();
        FilePermission filePermission = new FilePermission("<<ALL FILES>>", "read,write");
        ((PermissionCollection)permissions).add(filePermission);
        PropertyPermission propertyPermission = new PropertyPermission("line.separator", "read");
        ((PermissionCollection)permissions).add(propertyPermission);
        ACC_COOKIE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }
}

