/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.UpdateTracker;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SafeThreadFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.jar.JarFile;

public class MemoryCache {
    private static final Map<String, LoadedResourceReference> loadedResource;
    private static ReferenceQueue<Object> refQueue;
    private static Thread cleanupThread;
    static long CLEANUP_DELAY;
    private static WeakHashMap<CacheEntry, Object> fileExistenceConfirmedResources;

    static synchronized void reset() {
        loadedResource.clear();
    }

    public static synchronized Object addLoadedResource(String string, Object object) {
        LoadedResourceReference loadedResourceReference;
        Object object2;
        LoadedResourceReference loadedResourceReference2 = loadedResource.get(string);
        Object object3 = object2 = loadedResourceReference2 != null ? loadedResourceReference2.get() : null;
        if (object2 != null) {
            if (object == object2) {
                return null;
            }
            if (loadedResourceReference2.getReferenceCount() > 0 && DownloadEngine.isBackgroundUpdateRequest()) {
                Trace.println("MemoryCache: skip loading backgroung update " + string + ": refcnt=" + loadedResourceReference2.refcnt, TraceLevel.CACHE);
                return null;
            }
            Trace.println("MemoryCache replacing " + string + " (refcnt=" + loadedResourceReference2.refcnt + "). Was: " + object2 + " Now: " + object, TraceLevel.CACHE);
        } else {
            Trace.println("Adding MemoryCache entry: " + string, TraceLevel.CACHE);
        }
        LoadedResourceReference loadedResourceReference3 = new LoadedResourceReference(object);
        if (!(object instanceof CacheEntry)) {
            loadedResourceReference3.registerReference(new CachedResourceReference(object, refQueue, string));
        }
        if ((loadedResourceReference = loadedResource.put(string, loadedResourceReference3)) != null) {
            return loadedResourceReference.get();
        }
        return null;
    }

    public static synchronized Object getLoadedResource(String string) {
        return MemoryCache.getLoadedResource(string, true);
    }

    static synchronized Object getLoadedResource(String string, boolean bl) {
        LoadedResourceReference loadedResourceReference = loadedResource.get(string);
        if (loadedResourceReference == null) {
            return null;
        }
        Object object = loadedResourceReference.get();
        if (object != null) {
            if (MemoryCache.validateResource(object)) {
                if (bl) {
                    loadedResourceReference.cancelDelayRemoval();
                    MemoryCache.addResourceReference(object, string);
                }
                return object;
            }
            loadedResource.remove(string);
        }
        return null;
    }

    static synchronized Object removeLoadedResource(String string) {
        LoadedResourceReference loadedResourceReference = loadedResource.remove(string);
        if (loadedResourceReference != null) {
            Object object = loadedResourceReference.get();
            Trace.println("MemoryCache: removed entry " + string, TraceLevel.CACHE);
            return object;
        }
        return null;
    }

    public static synchronized void clearLoadedResources() {
        loadedResource.clear();
        UpdateTracker.clear();
        DownloadEngine.clearRedirectURLs();
    }

    public static synchronized void shutdown() {
        MemoryCache.closeJars();
        MemoryCache.clearLoadedResources();
    }

    private static void closeJars() {
        for (Map.Entry<String, LoadedResourceReference> entry : loadedResource.entrySet()) {
            MemoryCache.ensureJarsClosed(entry.getValue());
        }
        MemoryCache.reset();
    }

    private static void ensureJarsClosed(Object object) {
        if (object instanceof LoadedResourceReference) {
            LoadedResourceReference loadedResourceReference = (LoadedResourceReference)object;
            MemoryCache.closeIfJar(loadedResourceReference.get());
            Iterator<Reference<?>> iterator = loadedResourceReference.getReferences();
            while (iterator.hasNext()) {
                CachedResourceReference cachedResourceReference = (CachedResourceReference)iterator.next();
                MemoryCache.closeIfJar(cachedResourceReference.get());
            }
        }
    }

    private static void closeIfJar(Object object) {
        try {
            if (object instanceof CacheEntry) {
                CacheEntry cacheEntry = (CacheEntry)object;
                object = cacheEntry.getRefJar();
            } else if (object instanceof Resource && ((Resource)object).isJarFile()) {
                object = ((Resource)object).getJarFile();
            }
            if (object instanceof ResourceObject) {
                ((ResourceObject)object).doClose();
            } else if (object instanceof JarFile) {
                ((JarFile)object).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static synchronized void addResourceReference(Object object, String string) {
        LoadedResourceReference loadedResourceReference = loadedResource.get(string);
        if (loadedResourceReference != null) {
            loadedResourceReference.registerReference(new CachedResourceReference(object, refQueue, string));
        }
    }

    static synchronized boolean contains(String string) {
        return loadedResource.containsKey(string);
    }

    public static synchronized void resetFileExistenceCheck() {
        fileExistenceConfirmedResources.clear();
    }

    private static boolean validateResource(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof CacheEntry) {
            CacheEntry cacheEntry = (CacheEntry)object;
            if (Cache.hasIncompatibleCompressEncoding(cacheEntry)) {
                return false;
            }
            if (!fileExistenceConfirmedResources.containsKey(cacheEntry)) {
                if (!cacheEntry.storageFilesExist()) {
                    return false;
                }
                fileExistenceConfirmedResources.put(cacheEntry, null);
            }
        }
        return true;
    }

    public static synchronized boolean isCacheEntryLoaded(String string, String string2) {
        CacheEntry cacheEntry;
        Object object = MemoryCache.getLoadedResource(string, false);
        return object instanceof CacheEntry && ((cacheEntry = (CacheEntry)object).getVersion() == null && string2 == null || string2 != null && string2.equals(cacheEntry.getVersion()));
    }

    static int getReferenceCount(String string) {
        LoadedResourceReference loadedResourceReference = loadedResource.get(string);
        return loadedResourceReference == null ? 0 : loadedResourceReference.getReferenceCount();
    }

    static LoadedResourceReference getReferences(String string) {
        return loadedResource.get(string);
    }

    static {
        refQueue = new ReferenceQueue();
        CLEANUP_DELAY = 60000L;
        loadedResource = new HashMap<String, LoadedResourceReference>();
        cleanupThread = SafeThreadFactory.createThread(new LoadedResourceCleanup(), "CacheMemoryCleanUpThread");
        cleanupThread.setDaemon(true);
        cleanupThread.start();
        Thread thread = SafeThreadFactory.createThread(new Runnable(){

            @Override
            public void run() {
                MemoryCache.shutdown();
            }
        });
        Runtime.getRuntime().addShutdownHook(thread);
        fileExistenceConfirmedResources = new WeakHashMap();
    }

    static class LoadedResourceCleanup
    implements Runnable {
        Timer timer = new Timer("MemoryCache-DelayedCleanup", true);

        LoadedResourceCleanup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        CachedResourceReference cachedResourceReference = (CachedResourceReference)refQueue.remove();
                        Map map = loadedResource;
                        synchronized (map) {
                            String string = cachedResourceReference.getURL();
                            Trace.println("Clean up the reference queue: " + string, TraceLevel.CACHE);
                            LoadedResourceReference loadedResourceReference = (LoadedResourceReference)loadedResource.get(string);
                            if (loadedResourceReference != null && loadedResourceReference.deregisterReference(cachedResourceReference)) {
                                this.delayedRemoveResource(loadedResourceReference, string);
                                Trace.println("delayedRemoveResource: " + string, TraceLevel.CACHE);
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception exception) {
                    if (!Trace.isEnabled(TraceLevel.CACHE)) continue;
                    Trace.ignored(exception);
                    continue;
                }
                break;
            }
        }

        private void delayedRemoveResource(LoadedResourceReference loadedResourceReference, final String string) {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    if (Cache.DEBUG) {
                        Trace.println("Cleanup delay timer expires @" + System.currentTimeMillis() + " for " + string, TraceLevel.CACHE);
                    }
                    MemoryCache.removeLoadedResource(string);
                }
            };
            this.timer.schedule(timerTask, CLEANUP_DELAY);
            if (Cache.DEBUG) {
                Trace.println("Started cleanup timer (" + CLEANUP_DELAY + " ms) for: " + string, TraceLevel.CACHE);
            }
            loadedResourceReference.setCleanupTask(timerTask);
        }
    }

    private static class CachedResourceReference
    extends WeakReference<Object> {
        String url;

        public CachedResourceReference(Object object, ReferenceQueue<Object> referenceQueue, String string) {
            super(object, referenceQueue);
            this.url = string;
        }

        public String getURL() {
            return this.url;
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(Object object) {
            CachedResourceReference cachedResourceReference = (CachedResourceReference)object;
            return cachedResourceReference != null && this.get() == cachedResourceReference.get() && this.url.equals(cachedResourceReference.getURL());
        }
    }

    static class LoadedResourceReference {
        private Set<Reference<?>> resourceRefs = new HashSet();
        private int refcnt = 0;
        private Object o;
        private TimerTask delayedRemoveTask;

        LoadedResourceReference(Object object) {
            this.o = object;
        }

        Object get() {
            return this.o;
        }

        synchronized void registerReference(Reference<?> reference) {
            if (this.resourceRefs.add(reference)) {
                ++this.refcnt;
                Trace.println("registerReference: " + reference.toString() + ": " + this.refcnt, TraceLevel.CACHE);
            }
        }

        synchronized boolean deregisterReference(Reference<?> reference) {
            --this.refcnt;
            this.resourceRefs.remove(reference);
            Trace.println("deregisterReference: " + reference.toString() + ": " + this.refcnt, TraceLevel.CACHE);
            return this.refcnt <= 1;
        }

        synchronized int getReferenceCount() {
            return this.refcnt;
        }

        synchronized Iterator<Reference<?>> getReferences() {
            return this.resourceRefs.iterator();
        }

        synchronized void cancelDelayRemoval() {
            if (this.delayedRemoveTask != null) {
                Trace.println("Cancel delay cleanup: " + this.o, TraceLevel.CACHE);
                this.delayedRemoveTask.cancel();
                this.delayedRemoveTask = null;
            }
        }

        synchronized void setCleanupTask(TimerTask timerTask) {
            this.cancelDelayRemoval();
            this.delayedRemoveTask = timerTask;
        }
    }
}

