/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.Globals;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.ui.ApplicationIconGenerator;
import com.sun.javaws.ui.SplashScreen;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

public class CacheUtil {
    public static void fixShortcut() {
        ArrayList arrayList = Cache.getJnlpCacheEntries((boolean)Environment.isSystemCacheMode());
        for (File file : arrayList) {
            LaunchDesc launchDesc = null;
            try {
                launchDesc = LaunchDescFactory.buildDescriptor(file, null, null, null);
            }
            catch (Exception exception) {
                Trace.println((String)"Cached jnlp file has no codebase", (TraceLevel)TraceLevel.CACHE);
                try {
                    launchDesc = LaunchDescFactory.buildDescriptor(file);
                }
                catch (Exception exception2) {
                    Trace.ignoredException((Exception)exception);
                }
            }
            if (launchDesc == null) continue;
            CacheEntry cacheEntry = null;
            File file2 = new File(file.getPath() + ".idx");
            cacheEntry = file2.exists() ? Cache.getCacheEntryFromFile((File)file2) : Cache.getCacheEntry((URL)launchDesc.getCanonicalHome(), null);
            if (cacheEntry == null) continue;
            LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((CacheEntry)cacheEntry);
            InformationDesc informationDesc = launchDesc.getInformation();
            LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
            if (localInstallHandler != null) {
                localInstallHandler.updateShortcutToLatestJRE(launchDesc, localApplicationProperties);
                continue;
            }
            return;
        }
    }

    public static void remove(boolean bl) {
        File[] fileArray2;
        ArrayList arrayList = Cache.getJnlpCacheEntries((boolean)Environment.isSystemCacheMode());
        ArrayList<Object> arrayList2 = bl ? new ArrayList() : CacheUtil.getExcludedCacheEntries(arrayList.iterator());
        for (File[] fileArray2 : arrayList) {
            LaunchDesc launchDesc = null;
            try {
                launchDesc = LaunchDescFactory.buildDescriptor((File)fileArray2, null, null, null);
            }
            catch (Exception exception) {
                Trace.println((String)"Cached jnlp file has no codebase", (TraceLevel)TraceLevel.CACHE);
                try {
                    launchDesc = LaunchDescFactory.buildDescriptor((File)fileArray2);
                }
                catch (Exception exception2) {
                    Trace.ignoredException((Exception)exception);
                }
            }
            if (launchDesc == null) continue;
            CacheUtil.remove((File)fileArray2, launchDesc, arrayList2);
        }
        if (Globals.isShortcutMode()) {
            return;
        }
        fileArray2 = Cache.getCacheEntries((boolean)Environment.isSystemCacheMode());
        for (int i = 0; i < fileArray2.length; ++i) {
            CacheEntry cacheEntry = Cache.getCacheEntryFromFile((File)fileArray2[i]);
            if (cacheEntry != null) {
                if (arrayList2.contains(cacheEntry.getIndexFile())) continue;
                Cache.removeCacheEntry((CacheEntry)cacheEntry);
                continue;
            }
            fileArray2[i].delete();
        }
        if (bl) {
            try {
                Cache.removeAllMuffins();
                Cache.removeAllLapFiles();
                CacheUtil.deleteRecursive(new File(Cache.getExtensionInstallDir()));
                new File(Config.getSplashIndex()).delete();
            }
            catch (Exception exception) {
                Trace.ignored((Throwable)exception);
            }
        }
    }

    public static ArrayList<File> getInstalledResources(boolean bl) {
        return CacheUtil.getExcludedCacheEntries(Cache.getJnlpCacheEntries((boolean)bl).iterator());
    }

    public static ArrayList<File> getExcludedCacheEntries(Iterator<File> iterator) {
        ArrayList<File> arrayList = new ArrayList<File>(){

            @Override
            public boolean add(File file) {
                if (!this.contains(file)) {
                    super.add(file);
                }
                return true;
            }
        };
        while (iterator.hasNext()) {
            CacheEntry cacheEntry;
            File file = iterator.next();
            File file2 = new File(file.getPath() + ".idx");
            LaunchDesc launchDesc = null;
            if (!file2.exists()) continue;
            try {
                launchDesc = LaunchDescFactory.buildDescriptor(file, null, null, null);
            }
            catch (BadFieldException badFieldException) {
                try {
                    cacheEntry = Cache.getCacheEntryFromFile((File)file2);
                    launchDesc = LaunchDescFactory.buildDescriptor(cacheEntry.getDataFile(), URLUtil.getBase((URL)new URL(cacheEntry.getURL())), null, new URL(cacheEntry.getURL()));
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
            CacheEntry cacheEntry2 = Cache.getCacheEntryFromFile((File)file2);
            if (launchDesc == null || cacheEntry2 == null || (cacheEntry = Cache.getLocalApplicationProperties((CacheEntry)cacheEntry2)) == null || !cacheEntry.isJnlpInstalled()) continue;
            CacheUtil.markResourcesInstalled(file2, launchDesc, cacheEntry2, arrayList);
        }
        return arrayList;
    }

    private static void markResourcesInstalled(File file, LaunchDesc launchDesc, CacheEntry cacheEntry, ArrayList<File> arrayList) {
        Object[] objectArray;
        Object object;
        arrayList.add(file);
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            CacheEntry cacheEntry2;
            Object object2;
            object = resourcesDesc.getLocalJarDescs();
            if (object != null) {
                for (int i = ((JARDesc[])object).length - 1; i >= 0; --i) {
                    URL uRL = ((JARDesc)object[i]).getLocation();
                    cacheEntry2 = Cache.getCacheEntry((URL)uRL, (String)(object2 = ((JARDesc)object[i]).getVersion()));
                    if (cacheEntry2 == null) continue;
                    arrayList.add(cacheEntry2.getIndexFile());
                }
            }
            if ((objectArray = resourcesDesc.getExtensionDescs()) != null) {
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    object2 = objectArray[i];
                    cacheEntry2 = Cache.getCacheEntry((URL)((ExtensionDesc)object2).getLocation(), (String)((ExtensionDesc)object2).getVersion());
                    if (cacheEntry2 == null) continue;
                    try {
                        Object object3 = LaunchDescFactory.buildDescriptor(cacheEntry2.getDataFile(), null, null, null);
                        if (object3 == null) continue;
                        CacheUtil.markResourcesInstalled(cacheEntry2.getIndexFile(), (LaunchDesc)object3, cacheEntry2, arrayList);
                        continue;
                    }
                    catch (Exception exception) {
                        Trace.ignored((Throwable)exception);
                    }
                }
            }
        }
        if ((object = launchDesc.getInformation()) != null) {
            RContentDesc[] rContentDescArray;
            Object object2;
            CacheEntry cacheEntry2;
            objectArray = ((InformationDesc)object).getIcons();
            if (objectArray != null) {
                for (Object object3 : objectArray) {
                    URL object5 = ((IconDesc)object3).getLocation();
                    if (object5 == null || (cacheEntry2 = Cache.getCacheEntry((URL)object5, (String)(object2 = ((IconDesc)object3).getVersion()))) == null) continue;
                    arrayList.add(cacheEntry2.getIndexFile());
                }
            }
            if ((rContentDescArray = ((InformationDesc)object).getRelatedContent()) != null) {
                for (RContentDesc rContentDesc : rContentDescArray) {
                    object2 = rContentDesc.getIcon();
                    if (object2 == null || (cacheEntry2 = Cache.getCacheEntry((URL)object2, null)) == null) continue;
                    arrayList.add(cacheEntry2.getIndexFile());
                }
            }
        }
    }

    public static void remove(CacheEntry cacheEntry) {
        try {
            LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(cacheEntry.getDataFile(), null, null, null);
            CacheUtil.remove(cacheEntry, launchDesc);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
    }

    public static void remove(File file, LaunchDesc launchDesc, ArrayList<File> arrayList) {
        File file2 = new File(file.getPath() + ".idx");
        if (file2.exists()) {
            CacheEntry cacheEntry = Cache.getCacheEntryFromFile((File)file2);
            if (cacheEntry != null) {
                if (!arrayList.contains(file2)) {
                    CacheUtil.remove(cacheEntry, launchDesc);
                }
            } else {
                file2.delete();
                file.delete();
            }
        } else if (file.exists() && ResourceProvider.get().getCacheDir().equals(file.getParentFile())) {
            file.delete();
        } else {
            CacheEntry cacheEntry = Cache.getCacheEntry((URL)launchDesc.getCanonicalHome(), null);
            if (cacheEntry != null && !arrayList.contains(cacheEntry.getIndexFile())) {
                CacheUtil.remove(cacheEntry, launchDesc);
            }
        }
    }

    public static void remove(CacheEntry cacheEntry, LaunchDesc launchDesc) {
        Object object;
        Object object2;
        int n;
        int n2;
        Object object3;
        Object object4;
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((CacheEntry)cacheEntry);
        InformationDesc informationDesc = launchDesc.getInformation();
        LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        if (localInstallHandler != null && launchDesc.isApplicationDescriptor()) {
            localInstallHandler.uninstall(launchDesc, localApplicationProperties, true);
        }
        if (Globals.isShortcutMode()) {
            return;
        }
        if (launchDesc.isApplicationDescriptor() && launchDesc.getLocation() != null) {
            Cache.saveRemovedApp((URL)launchDesc.getLocation(), (String)informationDesc.getTitle());
        }
        localApplicationProperties.refresh();
        if (localApplicationProperties.isExtensionInstalled() && launchDesc.isInstaller()) {
            object4 = new ArrayList();
            ((ArrayList)object4).add(cacheEntry.getDataFile());
            try {
                object3 = localApplicationProperties.getInstallDirectory();
                JnlpxArgs.executeUninstallers((ArrayList<File>)object4);
                JREInfo.removeJREsIn((String)object3);
                CacheUtil.deleteRecursive(new File((String)object3));
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
        }
        SplashScreen.removeCustomSplash(launchDesc);
        ApplicationIconGenerator.removeCustomIcon(launchDesc);
        if (informationDesc != null) {
            object4 = informationDesc.getIcons();
            if (object4 != null) {
                object3 = object4;
                n2 = ((Object)object3).length;
                for (n = 0; n < n2; ++n) {
                    Object object5 = object3[n];
                    object2 = ((IconDesc)object5).getLocation();
                    object = ((IconDesc)object5).getVersion();
                    CacheUtil.removeEntries((URL)object2, (String)object);
                }
            }
            if ((object3 = informationDesc.getRelatedContent()) != null) {
                Object object6 = object3;
                n = ((Object)object6).length;
                for (int i = 0; i < n; ++i) {
                    object2 = object6[i];
                    object = ((RContentDesc)object2).getIcon();
                    if (object == null) continue;
                    CacheUtil.removeEntries((URL)object, null);
                }
            }
        }
        if ((object4 = launchDesc.getResources()) != null) {
            ExtensionDesc[] extensionDescArray;
            object3 = ((ResourcesDesc)object4).getLocalJarDescs();
            if (object3 != null) {
                for (n2 = ((Object)object3).length - 1; n2 >= 0; --n2) {
                    URL uRL = ((JARDesc)object3[n2]).getLocation();
                    String string = ((JARDesc)object3[n2]).getVersion();
                    CacheUtil.removeEntries(uRL, string);
                }
            }
            if ((extensionDescArray = ((ResourcesDesc)object4).getExtensionDescs()) != null) {
                for (n = extensionDescArray.length - 1; n >= 0; --n) {
                    ExtensionDesc extensionDesc = extensionDescArray[n];
                    object2 = Cache.getCacheEntry((URL)extensionDesc.getLocation(), (String)extensionDesc.getVersion());
                    if (object2 == null) continue;
                    try {
                        object = LaunchDescFactory.buildDescriptor(object2.getDataFile(), null, null, null);
                        if (object == null || !((LaunchDesc)object).isInstaller()) continue;
                        CacheUtil.remove((CacheEntry)object2, (LaunchDesc)object);
                        continue;
                    }
                    catch (Exception exception) {
                        Trace.ignored((Throwable)exception);
                    }
                }
            }
        }
        object3 = cacheEntry.getURL();
        String string = cacheEntry.getVersion();
        try {
            URL uRL = new URL((String)object3);
            if (uRL != null) {
                CacheUtil.removeEntries(uRL, string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignored((Throwable)malformedURLException);
        }
        Cache.removeLoadedProperties((String)object3);
    }

    private static void removeEntries(URL uRL, String string) {
        if (uRL != null) {
            CacheEntry cacheEntry = Cache.getCacheEntry((URL)uRL, (String)string);
            Cache.removeAllCacheEntries((CacheEntry)cacheEntry);
        }
    }

    static File getCachedFileNative(URL uRL) {
        if (uRL.getProtocol().equals("jar")) {
            String string = uRL.getPath();
            int n = string.indexOf("!/");
            if (n > 0) {
                try {
                    String string2 = string.substring(n + 2);
                    URL uRL2 = new URL(string.substring(0, n));
                    String string3 = ResourceProvider.get().getLibraryDirForJar(string2, uRL2, null);
                    if (string3 != null) {
                        return new File(string3, string2);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Trace.ignored((Throwable)malformedURLException);
                }
                catch (IOException iOException) {
                    Trace.ignored((Throwable)iOException);
                }
            }
            return null;
        }
        Resource resource = ResourceProvider.get().getCachedResource(uRL, null);
        return resource != null ? resource.getDataFile() : null;
    }

    private static void deleteRecursive(File file) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                CacheUtil.deleteRecursive(file2);
            }
        }
        file.delete();
    }
}

