-- get CEGUI singletons
local logger = CEGUI.Logger:getSingleton()
logger:logEvent( ">>> Init script says hello" )
--logger:setLoggingLevel( CEGUI.Informative )

-- get a local reference to the singletons we use (not required)
local system    = CEGUI.System:getSingleton()
local fontman   = CEGUI.FontManager:getSingleton()
local schememan = CEGUI.SchemeManager:getSingleton()

-- load schemes
schememan:loadScheme( "boutLook.scheme" )

-- set default mouse cursor
system:setDefaultMouseCursor( "TaharezLook","MouseArrow" )

-- load a default font
system:setDefaultFont("Formal")

-- some key bindings
--sendcmd("gui", "bindkey", 16, "quit_game()")

function close_window(e)
  local we = CEGUI.toWindowEventArgs(e)
  we.window:hide()
end

logger:logEvent( "<<< Init script says goodbye" )
