-- get CEGUI singletons
local logger = CEGUI.Logger:getSingleton()
logger:logEvent( ">>> Init script says hello" )
--logger:setLoggingLevel( CEGUI.Informative )

-- get a local reference to the singletons we use (not required)
local system    = CEGUI.System:getSingleton()
local fontman   = CEGUI.FontManager:getSingleton()
local schememan = CEGUI.SchemeManager:getSingleton()

-- load schemes
schememan:loadScheme( "../data/gui/boutLook.scheme" )

-- set default mouse cursor
system:setDefaultMouseCursor( "boutLook","MouseArrow" )

-- load a default font
system:setDefaultFont("Formal")

-- some key bindings
sendcmd("gui", "bindkey", 16, "quit_game()")
sendcmd("gui", "bindkey", 59, "sendcmd('charactermanager', 'ToggleNavMesh')")
sendcmd("gui", "bindkey", 61, "sendcmd('scenemanager', 'ToggleDebugView')")

function close_window(e)
  local we = CEGUI.toWindowEventArgs(e)
  we.window:hide();
end

logger:logEvent( "<<< Init script says goodbye" )
