function console_submit_button(e)
  local tb = CEGUI.WindowManager:getSingleton():getWindow("console/Window1/Editbox")

  local command = tb:getText()
  tb:setText("")
  console_submit(command)
end

console_commands = {}
console_current_idx = 0

function console_submit(command)
	table.insert(console_commands, command)
	console_current_idx = table.getn(console_commands) +1
  execute(command)
end

function console_keydown(e)
	local ke = CEGUI.toKeyEventArgs(e)
	if ke.scancode == 200 then
		console_restore(-1)
	elseif ke.scancode == 208 then
		console_restore(1)
	elseif ke.scancode == 28 then
		console_submit_button()
	end
	
end

function console_restore(dir)
	
	console_current_idx  = console_current_idx + dir
	l = table.getn(console_commands)
	if console_current_idx < 1 then
		console_current_idx = 1
	elseif console_current_idx > l then
		console_current_idx = l
	end

	local tb = CEGUI.WindowManager:getSingleton():getWindow("console/Window1/Editbox")
	tb:setText(console_commands[console_current_idx])
	
	
end

function console_print(text)
	local winMgr = CEGUI.WindowManager:getSingleton()
	local newItem = CEGUI.createListboxTextItem(text, 0, nil, false, true)

	CEGUI.toListbox(winMgr:getWindow("console/Window1/Listbox")):addItem(newItem)
end