-- guter stuffs

WALK_ANIM = "skeletal/walk/loop/straight"
CANE_ANIM = "skeletal/idle/cane_threaten"

function quit_game()
	sendcmd("kage", "quit");
end

function puppet_play(name)
	sendcmd("puppet_crc", "play", name);
end;

function puppet_stop()
	sendcmd("puppet_crc", "stop");
end;

function puppet_reset()
	sendcmd("puppet_crc", "reset");
end;

function time_setflow(group, value)
	sendcmd("gametime", "settimeflow", group, value);
end;

function time_setcap(group, min, max)
	sendcmd("gametime","setmincap", group, min);
	sendcmd("gametime","setmaxcap", group, max);
end;

function fillInventory()
	AddItemToInventory("items_anleitung")
	AddItemToInventory("items_brechstange")
	AddItemToInventory("items_kaffeekanne")
	AddItemToInventory("items_muell_dose")
	AddItemToInventory("items_netz")
	AddItemToInventory("items_rattenhaare")
end;
function addDummys()
	AddItemToInventory("item1")
	AddItemToInventory("item2")
	AddItemToInventory("item3")
	AddItemToInventory("item4")
	AddItemToInventory("item5")
	AddItemToInventory("item6")
	AddItemToInventory("item7")
	AddItemToInventory("item8")
	AddItemToInventory("item9")
	AddItemToInventory("item10")
	AddItemToInventory("item11")
	AddItemToInventory("item12")
	AddItemToInventory("item13")
	AddItemToInventory("item14")
	AddItemToInventory("item15")
end;
-- flips stuffs

function AbortSequence( channel)
	sendcmd("game", "AbortSequence", channel)
end

function AddCharacterToParty( assetId )
	sendcmd("game", "AddCharacterToParty", assetId);
end
function RemoveCharacterFromParty( assetId )
	sendcmd("game", "RemoveCharacterFromParty", assetId);
end
function SetPartyTag( assetId, tag )
	sendcmd("game", "SetPartyTag", assetId, tag)
end
function AddCustomOverlay( id, material, x, y, width, height)
	sendcmd("gui", "addCustomOverlay", id, material, x, y, width, height)
end
function RemoveCustomOverlay( id )
	sendcmd("gui", "removeCustomOverlay", id)
end

function AddChoice( assetId, name, textparamname )
	sendcmd("game", "AddChoice", assetId, name, textparamname)
end

function AddItemToInteractionList( assetId, itemparamname )
	sendcmd("poolmanager", "AddItemToInteractionList", assetId, itemparamname, "")
end

function AddItemToInteractionListCrossreferenced( assetId, itemparamname )
	sendcmd("poolmanager", "AddItemToInteractionListCrossreferenced", assetId, itemparamname, "")
end

function AddItemToInteractionListConditioned( assetId, itemparamname, condition )
	sendcmd("poolmanager", "AddItemToInteractionList", assetId, itemparamname, condition)
end

function AddItemToInteractionListConditionedCrossreferenced( assetId, itemparamname, condition)
	sendcmd("poolmanager", "AddItemToInteractionListCrossreferenced", assetId, itemparamname, condition)
end

function AddItemToInventory( assetId )
	sendcmd("inventory", "AddItem", assetId)
end

function AddItemToInventoryOfCharacter( assetId, characterparamname)
	sendcmd("inventory", "AddItem", assetId, characterparamname)
end

function AddQuestText( assetId, questid, textparamname)
	sendcmd("game", "AddQuestText", assetId, questid, textparamname)
end

function AssetInState( assetId, statename )
	return sendcmd("poolmanager", "AssetInState", assetId, statename)
end

-- Does not work for avatars yet, only works for NPCs
function CharacterInDialog( assetId)
	return sendcmd("game", "CharacterInDialog", assetId);
end

function IsDialogActive()
	return sendcmd("game", "IsDialogActive");
end

function ClearChoices( )
	sendcmd("game", "ClearChoices")
end

function ClearInteractionList( assetId )
	sendcmd("poolmanager", "ClearInteractionList", assetId)
end

function ClearInventory( )
	sendcmd("inventory", "ClearInventory");
end

function ClearInventoryOfCharacter( assetId )
	sendcmd("inventory", "ClearInventory", assetId);
end

function DeleteQuest( questid )
	sendcmd("game", "DeleteQuest", questid)
end

function EnqueueBackgroundSequence( assetId, sequenceparamkey, channel )
	sendcmd("game", "EnqueueBackgroundSequence", assetId, sequenceparamkey, channel)
end

function EnqueueSequence( assetId, sequenceparamkey )
	sendcmd("game", "EnqueueSequence", assetId, sequenceparamkey)
end

function ExitDialog( )
	sendcmd("game", "ExitDialog")
end

function GetActiveSubTopicCount( assetid, characterparamkey, topicparamkey )
	if topicparamkey == nil then
		topicparamkey = ""
	end
	return sendcmd("poolmanager", "GetActiveSubTopicCount", assetid, characterparamkey, topicparamkey );
end

function GetCurrentCharacter( )
	return sendcmd("game", "GetCurrentCharacter")
end

function GetCurrentScene( )
	return sendcmd("game", "GetCurrentScene")
end

function GetCurrentSceneName( )
	return sendcmd("game", "GetCurrentSceneName")
end

function GetCurrentSceneOfCharacter( assetId )
	return sendcmd("poolmanager", "GetCurrentSceneOfCharacter", assetId);
end

function GetParam( assetId, key )
	return sendcmd("poolmanager", "GetParam", assetId, key)
end

--Types:
-- * character
-- * cutscene
-- * item
-- * minigame
-- * scene
-- * task
-- * topic

function GetAssetType( assetid )
	return sendcmd("poolmanager", "GetAssetType", assetid);
end

function GetSequenceCaller( channelid )
	if channelid == nil then
		channelid = -1
	end
	return sendcmd("game", "GetSequenceCaller", channelid)
end

function GetSequenceCallerType( channelid )
	if channelid == nil then
		channelid = -1
	end
	return sendcmd("game", "GetSequenceCallerType", channelid)
end

function GoToScene( assetId )
	sendcmd("scenemanager", "GoToScene", assetId)
end

function SwitchToScene( assetId )
	sendcmd("scenemanager", "SwitchToScene", assetId)
end

function PlayBackgroundSequence( assetId, sequenceparamkey, channel )
	sendcmd("game", "PlayBackgroundSequence", assetId, sequenceparamkey, channel)
end

function PlaySequence( assetId, sequenceparamkey )
	sendcmd("game", "PlaySequence", assetId, sequenceparamkey)
end

function QueryChoice( assetId )
	sendcmd("game", "QueryChoice", assetId);
end

function RemoveItemFromInteractionList( assetId, itemparamname )
	sendcmd("poolmanager", "RemoveItemFromInteractionList", assetId, itemparamname)
end

function RemoveItemFromInteractionListConditioned( assetId, itemparamname, condition )
	sendcmd("poolmanager", "RemoveItemFromInteractionList", assetId, itemparamname, condition)
end

function RemoveItemFromInteractionListCrossreferenced( assetId, itemparamname )
	sendcmd("poolmanager", "RemoveItemFromInteractionListCrossreferenced", assetId, itemparamname)
end

function RemoveItemFromInteractionListConditionedCrossreferenced( assetId, itemparamname, condition )
	sendcmd("poolmanager", "RemoveItemFromInteractionListCrossreferenced", assetId, itemparamname, condition)
end

function RemoveItemFromInventory( assetId )
	sendcmd("inventory", "RemoveItem", assetId)
end

function RemoveItemFromInventoryOfCharacter( assetId, characterparamname )
	sendcmd("inventory", "RemoveItem", assetId)
end

function MoveCharacterToScene( assetId, sceneparam, locationparam)
	RemoveCharacterFromAllScenes( assetId );
	
	if locationparam==nil then
		SetCurrentSceneOfCharacter(assetId, sceneparam);
	else
		SetLocationOfCharacter(assetId, sceneparam, locationparam)
	end
end

function RemoveCharacterFromCertainScene( assetId, sceneparam )
	sendcmd("scenemanager", "RemoveCharacterFromScene", assetId, sceneparam)
end

function RemoveCharacterFromScene( assetId )
	sendcmd("scenemanager", "RemoveCharacterFromScene", assetId)
end

function RemoveCharacterFromAllScenes( assetId )
	sendcmd("scenemanager", "RemoveCharacterFromAllScenes", assetId)
end

function RemoveItemFromCertainScene( assetId, sceneparam )
	sendcmd("scenemanager", "RemoveItemFromScene", assetId, sceneparam)
end

function RemoveItemFromScene( assetId )
	sendcmd("scenemanager", "RemoveItemFromScene", assetId)
end

function SendToAsset( assetId, eventString, data )
	if data==nil then
		data = "";
	end
	sendcmd("poolmanager", "SendToAsset",assetId, eventString, data)
end

function SendToAssetDelayed( assetId, eventString, data, delaytime )
	if data==nil then
		data = "";
	end
	sendcmd("poolmanager", "SendToAssetDelayed",assetId, eventString, data, delaytime)
end

function SetCurrentCharacter(assetid)
	sendcmd("game", "SetCurrentCharacter", assetid)
end

function SetCurrentCharacterName( assetId, textparamname )
	sendcmd("poolmanager", "SetCurrentCharacterName",assetId, textparamname)
end

function SetCurrentMouseOverText( assetId, textparamname )
	sendcmd("poolmanager", "SetCurrentMouseOverText", assetId, textparamname, "", "");
end
function SetCurrentMouseOverTextConditioned( assetId, textparamname, itemparam, condition )
	if condition==nil then
		condition ="";
	end
	sendcmd("poolmanager", "SetCurrentMouseOverText", assetId, textparamname, itemparam, condition);
end

function SetCurrentMouseOverTextConditionedCrossreferenced( assetId, textparamname, itemparamname, condition )
	if condition==nil then
		condition ="";
	end
	sendcmd("poolmanager", "SetCurrentMouseOverTextCrossreferenced", assetId, textparamname, itemparamname, condition);
end

function SetCurrentSceneOfCharacter( assetId, sceneparamname )
	sendcmd("poolmanager", "SetCurrentSceneOfCharacter", assetId, sceneparamname);
end
function SetCurrentChapter(chaptername)
	sendcmd("game", "SetCurrentChapter", chaptername)
end
function SetInteractionMode( assetId, mode )
	sendcmd("poolmanager", "SetInteractionMode", assetId, mode)
end

function SetInteractionFlags( assetId, flags )
	sendcmd("poolmanager", "SetInteractionFlags", assetId, flags)
end

function SetInteractionSequence( assetId, mode, sequenceparamname )
	sendcmd("poolmanager", "SetInteractionSequence", assetId, mode, sequenceparamname)
end

function SetNotAllowedInteractionSequence( assetId, sequenceparamname )
	sendcmd("poolmanager", "SetNotAllowedInteractionSequence", assetId, sequenceparamname)
end


function SetQuestSlotText(assetId, questid, slotid, textparamname, done)
	sendcmd("poolmanager", "SetQuestSlotText", assetId, questid, slotid, textparamname, done)
end

function SetQuestTitle( assetId, questid, textparamname)
	sendcmd("poolmanager", "SetQuestTitle", assetId, questid, textparamname)
end

function SetTopicTitle( assetId, titleparamname )
	sendcmd("poolmanager", "SetTopicTitle", assetId, titleparamname)
end

function SetTopicSequence( assetId, sequenceparamname )
	sendcmd("poolmanager", "SetTopicSequence", assetId, sequenceparamname)
end

function SetUsedByInteractionSequence( assetId, itemparamname, sequenceparamname )
	sendcmd("poolmanager", "SetUsedByInteractionSequence", assetId,itemparamname, sequenceparamname, "")
end

function SetUsedByInteractionSequenceConditioned( assetId, itemparamname, sequenceparamname, conditionstate )
	if conditionstate==nil then
		conditionstate ="";
	end
	sendcmd("poolmanager", "SetUsedByInteractionSequence", assetId,itemparamname, sequenceparamname, conditionstate)
end

function SetUsedByInteractionSequenceConditionedCrossreferenced( assetId, itemparamname, sequenceparamname, conditionstate)
	if conditionstate==nil then
		conditionstate ="";
	end
	sendcmd("poolmanager", "SetUsedByInteractionSequenceCrossreferenced", assetId, itemparamname, sequenceparamname, conditionstate)
end

function SetUsedByInteractionSequenceCrossreferenced( assetId, itemparamname, sequenceparamname)
	sendcmd("poolmanager", "SetUsedByInteractionSequenceCrossreferenced", assetId, itemparamname, sequenceparamname, "")
end

function SetLocation( assetId, sceneparamname, locatioparamname )
	sendcmd("scenemanager", "SetLocation", assetId, sceneparamname, locatioparamname)
end

function SetLocationOfCharacter( assetId, sceneparamname, locatioparamname )
	sendcmd("scenemanager", "SetLocationOfCharacter", assetId, sceneparamname, locatioparamname)
end

function SetNoTopicSequence( assetId, sequenceparamname )
	sendcmd("poolmanager", "SetNoTopicSequence", assetId, sequenceparamname);
end

function SetNoTopicSequenceForCharacter( assetId, sequenceparamname, characterparamname )
	sendcmd("poolmanager", "SetNoTopicSequence", assetId, sequenceparamname, characterparamname);
end

function SetTopicActive( assetId, state )
	sendcmd("poolmanager", "SetTopicActive", assetId, state)
end

function SetVisualState( assetId, statename )
	sendcmd("scenemanager", "SetVisualState", assetId, statename)
end

function StartDialog( assetId )
	sendcmd("game", "StartDialog", assetId)
end

function StartSubDialog( assetId, parenttopicparam )
	sendcmd("game", "StartSubDialog", assetId, parenttopicparam); 
end

function StartMinigame( assetId, minigameparamname )
	sendcmd("game", "StartMinigame", assetId, minigameparamname);
end

function StartMinigameByName( minigamename )
	sendcmd("game", "StartMinigame", minigamename);
end

function StopMinigame( )
	sendcmd("game", "StopMinigame");
end

function IsMinigameActive()
	return sendcmd("game", "IsMinigameActive");
end

function UseItem( assetId )
	sendcmd("game", "UseItem", assetId)
end

function AddItem( item_name, position_name)
	if position_name == nil then
		sendcmd("itemmanager", "AddItem", item_name);
	else
		sendcmd("itemmanager", "AddItem", item_name, position_name);
	end
end

function RemoveItem( item_name )
	sendcmd("itemmanager", "RemoveItem", item_name);
end

function AddCharacter( char_name, position_name)
	sendcmd("charactermanager", "AddCharacter", char_name, position_name);
end

function RemoveCharacter( char_name )
	sendcmd("charactermanager", "RemoveCharacter", char_name);
end

function SetNavmesh( navmesh_name, sceneid )
	if sceneid == nil then
		sendcmd("game", "SetNavmesh", navmesh_name);
	else
		sendcmd("game", "SetNavmesh", navmesh_name, sceneid);
	end
end

function SetCookieTexture(lightname, texturename)
	sendcmd("scenemanager", "SetCookieTexture", lightname, texturename);
end

function SetLocalSurfaceId(navmesh_name, surfaceid, px, py, pz, rx, ry, rz)
	sendcmd("game", "SetLocalSurfaceId", navmesh_name, surfaceid, px, py, pz, rx, ry, rz);
end

function SetToSceneNode( assetId, sceneNode_name )
	sendcmd("scenemanager", "SetToSceneNode", assetId, sceneNode_name );
end

function PlayMusic(musicid, fadetime, damponspeach, loop)
	if fadetime==nil then
		fadetime = 0;
	end
	if damponspeach==nil then
		damponspeach = true;
	end
	if loop == nil then
		loop = false
	end
	sendcmd("sound", "PlayMusic", musicid, fadetime, damponspeach, loop);
end

function PlaySound(soundid, volume)
	if volume == nil then
		sendcmd("sound", "PlaySound", soundid);
	else
		sendcmd("sound", "PlaySound", soundid, volume);
	end
end

function PlaySurroundSound(soundid, x, y, z)
	sendcmd("sound", "PlaySound", soundid, x, y, z);
end

function SetEffectActive(effectname, state)
	if state == nil then
		state = true;
	end
	sendcmd("effectmanager", "SetActive", effectname, state);
end

function FadeToBlack(fadetime)
	if fadetime==nil then
		fadetime = 1;
	end
	sendcmd("scenemanager", "FadeToBlack", fadetime);
end

function FadeFromBlack(fadetime)
	if fadetime==nil then
		fadetime = 1;
	end
	sendcmd("scenemanager", "FadeFromBlack", fadetime);
end

function StartChapter(chapter)
	sendcmd("game", "StartChapter", chapter);
end

function UnlockChapter(chapter)
	sendcmd("game", "UnlockChapter", chapter);
end

function GameOver()
	sendcmd("game", "GameOver");
end

function EnableLight(lightname)
	sendcmd("scenemanager", "EnableLight", lightname);
end

function DisableLight(lightname)
	sendcmd("scenemanager", "DisableLight", lightname);
end

function AddLightMask(assetid, lightname)
	sendcmd('scenemanager', 'AddLightMask', assetid, lightname)
end

function RemoveLightMask(assetid, lightname)
	sendcmd('scenemanager', 'RemoveLightMask', assetid, lightname)
end

function SetLightMask(assetid, mask)
	sendcmd('scenemanager', 'SetLightMask', assetid, mask)
end

function ActivateBackdrop(backdropname)
	sendcmd("scenemanager", "ActivateBackdrop", backdropname);
end	

--ScaleCharacter('characters_gnom',0.3,2.0)
function ScaleCharacter(charId, scale, scaletime)
	if scaletime==nil then
		scaletime = 1;
	end
	sendcmd("charactermanager", "Scale", charId, scale, scaletime);
end	

--SwapMaterial('Gnom_headlegs','Gnom_funny_headlegs')
--SwapMaterial('Gnom_funny_headlegs','Gnom_headlegs')
function SwapMaterial(oldMat, newMat)
	sendcmd("scenemanager", "SwapMaterial", oldMat, newMat);
end

function SetCertainMaterial(item_name, submesh_name, index, material)
	sendcmd("itemmanager", "ChangeCertainMaterial", item_name, submesh_name, index, material);
end

function SetItemIconTag(itemid, tag)
	if tag == nil then
		tag = "";
	end
	sendcmd("inventory", "SetItemIconTag", itemid, tag);
end

function SetTriggerEnabled(triggerid, state)
	if state == nil then
		state = true
	end
	sendcmd("triggermanager", "SetEnabled", triggerid, state)
end

function ShowBlobShadow(characterid)
	sendcmd("charactermanager", "ShowBlobShadow", characterid)
end

function HideBlobShadow(characterid)
	sendcmd("charactermanager", "HideBlobShadow", characterid)
end

function ShowCharacterSubmesh(characterid, submeshid)
	sendcmd("charactermanager", "ShowSubMesh", characterid, submeshid)
end

function HideCharacterSubmesh(characterid, submeshid)
	sendcmd("charactermanager", "HideSubMesh", characterid, submeshid)
end

function ShowCharacterSlave(characterid, slaveid)
	sendcmd("charactermanager", "ShowSlave", characterid, slaveid)
end

function HideCharacterSlave(characterid, slaveid)
	sendcmd("charactermanager", "HideSlave", characterid, slaveid)
end

function SetSubMeshAssetRef(characterid, submeshid, assetref)
	sendcmd("charactermanager", "SetSubMeshAssetRef", characterid, submeshid, assetref)
end

function ShowItemSubmesh(itemid, submeshid)
	sendcmd("itemmanager", "ShowSubMesh", itemid, submeshid)
end

function HideItemSubmesh(itemid, submeshid)
	sendcmd("itemmanager", "HideSubMesh", itemid, submeshid)
end

function PlayItemAnimation(itemid, animationname, parentnodename)
	if parentnodename == nil then
		sendcmd('itemmanager', 'PlayItemAnimation', itemid, animationname)
	else
		sendcmd('itemmanager', 'PlayItemAnimation', itemid, animationname, parentnodename)
	end
end

function StopItemAnimation(itemid)
	sendcmd('itemmanager', 'StopItemAnimation',itemid)
end

function StartPatchAnimation(patchId)
	sendcmd('scenemanager', 'StartPatchAnimation', patchId)
end

function StopPatchAnimation(patchId)
	sendcmd('scenemanager', 'StopPatchAnimation', patchId)
end

function SetSceneNodeVisible(scenenodename, visible)
	sendcmd('scenemanager', 'SetSceneNodeVisible', scenenodename, visible)
end

function SetPatchVisible(patchid, visible)
	sendcmd('scenemanager', 'SetPatchVisible', patchid, visible)
end

function GetPatchVisible(patchid)
	return sendcmd('scenemanager', 'GetPatchVisible', patchid)
end

function SetPatchPosition(patchid, posx, posy)
	sendcmd('scenemanager', 'SetPatchPosition', patchid, posx, posy)
end

function GetValue(valuesource)
	return sendcmd('valuemanager', 'GetValue', valuesource)
end
function SetValue(valuesource, value)
	sendcmd('valuemanager', 'SetValue', valuesource, value)
end
function SetCharacterSpeachPosition(charid, posname)
	if posname == nil then
		posname = ""
	end
	sendcmd('charactermanager', 'SetSpeachPosition', charid, posname);
end
function SetCustomOPofCharacter(charid, opname)
	if opname == nil then
		opname = ""
	end
	sendcmd('charactermanager', 'SetCustomOP', charid, opname);
end
function SetExamineDistanceOfCharacter(charid, exDist)
	if exDist == nil then
		exDist = -1
	end
	sendcmd('charactermanager', 'SetExamineDistance', charid, exDist);
end
function BlockInteraction(state)
	if state == nil then
		state = true
	end
	sendcmd('scenemanager', 'BlockInteraction', state)
end	
function InMode(mode)
	if _globals.difficulty == nil then
		_globals.difficulty = 0
	end
	return _globals.difficulty == mode;
end
function GetTaggedAssets(taglist, result)
	return sendcmd("poolmanager", "GetTaggedAssets", taglist, result);
end
function GetFlags(s)
	if s == 'IF_NO_INTERACTION' then
		return 65536;
	elseif s == 'IF_NO_MOUSEOVER' then
		return 131072;
	elseif s == 'IF_OFF' then
		return 196608;
	end
	return 0;
end
