[[FX]]

// Samplers
sampler2D albedoMap;

float4 vx_offset;

sampler2D aiMap = sampler_state
{
	Address = Clamp;
	Filter = Bilinear;
	MaxAnisotropy = 1;
};

// Contexts
context TRANSLUCENT
{
	VertexShader = compile GLSL VS_TRANSLUCENT;
	PixelShader = compile GLSL FS_TRANSLUCENT;
	ZWriteEnable = false;
	BlendMode = Blend;
}

[[VS_TRANSLUCENT]]
// =================================================================================================

#include "shaders/utilityLib/vertCommon.glsl"

uniform mat4 viewProjMat;
uniform vec3 viewerPos;
uniform vec4 vx_offset;

attribute vec3 vertPos;
attribute vec2 texCoords0;
attribute vec2 texCoords1;
varying vec4 pos, vsPos;
varying vec2 uv0;
varying vec2 uv1;

varying float fogFactor;
varying vec2 aiMapUV;

void main( void )
{
	pos = calcWorldPos( vec4( vertPos, 1.0 ) );

	vsPos = calcViewPos( pos );
	uv0 = texCoords0;
	uv1 = texCoords1;

	uv0.y -= vx_offset.y * 0.3;

	gl_Position = viewProjMat * pos;

	// FOG
	float _dist = length(vsPos);
	if (  _dist >= gl_Fog.start )
	{
		fogFactor = clamp( ((_dist-gl_Fog.start)/gl_Fog.end) , 0.0 , 1.0);
	}
	else
	{
		fogFactor = 0.0;
	}

	aiMapUV.s = (pos.x + 637.0) / 1278.1; // should be: 640,1280
	aiMapUV.t = (pos.z + 637.0) / 1278.1; // should be: 640,1280
}

[[FS_TRANSLUCENT]]
// =================================================================================================

uniform sampler2D albedoMap;
uniform sampler2D aiMap;
varying vec2 uv0;
varying vec2 uv1;
varying float fogFactor;
varying vec2 aiMapUV;

void main( void )
{
	vec4 col0 = texture2D( albedoMap, vec2(uv0.s,uv0.t*-1.0) );
	vec4 col1 = texture2D( albedoMap, vec2(uv1.s,uv1.t*-1.0) );
	gl_FragColor.rgb = vec3(1.0,1.0,1.0);
	gl_FragColor.a = col0.g * col1.b;

	// aimap
	gl_FragColor.rgb *= texture2D( aiMap, aiMapUV.st ).a;

	// FOG
	gl_FragColor.rgb += ( gl_Fog.color.rgb - gl_FragColor.rgb ) * fogFactor;
}
