// *************************************************************************************************
// Horde3D Shader Utility Library
// --------------------------------------
//		- Particle functions -
//
// Copyright (C) 2006-2011 Nicolas Schulz
//
// You may use the following code in projects based on the Horde3D graphics engine.
//
// *************************************************************************************************

#define OPENGL_4_SUPPORT

uniform mat4 viewMatInv;
uniform vec3 parPosArray[64];
uniform vec2 parSizeAndRotArray[64];
#ifdef OPENGL_4_SUPPORT
uniform uvec2 parColorAndUVArray[64]; // opengl 4.x
#else
uniform vec4 parColorArray[64];
uniform vec4 parUVArray[64];
#endif

attribute float parIdx;

vec4 getParticleColor()
{
#ifdef OPENGL_4_SUPPORT
	return unpackUnorm4x8( parColorAndUVArray[int( parIdx )].x ); // opengl 4.x
#else
	return parColorArray[int( parIdx )];
#endif
}

vec4 getParticleUV()
{
#ifdef OPENGL_4_SUPPORT
	return unpackUnorm4x8( parColorAndUVArray[int( parIdx )].y ); // opengl 4.x
#else
	return parUVArray[int( parIdx )];
#endif
}

vec3 calcParticlePos( const vec2 texCoords )
{
	int index = int( parIdx );
	vec3 camAxisX = viewMatInv[0].xyz;
	vec3 camAxisY = viewMatInv[1].xyz;
	
	vec2 cornerPos = texCoords - vec2( 0.5, 0.5 );
	
	// Apply rotation
	float s = sin( parSizeAndRotArray[index].y );
	float c = cos( parSizeAndRotArray[index].y );
	cornerPos = mat2( c, -s, s, c ) * cornerPos;
	
	return parPosArray[index] + (camAxisX * cornerPos.x + camAxisY * cornerPos.y) * parSizeAndRotArray[index].x;
}
