[[FX]]

// Samplers
sampler2D SceneBuffer = sampler_state
{
	Address = Clamp;
};

// Contexts
context TRANSFER
{
	VertexShader = compile GLSL VS_FSQUAD;
	PixelShader = compile GLSL FS_FINALPASS;
	
	ZWriteEnable = false;
}


[[VS_FSQUAD]]
// =================================================================================================

uniform mat4 projMat;
attribute vec3 vertPos;
//attribute vec2 texCoords0;
varying vec2 texCoords;
				
void main( void )
{
	texCoords = vertPos.xy;
	gl_Position = projMat * vec4( vertPos, 1 );
}


[[FS_FINALPASS]]
// =================================================================================================

uniform sampler2D SceneBuffer;
varying vec2 texCoords;

void main( void )
{
	gl_FragColor = texture2D( SceneBuffer, texCoords );
}
