[[FX]]

// Supported Flags
/* ---------------
	_F07_UVAnim
	_F08_SoftParticles
*/

// Samplers
sampler2D albedoMap = sampler_state
{
	Filter = Bilinear;
	MaxAnisotropy = 1;
};

sampler2D depthBuf = sampler_state
{
	Address = Clamp;
};

// Contexts
/*context SHADOWMAP
{
	VertexShader = compile GLSL VS_SHADOWMAP;
	PixelShader = compile GLSL FS_SHADOWMAP;
}*/

context TRANSLUCENT
{
	VertexShader = compile GLSL VS_TRANSLUCENT;
	PixelShader = compile GLSL FS_TRANSLUCENT;
	
	ZWriteEnable = false;
	BlendMode = AddBlended;
}


[[VS_SHADOWMAP]]
// =================================================================================================

#include "shaders/utilityLib/vertParticle.glsl"

uniform mat4 viewProjMat;
uniform vec4 lightPos;
attribute vec2 texCoords0;
varying float dist;

void main(void)
{
	vec4 pos = vec4( calcParticlePos( texCoords0 ), 1 );
	dist = length( lightPos.xyz - pos.xyz ) / lightPos.w;
	
	gl_Position = viewProjMat * pos;
}
				
				
[[FS_SHADOWMAP]]
// =================================================================================================

uniform float shadowBias;
varying float dist;

void main( void )
{
	gl_FragDepth = dist + shadowBias;
}


[[VS_TRANSLUCENT]]
// =================================================================================================

#include "shaders/utilityLib/vertParticle.glsl"
#include "shaders/utilityLib/vertCommon.glsl"

uniform mat4 viewProjMat;
attribute vec2 texCoords0;
varying vec4 color;
varying vec2 texCoords;
varying vec4 vsPos;
varying float fogFactor;
#ifdef _F08_SoftParticles
	varying vec4 vpos;
#endif

void main(void)
{
	color = getParticleColor();

#ifndef _F07_UVAnim
	texCoords = vec2( texCoords0.s, -texCoords0.t );
#else
	vec4 uv = getParticleUV();
	float uu = uv.x + (texCoords0.s*uv.z);
	float vv = uv.y - (texCoords0.t*uv.w) + uv.w;
	texCoords = vec2( uu, vv );
#endif

	vsPos = vec4( calcParticlePos( texCoords0 ), 1 );
	gl_Position = viewProjMat * vsPos;

#ifdef _F08_SoftParticles
	vpos = gl_Position;
#endif

	// FOG
	float _dist = length(calcViewPos(vsPos));
	if (  _dist >= gl_Fog.start )
	{
		fogFactor = clamp( ((_dist-gl_Fog.start)/gl_Fog.end) , 0.0 , 1.0);
	}
	else
	{
		fogFactor = 0.0;
	}

}


[[FS_TRANSLUCENT]]
// =================================================================================================

uniform sampler2D albedoMap;
varying vec4 color;
varying vec2 texCoords;
varying float fogFactor;

#ifdef _F08_SoftParticles
	uniform sampler2D depthBuf;
	varying vec4 vpos;
#endif


void main( void )
{
	vec4 albedo = texture2D( albedoMap, texCoords );
	
	gl_FragColor = albedo * color;

	// FOG
	gl_FragColor.rgb += ( gl_Fog.color.rgb - gl_FragColor.rgb ) * fogFactor;

#ifdef _F08_SoftParticles   
	const float scale = 20000.0;
	vec3 fragCoord = (vpos.xyz / vpos.w) * 0.5 + 0.5;
	float sceneDepth = texture2D( depthBuf, fragCoord.xy ).x;
	gl_FragColor.a *= clamp((sceneDepth - fragCoord.z) * scale, 0.0, 1.0);
#endif

}
