[[FX]]

/*
	_F07_Grass
	_F08_Shear
	_F09_UVShiftAuto
	_F10_AlphaChannel
*/

// Samplers
sampler2D albedoMap;

float4 vx_offset;

sampler2D aiMap = sampler_state
{
	Address = Clamp;
	Filter = Bilinear;
	MaxAnisotropy = 1;
};

// Contexts
context TRANSLUCENT
{
	VertexShader = compile GLSL VS_TRANSLUCENT;
	PixelShader = compile GLSL FS_TRANSLUCENT;
	ZWriteEnable = false;
	BlendMode = Blend;
}

[[VS_TRANSLUCENT]]
// =================================================================================================

#include "shaders/utilityLib/vertCommon.glsl"

uniform mat4 viewProjMat;
uniform vec3 viewerPos;

attribute vec3 vertPos;
attribute vec2 texCoords0;
varying vec4 pos, vsPos;
varying vec2 texCoords;

#ifdef _F07_Grass
	attribute vec2 texCoords1;
	uniform vec4 vx_offset;
#endif

#ifdef _F08_Shear
	attribute vec2 texCoords1;
	uniform vec4 vx_offset;
#endif

#ifdef _F09_UVShiftAuto
	uniform vec4 vx_offset;
#endif

varying float fogFactor;
varying vec2 aiMapUV;

void main( void )
{
	pos = calcWorldPos( vec4( vertPos, 1.0 ) );

// advanced shear for grass
#ifdef _F07_Grass
	pos.x += vx_offset.z*texCoords1.x+(sin(vx_offset.x+(pos.x/10.0))*texCoords1.x*0.5);
	pos.z += vx_offset.w*texCoords1.x-(cos(vx_offset.y+(pos.z/10.0))*texCoords1.x*0.5);
#endif

// simple shear for trees
#ifdef _F08_Shear
	pos.x += sin(vx_offset.x+(pos.x/10.0))*texCoords1.x*0.5;
	pos.z -= cos(vx_offset.y+(pos.z/10.0))*texCoords1.x*0.5;
#endif

	vsPos = calcViewPos( pos );
	texCoords = texCoords0;

#ifdef _F09_UVShiftAuto
	texCoords.y += vx_offset.x * 0.06;
#endif

	gl_Position = viewProjMat * pos;

	// FOG
	float _dist = length(vsPos);
	if (  _dist >= gl_Fog.start )
	{
		fogFactor = clamp( ((_dist-gl_Fog.start)/gl_Fog.end) , 0.0 , 1.0);
	}
	else
	{
		fogFactor = 0.0;
	}

	aiMapUV.s = (pos.x + 637.0) / 1278.1; // should be: 640,1280
	aiMapUV.t = (pos.z + 637.0) / 1278.1; // should be: 640,1280
}

[[FS_TRANSLUCENT]]
// =================================================================================================

uniform sampler2D albedoMap;
uniform sampler2D aiMap;
varying vec2 texCoords;
varying float fogFactor;
varying vec2 aiMapUV;

#ifdef _F10_AlphaChannel
	uniform vec4 customInstData[4];
#endif

void main( void )
{
	gl_FragColor = texture2D( albedoMap, vec2(texCoords.s,texCoords.t*-1.0) );

	// aimap
	gl_FragColor.rgb *= texture2D( aiMap, aiMapUV.st ).a;
#ifdef _F10_AlphaChannel
	gl_FragColor.rgb *= customInstData[0].rgb;
#endif

	// FOG
	gl_FragColor.rgb += ( gl_Fog.color.rgb - gl_FragColor.rgb ) * fogFactor;
#ifdef _F10_AlphaChannel
	gl_FragColor.a *= customInstData[0].a;
#endif
}
