//=========== (C) Copyright 1999 Valve, L.L.C. All rights reserved. ===========
//
// The copyright to the contents herein is the property of Valve, L.L.C.
// The contents may be used and/or copied only with the written permission of
// Valve, L.L.C., or in accordance with the terms and conditions stipulated in
// the agreement/contract under which the contents have been supplied.
//=============================================================================

// No spaces in event names, max length 32
// All strings are case sensitive
// total game event byte length must be < 1024
//
// valid data key types are:
//   none   : value is not networked
//   string : a zero terminated string
//   bool   : unsigned int, 1 bit
//   byte   : unsigned int, 8 bit
//   short  : signed int, 16 bit
//   long   : signed int, 32 bit
//   float  : float, 32 bit

"ModEvents"
{
//////////////////////////////////////////////////////////////////////
// Player events
//////////////////////////////////////////////////////////////////////
	"player_hurt"
	{
		"userid" "short"
		"weapon" "string"
		"hitgroup" "short"
		"priority" "short"
		"attacker" "short"
		"dmg_health" "short"
		"health" "byte"
	}

	"player_footstep"
	{
		"userid" "short"
	}

	"player_jump"
	{
		"userid" "short"
	}

	"player_blind"
	{
		"userid" "short"
	}

	"player_falldamage"
	{
		"userid" "short"
		"damage" "float"
	}

	"player_stats_updated"
	{
	}

	"player_avenged_teammate"
	{
		"avenger_id" "short"
		"avenged_player_id" "short"
	}

	"player_decal"
	{
		"userid" "short"
	}

	"player_death"
	{
		"damagebits" "short"
		"weapon" "string"
		"weaponid" "short"
		"userid" "short"
		"priority" "short"
		"attacker" "short"
		"customkill" "short"
		"lives" "short"
		"team" "short"
		"y" "float"
		"x" "float"
		"attackerteam" "short"
		"z" "float"
		"assister" "short"
		"deathflags" "short"
	}

	"player_drop"
	{
		"userid" "short"
		"entity" "short"
	}

	"player_receive_supply"
	{
		"userid" "short"
		"ammount" "short"
	}

	"player_bought_item"
	{
		"type" "short"
		"upgradeId" "short"
		"weaponId" "short"
		"userid" "short"
		"id" "short"
	}

	"player_sold_item"
	{
		"type" "short"
		"upgradeId" "short"
		"weaponId" "short"
		"userid" "short"
		"id" "short"
	}

	"player_first_spawn"
	{
		"userid" "short"
	}

	"player_suppressed"
	{
		"attacker" "short"
		"victim" "short"
	}
//////////////////////////////////////////////////////////////////////
// Weapon events
//////////////////////////////////////////////////////////////////////
	"weapon_fire"
	{
		"weaponid" "short"
		"userid" "short"
	}

	"weapon_fire_on_empty"
	{
		"weapon" "string"
		"userid" "short"
	}

	"weapon_outofammo"
	{
		"userid" "short"
	}

	"weapon_reload"
	{
		"userid" "short"
	}

	"grenade_bounce"
	{
		"userid" "short"
	}

	"bullet_impact"
	{
		"y" "float"
		"x" "float"
		"z" "float"
		"userid" "short"
	}

	"weapon_pickup"
	{
		"weaponid" "short"
		"userid" "short"
	}

	"weapon_ironsight"
	{
		"weaponid" "short"
		"userid" "short"
	}

	"grenade_thrown"
	{
		"userid" "short"
		"y" "float"
		"x" "float"
		"entityid" "long"
		"z" "float"
		"id" "short"
	}

	"grenade_detonate"
	{
		"userid" "short"
		"effectedEnemies" "short"
		"y" "float"
		"x" "float"
		"entityid" "long"
		"z" "float"
		"id" "short"
	}
//////////////////////////////////////////////////////////////////////
// Game events
//////////////////////////////////////////////////////////////////////
	"game_start"
	{
		"priority" "short"
	}

	"game_teams_switched"
	{
	}

	"game_newmap"
	{
		"mapname" "string"
	}
//////////////////////////////////////////////////////////////////////
// Round events
//////////////////////////////////////////////////////////////////////
	"round_start"
	{
		"priority" "short"
		"timelimit" "short"
		"lives" "short"
		"gametype" "short"
	}

	"round_end"
	{
		"winner" "byte"
		"player_top_t2" "byte"
		"player_top_t1" "byte"
	}

	"round_freeze_end"
	{
	}

	"round_restart"
	{
	}

	"round_begin"
	{
	}
//////////////////////////////////////////////////////////////////////
// Objective events
//////////////////////////////////////////////////////////////////////
	"controlpoint_initialized"
	{
	}

	"controlpoint_captured"
	{
		"priority" "short"
		"cp" "byte"
		"cappers" "string"
		"cpname" "string"
		"team" "byte"
	}

	"controlpoint_neutralized"
	{
		"priority" "short"
		"cp" "byte"
		"cappers" "string"
		"cpname" "string"
		"team" "byte"
	}

	"controlpoint_endtouch"
	{
		"player" "short"
		"team" "short"
		"area" "byte"
	}

	"controlpoint_starttouch"
	{
		"player" "short"
		"team" "short"
		"area" "byte"
	}
//////////////////////////////////////////////////////////////////////
// Miscellaneous events
//////////////////////////////////////////////////////////////////////
	"door_moving"
	{
		"entindex" "long"
		"userid" "short"
	}

	"nav_blocked"
	{
		"area" "long"
		"blocked" "bool"
	}

	"nav_generate"
	{
	}

	"achievement_info_loaded"
	{
	}

	"rank_mgr_ranks_calculated"
	{
	}

	"spec_target_updated"
	{
	}

	"spec_mode_updated"
	{
	}

	"hltv_changed_mode"
	{
		"newmode" "long"
		"oldmode" "long"
		"obs_target" "long"
	}

	"show_freezepanel"
	{
		"hits_taken" "short"
		"damage_given" "short"
		"hits_given" "short"
		"killer" "short"
		"damage_taken" "short"
		"victim" "short"
	}

	"hide_freezepanel"
	{
	}

	"freezecam_started"
	{
	}

	"achievement_earned"
	{
		"player" "byte"
		"achievement" "short"
	}

	"client_disconnect"
	{
	}

	"inventory_open"
	{
	}

	"inventory_close"
	{
	}

	"inventory_open_category"
	{
	}

	"inventory_close_category"
	{
	}

	"inventory_open_upgrades"
	{
	}

	"inventory_close_upgrades"
	{
	}

	"enter_spawnzone"
	{
		"userid" "short"
	}

	"exit_spawnzone"
	{
		"userid" "short"
	}

	"missile_launched"
	{
		"userid" "short"
		"y" "float"
		"x" "float"
		"entityid" "long"
		"z" "float"
		"id" "short"
	}

	"missile_detonate"
	{
		"userid" "short"
		"y" "float"
		"x" "float"
		"entityid" "long"
		"z" "float"
		"id" "short"
	}

	"smoke_grenade_expire"
	{
		"userid" "short"
		"y" "float"
		"x" "float"
		"entityid" "long"
		"z" "float"
		"id" "short"
	}

	"flag_pickup"
	{
		"priority" "short"
		"userid" "short"
	}

	"flag_drop"
	{
		"priority" "short"
		"userid" "short"
	}

	"object_destroyed"
	{
		"index" "short"
		"type" "byte"
		"weapon" "string"
		"weaponid" "short"
		"attacker" "byte"
		"team" "byte"
		"attackerteam" "byte"
		"cp" "short"
		"assister" "byte"
	}

	"time_class"
	{
		"seconds" "short"
		"userid" "short"
		"class" "short"
	}

	"time_weapon"
	{
		"seconds" "short"
		"weapon" "short"
		"userid" "short"
	}
}

